/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.REngine.REXP;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.plots.CompoundElementModel;
import org.rosuda.deducer.plots.DefaultPlotPanel;
import org.rosuda.deducer.plots.DeviceInterface;
import org.rosuda.deducer.plots.ElementListRenderer;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.Layer;
import org.rosuda.deducer.plots.PlotBuilderModel;
import org.rosuda.deducer.plots.PlotBuilderSubFrame;
import org.rosuda.deducer.plots.PlotController;
import org.rosuda.deducer.plots.PlottingElement;
import org.rosuda.deducer.plots.PlottingElementDialog;
import org.rosuda.deducer.plots.Scale;
import org.rosuda.deducer.plots.Template;
import org.rosuda.deducer.plots.TemplateEditView;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;
import org.rosuda.javaGD.JGDBufferedPanel;

public class PlotBuilder
extends TJFrame
implements ActionListener,
WindowListener {
    private JLayeredPane pane;
    private JPanel bottomPanel;
    private JPanel rightPanel;
    private JPanel topPanel;
    private JPanel defaultPlotPanel;
    private OkayCancelPanel okayCancel;
    private JTabbedPane addTabs;
    private JTabbedPane templateTabs;
    private JButton removeButton;
    private JButton disableButton;
    private JButton editButton;
    private JPanel addPanel;
    private JList elementsList;
    private JScrollPane elementsScroller;
    private JPanel elementsPanel;
    private HelpButton helpButton;
    private PlotBuilderSubFrame layerSheet;
    private JPanel shadow;
    private JPanel background;
    private PlotPanel device;
    private JPanel plotHolder;
    private MenuListener menuListener = new MenuListener();
    private Vector addElementTabNames;
    private HashMap addElementListModels;
    private PlotBuilderModel model;
    private PlotBuilderModel initialModel;
    private JList templateList;
    private static PlotBuilderModel lastModel;
    private static Vector elementPopupMenuItems;
    private boolean firstPlot = true;

    public PlotBuilder() {
        this(lastModel == null ? new PlotBuilderModel() : (PlotBuilderModel)lastModel.clone());
    }

    public PlotBuilder(PlotBuilderModel plotBuilderModel) {
        super("Plot builder", false, 91);
        try {
            PlotController.init();
            this.init();
            this.initGUI();
            this.setModel(plotBuilderModel);
            this.initialModel = (PlotBuilderModel)plotBuilderModel.clone();
            this.updatePlot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() {
        int n;
        this.addElementTabNames = new Vector();
        this.addElementListModels = new HashMap();
        String[] stringArray = PlotController.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addElementTabNames.add(stringArray[i]);
        }
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        Object[] objectArray = PlotController.getTemplates().values().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            defaultListModel.addElement(objectArray[n]);
        }
        this.addElementListModels.put(stringArray[0], defaultListModel);
        defaultListModel = new DefaultListModel();
        objectArray = PlotController.getGeoms().values().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            defaultListModel.addElement(objectArray[n]);
        }
        this.addElementListModels.put(stringArray[1], defaultListModel);
        defaultListModel = new DefaultListModel();
        objectArray = PlotController.getStats().values().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            defaultListModel.addElement(objectArray[n]);
        }
        this.addElementListModels.put(stringArray[2], defaultListModel);
        defaultListModel = new DefaultListModel();
        objectArray = PlotController.getScales().values().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            defaultListModel.addElement(objectArray[n]);
        }
        this.addElementListModels.put(stringArray[3], defaultListModel);
        defaultListModel = new DefaultListModel();
        objectArray = PlotController.getFacets().values().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            defaultListModel.addElement(objectArray[n]);
        }
        this.addElementListModels.put(stringArray[4], defaultListModel);
        defaultListModel = new DefaultListModel();
        objectArray = PlotController.getCoords().values().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            defaultListModel.addElement(objectArray[n]);
        }
        this.addElementListModels.put(stringArray[5], defaultListModel);
        defaultListModel = new DefaultListModel();
        objectArray = PlotController.getThemes().values().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            defaultListModel.addElement(objectArray[n]);
        }
        this.addElementListModels.put(stringArray[6], defaultListModel);
    }

    private void initGUI() {
        try {
            this.pane = new JLayeredPane();
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            AnchorLayout anchorLayout = new AnchorLayout();
            this.pane.setLayout((LayoutManager)anchorLayout);
            this.setDefaultCloseOperation(2);
            String[] stringArray = new TopPanelMouseListener();
            this.topPanel = new JPanel();
            Object object = new AnchorLayout();
            this.topPanel.setLayout((LayoutManager)object);
            this.pane.add((Component)this.topPanel, new AnchorConstraint(1, 0, 164, 0, 1, 2, 0, 1));
            this.pane.setLayer(this.topPanel, 10);
            this.topPanel.setPreferredSize(new Dimension(683, 137));
            this.topPanel.addMouseListener((MouseListener)stringArray);
            this.shadow = new JPanel();
            this.pane.add((Component)this.shadow, new AnchorConstraint(1, 1, 164, 1, 1, 2, 0, 1));
            this.pane.setLayer(this.shadow, 9);
            this.shadow.setPreferredSize(new Dimension(683, 283));
            this.shadow.setBackground(new Color(105, 105, 105));
            this.shadow.setVisible(false);
            this.background = new JPanel();
            this.pane.add((Component)this.background, new AnchorConstraint(0, 0, 0, 0, 2, 2, 2, 2));
            this.pane.setLayer(this.background, -1000);
            this.addPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.addPanel.setLayout(borderLayout);
            this.topPanel.add((Component)this.addPanel, new AnchorConstraint(11, 5, 996, 5, 1, 2, 1, 2));
            this.addPanel.setPreferredSize(new Dimension(659, 124));
            this.addPanel.addMouseListener((MouseListener)stringArray);
            this.addTabs = new JTabbedPane();
            this.addPanel.add((Component)this.addTabs, "Center");
            this.addTabs.setPreferredSize(new Dimension(659, 130));
            this.addTabs.addMouseListener((MouseListener)stringArray);
            this.addTabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = PlotBuilder.this.addTabs.getSelectedIndex();
                    if (n >= 4) {
                        PlotBuilder.this.retractTopPanel();
                    }
                }
            });
            for (int i = 0; i < this.addElementTabNames.size(); ++i) {
                String string = this.addElementTabNames.get(i).toString();
                DefaultListModel defaultListModel = (DefaultListModel)this.addElementListModels.get(string);
                JPanel jPanel = new JPanel();
                jPanel.addMouseListener((MouseListener)stringArray);
                jPanel.setLayout(new BorderLayout());
                this.addTabs.add(string, jPanel);
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.getHorizontalScrollBar().addMouseListener((MouseListener)stringArray);
                jScrollPane.getVerticalScrollBar().addMouseListener((MouseListener)stringArray);
                jScrollPane.setHorizontalScrollBarPolicy(32);
                jPanel.add(jScrollPane);
                jScrollPane.addMouseListener((MouseListener)stringArray);
                JList jList = new JList();
                jList.addMouseListener((MouseListener)stringArray);
                jList.setCellRenderer(new ElementListRenderer());
                if (string == "Scales") {
                    jList.setVisibleRowCount(2);
                } else {
                    jList.setVisibleRowCount(defaultListModel.getSize() / 11 + Math.min(defaultListModel.getSize() % 11, 1));
                }
                jList.setLayoutOrientation(2);
                jList.setModel(defaultListModel);
                jList.setDragEnabled(true);
                jList.setTransferHandler(new AddElementTransferHandler());
                jList.addMouseListener(new AddMouseListener());
                jScrollPane.setViewportView(jList);
                if (!string.equals("Templates")) continue;
                this.templateList = jList;
            }
            this.plotHolder = new JPanel();
            this.plotHolder.setLayout(new BorderLayout());
            this.plotHolder.setBorder(BorderFactory.createBevelBorder(1));
            this.defaultPlotPanel = new DefaultPlotPanel(this);
            this.plotHolder.add(this.defaultPlotPanel);
            this.pane.add(this.plotHolder, new AnchorConstraint(137, 158, 52, 22, 2, 2, 2, 1), 2);
            this.plotHolder.setPreferredSize(new Dimension(515, 391));
            this.plotHolder.setTransferHandler(new PanelTransferHandler());
            this.rightPanel = new JPanel();
            stringArray = new AnchorLayout();
            this.rightPanel.setLayout((LayoutManager)stringArray);
            this.pane.add(this.rightPanel, new AnchorConstraint(135, 1000, 52, 731, 2, 1, 2, 0), 4);
            this.rightPanel.setPreferredSize(new Dimension(160, 389));
            this.removeButton = new IconButton("/icons/stop_16.png", "Remove component", this, "remove");
            this.removeButton.setContentAreaFilled(false);
            this.rightPanel.add((Component)this.removeButton, new AnchorConstraint(872, 921, 925, 540, 1, 1, 0, 0));
            this.removeButton.setPreferredSize(new Dimension(21, 21));
            this.disableButton = new IconButton("/icons/reload_16.png", "Toggle active", this, "active");
            this.disableButton.setContentAreaFilled(false);
            this.rightPanel.add((Component)this.disableButton, new AnchorConstraint(872, 578, 913, 240, 1, 0, 0, 1));
            this.disableButton.setPreferredSize(new Dimension(21, 21));
            this.editButton = new IconButton("/icons/edit_16.png", "Edit component", this, "edit");
            this.editButton.setContentAreaFilled(false);
            this.rightPanel.add((Component)this.editButton, new AnchorConstraint(872, 190, 904, 100, 1, 0, 0, 1));
            this.editButton.setPreferredSize(new Dimension(21, 21));
            this.elementsPanel = new JPanel();
            object = new BorderLayout();
            this.elementsPanel.setLayout((LayoutManager)object);
            this.rightPanel.add((Component)this.elementsPanel, new AnchorConstraint(0, 928, 859, 90, 2, 1, 1, 1));
            this.elementsPanel.setPreferredSize(new Dimension(134, 334));
            this.elementsPanel.setBorder(BorderFactory.createTitledBorder("Components"));
            this.elementsScroller = new JScrollPane();
            this.elementsPanel.add((Component)this.elementsScroller, "Center");
            this.elementsList = new JList();
            this.elementsScroller.setViewportView(this.elementsList);
            this.elementsList.setCellRenderer(new ElementListRenderer());
            this.elementsList.setDragEnabled(true);
            this.elementsList.setSelectionMode(0);
            this.elementsList.addListSelectionListener(new ElementListListener());
            this.elementsList.setTransferHandler(new ElementTransferHandler());
            this.elementsList.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        PlottingElement plottingElement = (PlottingElement)PlotBuilder.this.elementsList.getSelectedValue();
                        PlotBuilder.this.openLayerSheet(plottingElement);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.maybePopup(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.maybePopup(mouseEvent);
                }

                public void maybePopup(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        int n = PlotBuilder.this.elementsList.locationToIndex(mouseEvent.getPoint());
                        if (n < 0) {
                            return;
                        }
                        ElementPopupMenu.element = (PlottingElement)PlotBuilder.this.model.getListModel().getElementAt(n);
                        ElementPopupMenu.elList = PlotBuilder.this.elementsList;
                        ElementPopupMenu.plot = PlotBuilder.this;
                        ElementPopupMenu.getPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.bottomPanel = new JPanel();
            stringArray = new AnchorLayout();
            this.bottomPanel.setLayout((LayoutManager)stringArray);
            this.pane.add((Component)this.bottomPanel, new AnchorConstraint(870, 1000, 1000, 0, 0, 1, 1, 1));
            this.bottomPanel.setPreferredSize(new Dimension(688, 59));
            this.helpButton = new HelpButton("pmwiki.php?n=Main.PlotBuilder");
            this.bottomPanel.add((Component)this.helpButton, new AnchorConstraint(364, 51, 872, 19, 0, 0, 1, 1));
            this.helpButton.setPreferredSize(new Dimension(36, 36));
            this.okayCancel = new OkayCancelPanel(true, true, this);
            this.bottomPanel.add((Component)this.okayCancel, new AnchorConstraint(127, 965, 872, 592, 0, 1, 1, 0));
            this.okayCancel.setPreferredSize(new Dimension(267, 39));
            stringArray = new String[]{"+", "File", "@N New", "new", "@O Open", "open", "@S Save", "save", "-", "Import template", "import", "+", "Tools", "View call", "call", "Make template", "template", "~Window", "0"};
            object = EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)this.menuListener, (String[])stringArray);
            this.setContentPane(this.pane);
            this.pack();
            this.addWindowListener(this);
            this.setSize(705, 620);
            this.setTitle("Plot Builder");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(PlotBuilderModel plotBuilderModel) {
        this.model = plotBuilderModel;
        this.elementsList.setModel(plotBuilderModel.getListModel());
        this.updateScaleList();
    }

    public PlotBuilderModel getModel() {
        return this.model;
    }

    public void updateScaleList() {
        Object[] objectArray = PlotController.getScales().values().toArray();
        DefaultListModel defaultListModel = (DefaultListModel)this.addElementListModels.get("Scales");
        defaultListModel.removeAllElements();
        String[] stringArray = this.model.getAes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < objectArray.length; ++j) {
                Scale scale = (Scale)((PlottingElement)objectArray[j]).getModel();
                if (!scale.aesName.equals(string)) continue;
                defaultListModel.addElement(objectArray[j]);
            }
        }
    }

    public void openLayerSheet(PlottingElement plottingElement) {
        this.closeLayerSheet();
        if (this.layerSheet == null) {
            this.layerSheet = new PlotBuilderSubFrame((Window)((Object)this));
            this.layerSheet.setSize(400, this.layerSheet.getHeight());
        }
        this.layerSheet.setElement(plottingElement);
        this.layerSheet.setVisible(true);
    }

    public void closeLayerSheet() {
        if (this.layerSheet != null && this.layerSheet.isVisible()) {
            this.layerSheet.setToInitialModel();
            this.layerSheet.setVisible(false);
        }
    }

    public void expandTopPanel() {
        this.topPanel.setPreferredSize(new Dimension(683, 280));
        this.shadow.setVisible(true);
        this.addTabs.revalidate();
        this.topPanel.repaint();
        this.topPanel.validate();
        this.validate();
        this.repaint();
    }

    public void retractTopPanel() {
        this.shadow.setVisible(false);
        this.topPanel.setPreferredSize(new Dimension(683, 137));
        this.addTabs.revalidate();
        this.topPanel.repaint();
        this.topPanel.validate();
        this.rightPanel.repaint();
        this.rightPanel.validate();
        this.background.validate();
        this.background.repaint();
    }

    public void plot(String string) {
        boolean bl;
        if (string == null || string == "") {
            return;
        }
        boolean bl2 = bl = this.device == null;
        if (bl) {
            this.plotHolder.removeAll();
            this.device = new PlotPanel(this.plotHolder.getWidth(), this.plotHolder.getHeight());
            this.device.setTransferHandler(new PanelTransferHandler());
            this.plotHolder.add((Component)((Object)this.device));
        }
        this.okayCancel.getApproveButton().setEnabled(false);
        final JLabel jLabel = new JLabel("plotting...");
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(Font.decode("Arial-BOLD-30"));
        jLabel.setForeground(Color.green);
        final String string2 = string;
        PlotBuilder plotBuilder = this;
        this.pane.add(jLabel, new AnchorConstraint(137, 158, 52, 22, 2, 2, 2, 1), 100);
        this.pane.setLayer(jLabel, 100);
        this.pane.validate();
        this.pane.repaint();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DeviceInterface.plot(string2, PlotBuilder.this.device);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlotBuilder.this.pane.remove(jLabel);
                        PlotBuilder.this.okayCancel.getApproveButton().setEnabled(true);
                        PlotBuilder.this.pane.validate();
                    }
                });
                try {
                    Thread.sleep(2000L);
                    PlotBuilder.this.firstPlot = false;
                    if (PlotBuilder.this.device != null) {
                        PlotBuilder.this.device.initRefresh();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void updatePlot() {
        String string = this.model.getCall();
        if (string != null && string != "ggplot()") {
            this.plot(string);
        }
        this.updateScaleList();
    }

    public void addElement(PlottingElement plottingElement) {
        Object object;
        final DefaultListModel defaultListModel = this.model.getListModel();
        final PlottingElement plottingElement2 = plottingElement;
        ElementModel elementModel = plottingElement2.getModel();
        if (plottingElement2.getModel() instanceof Layer) {
            object = (Layer)elementModel;
            this.model.tryToFillRequiredAess((Layer)object);
        }
        if ((object = elementModel.checkValid()) != null) {
            PlottingElementDialog plottingElementDialog = new PlottingElementDialog((JFrame)((Object)this), plottingElement2);
            plottingElementDialog.setModal(true);
            plottingElementDialog.setLocationRelativeTo((Component)((Object)this));
            plottingElementDialog.setVisible(true);
            object = plottingElement2.getModel().checkValid();
            if (object != null) {
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                defaultListModel.addElement(plottingElement2);
                PlotBuilder.this.updatePlot();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PlottingElement plottingElement;
        String string = actionEvent.getActionCommand();
        if (string == "Run") {
            String string2 = this.model.getCall();
            if (string2 == null || string2 == "ggplot()") {
                JOptionPane.showMessageDialog((Component)((Object)this), "Plot contains no components.");
                return;
            }
            lastModel = (PlotBuilderModel)this.model.clone();
            if (this.device != null) {
                this.device.devOff();
                this.plotHolder.remove((Component)((Object)this.device));
                this.device = null;
            }
            Deducer.execute("dev.new()\n" + string2);
            this.dispose();
        } else if (string == "Reset") {
            this.setModel(new PlotBuilderModel());
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "remove") {
            PlottingElement plottingElement2 = (PlottingElement)this.elementsList.getSelectedValue();
            if (plottingElement2 != null) {
                ((DefaultListModel)this.elementsList.getModel()).removeElement(plottingElement2);
                this.updatePlot();
            }
        } else if (string == "edit") {
            PlottingElement plottingElement3 = (PlottingElement)this.elementsList.getSelectedValue();
            if (plottingElement3 != null) {
                this.openLayerSheet(plottingElement3);
            }
        } else if (string == "active" && (plottingElement = (PlottingElement)this.elementsList.getSelectedValue()) != null) {
            plottingElement.setActive(!plottingElement.isActive());
            this.elementsList.validate();
            this.elementsList.repaint();
            this.updatePlot();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (this.device != null) {
            this.device.devOff();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public class PlotPanel
    extends JGDBufferedPanel {
        Dimension lastSize;

        public PlotPanel(double d, double d2) {
            super(d, d2);
            this.lastSize = this.getSize();
        }

        public PlotPanel(int n, int n2) {
            super(n, n2);
            this.lastSize = this.getSize();
        }

        public void devOff() {
            Deducer.eval("dev.off(" + (this.devNr + 1) + ")");
        }

        public void initRefresh() {
            Deducer.idleEval("try(.C(\"javaGDresize\",as.integer(" + this.devNr + ")),silent=TRUE)");
        }

        public synchronized void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (!dimension.equals(this.lastSize)) {
                REXP rEXP = Deducer.idleEval("try(.C(\"javaGDresize\",as.integer(" + this.devNr + ")),silent=TRUE)");
                if (rEXP != null) {
                    this.lastSize = dimension;
                }
                return;
            }
            super.paintComponent(graphics);
        }
    }

    public class MenuListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save")) {
                FileSelector fileSelector = new FileSelector((Frame)((Object)PlotBuilder.this), "Save plot", 1, null, true);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                JCheckBox jCheckBox = new JCheckBox("Save with data");
                jCheckBox.setSelected(true);
                jPanel.add(jCheckBox);
                fileSelector.addFooterPanel(jPanel);
                fileSelector.setVisible(true);
                if (fileSelector.getFile() != null) {
                    int n;
                    File file = fileSelector.getSelectedFile();
                    if (!file.getName().endsWith(".ggp")) {
                        file = new File(file.getPath() + ".ggp");
                    }
                    if (file.exists() && (n = JOptionPane.showConfirmDialog(null, "File exists: Overwrite: " + file.getName() + "?")) != 0) {
                        return;
                    }
                    PlotBuilder.this.model.saveToFile(file, jCheckBox.isSelected());
                }
            } else if (string.equals("open")) {
                FileSelector fileSelector = new FileSelector((Frame)((Object)PlotBuilder.this), "Open plot", 0, null, true);
                fileSelector.setVisible(true);
                if (fileSelector.getFile() != null) {
                    File file = fileSelector.getSelectedFile();
                    if (!file.getName().endsWith(".ggp")) {
                        JOptionPane.showMessageDialog(null, "This does not appear to be a ggplot2 PlotBuilder file (extension .ggp)");
                        return;
                    }
                    if (file != null && file.exists()) {
                        PlotBuilderModel plotBuilderModel = new PlotBuilderModel();
                        plotBuilderModel.setFromFile(file);
                        PlotBuilder.this.setModel(plotBuilderModel);
                        PlotBuilder.this.updatePlot();
                    }
                }
            } else if (string.equals("new")) {
                PlotBuilder plotBuilder = new PlotBuilder(new PlotBuilderModel());
                plotBuilder.setVisible(true);
                WindowTracker.addWindow((JFrame)((Object)plotBuilder));
            } else if (string.equals("template")) {
                DefaultListModel defaultListModel = PlotBuilder.this.model.getListModel();
                for (int i = 0; i < defaultListModel.size(); ++i) {
                    if (!(((PlottingElement)defaultListModel.get(i)).getModel() instanceof CompoundElementModel)) continue;
                    JOptionPane.showMessageDialog(null, "Can not create a template from a plot containing a template.");
                    return;
                }
                Template template = Template.makeTemplate(PlotBuilder.this.model);
                String string2 = JOptionPane.showInputDialog("template name (e.g. scatter)");
                if (string2 == "") {
                    string2 = "user";
                }
                if (string2 == null) {
                    return;
                }
                PlottingElement plottingElement = PlottingElement.createElement("template", string2);
                plottingElement.setModel(template);
                PlotBuilderModel plotBuilderModel = new PlotBuilderModel();
                plotBuilderModel.getListModel().addElement(plottingElement);
                PlotBuilder.this.setModel(plotBuilderModel);
                PlotBuilder.this.updatePlot();
            } else if (string.equals("import")) {
                FileSelector fileSelector = new FileSelector((Frame)((Object)PlotBuilder.this), "Import template", 0, null, true);
                fileSelector.setVisible(true);
                if (fileSelector.getFile() != null) {
                    File file = fileSelector.getSelectedFile();
                    if (!file.getName().endsWith(".ggtmpl")) {
                        JOptionPane.showMessageDialog(null, "This does not appear to be a ggplot2 template file (extension .ggtmpl)");
                        return;
                    }
                    if (file != null && file.exists()) {
                        PlottingElement plottingElement = new PlottingElement();
                        plottingElement.setFromFile(file);
                        PlotController.addTemplate(plottingElement);
                        ((DefaultListModel)PlotBuilder.this.templateList.getModel()).addElement(plottingElement);
                    }
                }
            } else if (string.equals("call")) {
                JFrame jFrame = new JFrame("Call");
                jFrame.setSize(700, 200);
                jFrame.setLayout(new BorderLayout());
                JTextArea jTextArea = new JTextArea();
                jFrame.add(jTextArea);
                jTextArea.setText(PlotBuilder.this.model.getCall() + "\n");
                jFrame.setLocationRelativeTo((Component)((Object)PlotBuilder.this));
                jFrame.setVisible(true);
            }
        }
    }

    class TopPanelMouseListener
    implements MouseListener {
        private boolean overComponent = false;

        TopPanelMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.overComponent = true;
            final int n = PlotBuilder.this.addTabs.getSelectedIndex();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        if (TopPanelMouseListener.this.overComponent && n < 4) {
                            PlotBuilder.this.expandTopPanel();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }).start();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.overComponent = false;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        if (!TopPanelMouseListener.this.overComponent) {
                            PlotBuilder.this.retractTopPanel();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }).start();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class AddElementTransferHandler
    extends TransferHandler {
        AddElementTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            return false;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            try {
                JList jList = (JList)jComponent;
                PlottingElement plottingElement = (PlottingElement)jList.getSelectedValue();
                if (plottingElement == null) {
                    return null;
                }
                PlotBuilder.this.retractTopPanel();
                return (PlottingElement)plottingElement.clone();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    class AddMouseListener
    implements MouseListener {
        AddMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent, true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent, false);
        }

        public void maybePopup(MouseEvent mouseEvent, boolean bl) {
            if (mouseEvent.isPopupTrigger()) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                AddElementPopupMenu.element = (PlottingElement)jList.getModel().getElementAt(n);
                AddElementPopupMenu.pBuilder = PlotBuilder.this;
                AddElementPopupMenu.getPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getClickCount() == 2 && bl) {
                Object object;
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                PlottingElement plottingElement = (PlottingElement)jList.getModel().getElementAt(n);
                PlottingElement plottingElement2 = (PlottingElement)plottingElement.clone();
                ElementModel elementModel = plottingElement2.getModel();
                boolean bl2 = false;
                if (plottingElement2.getModel() instanceof Layer) {
                    object = (Layer)elementModel;
                    PlotBuilder.this.model.tryToFillRequiredAess((Layer)object);
                    bl2 = true;
                }
                if ((object = elementModel.checkValid()) != null || !bl2) {
                    PlottingElementDialog plottingElementDialog = new PlottingElementDialog((JFrame)((Object)PlotBuilder.this), plottingElement2);
                    plottingElementDialog.setModal(true);
                    plottingElementDialog.setLocationRelativeTo((Component)((Object)PlotBuilder.this));
                    plottingElementDialog.setVisible(true);
                    object = plottingElement2.getModel().checkValid();
                    if (object != null || plottingElementDialog.getExitType() < 1) {
                        return;
                    }
                }
                PlotBuilder.this.model.getListModel().addElement(plottingElement2.clone());
                PlotBuilder.this.updatePlot();
            }
        }
    }

    class PanelTransferHandler
    extends TransferHandler {
        PanelTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            JList jList = PlotBuilder.this.elementsList;
            final DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
            try {
                final PlottingElement plottingElement = (PlottingElement)transferable.getTransferData(new DataFlavor(PlottingElement.class, "Plotting element"));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        ElementModel elementModel = plottingElement.getModel();
                        boolean bl = false;
                        if (plottingElement.getModel() instanceof Layer) {
                            object = (Layer)elementModel;
                            PlotBuilder.this.model.tryToFillRequiredAess((Layer)object);
                            bl = true;
                        }
                        if ((object = elementModel.checkValid()) != null || !bl) {
                            PlottingElementDialog plottingElementDialog = new PlottingElementDialog((JFrame)((Object)PlotBuilder.this), plottingElement);
                            plottingElementDialog.setModal(true);
                            plottingElementDialog.setLocationRelativeTo((Component)((Object)PlotBuilder.this));
                            plottingElementDialog.setVisible(true);
                            object = plottingElement.getModel().checkValid();
                            if (object != null || plottingElementDialog.getExitType() < 1) {
                                return;
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                defaultListModel.addElement(plottingElement);
                                PlotBuilder.this.updatePlot();
                            }
                        });
                    }
                }).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
    }

    class ElementListListener
    implements ListSelectionListener {
        ElementListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PlotBuilder.this.layerSheet != null && PlotBuilder.this.layerSheet.isVisible()) {
                PlotBuilder.this.closeLayerSheet();
            }
        }
    }

    class ElementTransferHandler
    extends TransferHandler {
        public int lastIndex = -1;
        public boolean selfTarget = false;

        ElementTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return dataFlavorArray.length == 1 && dataFlavorArray[0].equals(PlottingElement.DATAFLAVOR);
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                final JList jList = (JList)jComponent;
                final DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
                final PlottingElement plottingElement = (PlottingElement)transferable.getTransferData(new DataFlavor(PlottingElement.class, "Plotting element"));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        ElementModel elementModel = plottingElement.getModel();
                        if (plottingElement.getModel() instanceof Layer) {
                            object = (Layer)elementModel;
                            PlotBuilder.this.model.tryToFillRequiredAess((Layer)object);
                        }
                        if ((object = elementModel.checkValid()) != null) {
                            PlottingElementDialog plottingElementDialog = new PlottingElementDialog((JFrame)((Object)PlotBuilder.this), plottingElement);
                            plottingElementDialog.setModal(true);
                            plottingElementDialog.setLocationRelativeTo((Component)((Object)PlotBuilder.this));
                            plottingElementDialog.setVisible(true);
                            object = plottingElement.getModel().checkValid();
                            if (object != null) {
                                return;
                            }
                        }
                        final int n = jList.getSelectedIndex();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (n < 0) {
                                    defaultListModel.addElement(plottingElement);
                                } else {
                                    defaultListModel.insertElementAt(plottingElement, n + 1);
                                }
                                PlotBuilder.this.updatePlot();
                            }
                        });
                    }
                }).start();
                int n = jList.getSelectedIndex();
                if (n + 1 < this.lastIndex) {
                    ++this.lastIndex;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            JList jList = (JList)jComponent;
            PlottingElement plottingElement = (PlottingElement)jList.getSelectedValue();
            this.lastIndex = jList.getSelectedIndex();
            return plottingElement;
        }

        @Override
        public void exportDone(JComponent jComponent, Transferable transferable, int n) {
            try {
                if (n != 2) {
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        @Override
        public Icon getVisualRepresentation(Transferable transferable) {
            PlottingElement plottingElement;
            try {
                plottingElement = (PlottingElement)transferable.getTransferData(new DataFlavor(PlottingElement.class, "Plotting element"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            return new ImageIcon(plottingElement.getImage());
        }
    }

    static class AddElementPopupMenu {
        private static JPopupMenu popup;
        private static PlottingElement element;
        private static PlotBuilder pBuilder;

        AddElementPopupMenu() {
        }

        private static JPopupMenu getPopup() {
            if (popup == null) {
                popup = new JPopupMenu();
                elementPopupMenuItems = new Vector();
                JMenuItem jMenuItem = new JMenuItem("Add");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object;
                        PlottingElement plottingElement = (PlottingElement)element.clone();
                        ElementModel elementModel = plottingElement.getModel();
                        boolean bl = false;
                        if (plottingElement.getModel() instanceof Layer) {
                            object = (Layer)elementModel;
                            pBuilder.getModel().tryToFillRequiredAess((Layer)object);
                            bl = true;
                        }
                        if ((object = elementModel.checkValid()) != null || !bl) {
                            PlottingElementDialog plottingElementDialog = new PlottingElementDialog((JFrame)((Object)pBuilder), plottingElement);
                            plottingElementDialog.setModal(true);
                            plottingElementDialog.setLocationRelativeTo((Component)((Object)pBuilder));
                            plottingElementDialog.setVisible(true);
                            object = plottingElement.getModel().checkValid();
                            if (object != null || plottingElementDialog.getExitType() < 1) {
                                return;
                            }
                        }
                        pBuilder.model.getListModel().addElement(plottingElement);
                        pBuilder.updatePlot();
                    }
                });
                popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Get info");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = element.getUrl();
                        if (string != null && string.length() > 0) {
                            HelpButton.showInBrowser(string);
                        }
                    }
                });
                popup.add(jMenuItem);
            }
            return popup;
        }
    }

    static class ElementPopupMenu {
        private static JPopupMenu popup;
        private static PlottingElement element;
        private static JList elList;
        private static PlotBuilder plot;

        ElementPopupMenu() {
        }

        private static JPopupMenu getPopup() {
            popup = new JPopupMenu();
            elementPopupMenuItems = new Vector();
            JMenuItem jMenuItem = new JMenuItem("Edit");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    plot.openLayerSheet(element);
                }
            });
            popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Toggle active");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    element.setActive(!element.isActive());
                    elList.validate();
                    elList.repaint();
                    plot.updatePlot();
                }
            });
            popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Break out");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlottingElement[] plottingElementArray = ((CompoundElementModel)element.getModel()).getElements();
                    int n = ((DefaultListModel)elList.getModel()).indexOf(element);
                    for (int i = 0; i < plottingElementArray.length; ++i) {
                        ((DefaultListModel)elList.getModel()).add(n++, plottingElementArray[i]);
                    }
                    ((DefaultListModel)elList.getModel()).removeElement(element);
                    plot.updatePlot();
                }
            });
            if (element.getModel() instanceof CompoundElementModel) {
                popup.add(jMenuItem);
            }
            jMenuItem = new JMenuItem("Edit dialog");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Template template = (Template)element.getModel();
                    TemplateEditView templateEditView = new TemplateEditView(template);
                    PlottingElementDialog plottingElementDialog = new PlottingElementDialog(null, element);
                    plottingElementDialog.setView(templateEditView);
                    plottingElementDialog.setModal(true);
                    plottingElementDialog.setVisible(true);
                }
            });
            if (element.getModel() instanceof Template) {
                popup.add(jMenuItem);
            }
            jMenuItem = new JMenuItem("Export template");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FileSelector fileSelector = new FileSelector(null, "Save template", 1, null, true);
                    fileSelector.setVisible(true);
                    if (fileSelector.getFile() != null) {
                        int n;
                        File file = fileSelector.getSelectedFile();
                        if (!file.getName().endsWith(".ggtmpl")) {
                            file = new File(file.getPath() + ".ggtmpl");
                        }
                        if (file.exists() && (n = JOptionPane.showConfirmDialog(null, "File exists: Overwrite: " + file.getName() + "?")) != 0) {
                            return;
                        }
                        PlottingElement plottingElement = (PlottingElement)element.clone();
                        Template template = (Template)plottingElement.getModel();
                        for (int i = 0; i < template.mAess.length; ++i) {
                            template.mAess[i].aes.variable = null;
                        }
                        template.updateElementModels();
                        plottingElement.setModel(template);
                        plottingElement.saveToFile(file);
                    }
                }
            });
            if (element.getModel() instanceof Template) {
                popup.add(jMenuItem);
            }
            jMenuItem = new JMenuItem("Remove");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((DefaultListModel)elList.getModel()).removeElement(element);
                    plot.updatePlot();
                }
            });
            popup.add(jMenuItem);
            return popup;
        }
    }

    class ElementDropListener
    implements DragSourceListener {
        ElementDropListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess()) {
                // empty if block
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }
}

