/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.jdbc.common.JDBCObjectFactory;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SConnectionHandle;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public abstract class SPooledConnection
implements PooledConnection {
    private List<ConnectionEventListener> m_listeners = new ArrayList<ConnectionEventListener>();
    protected SConnectionHandle m_connectionHandle;
    protected ILogger m_logger;
    private List<StatementEventListener> m_statementlisteners = new ArrayList<StatementEventListener>();

    public SPooledConnection(SConnection sConnection) throws SQLException {
        this.m_logger = sConnection.getConnection().getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_logger, sConnection);
        this.m_connectionHandle = JDBCObjectFactory.getInstance().createConnectionHandle(sConnection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, connectionEventListener);
        if (null != connectionEventListener) {
            List<ConnectionEventListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.add(connectionEventListener);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.forceClose();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.open();
        return this.m_connectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, connectionEventListener);
        if (null != connectionEventListener) {
            List<ConnectionEventListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.remove(connectionEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandleError(SQLException sQLException) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        List<ConnectionEventListener> list = this.m_listeners;
        synchronized (list) {
            for (ConnectionEventListener connectionEventListener : this.m_listeners) {
                connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, sQLException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, statementEventListener);
        if (null != statementEventListener) {
            List<StatementEventListener> list = this.m_statementlisteners;
            synchronized (list) {
                this.m_statementlisteners.add(statementEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, statementEventListener);
        if (null != statementEventListener) {
            List<StatementEventListener> list = this.m_statementlisteners;
            synchronized (list) {
                this.m_statementlisteners.remove(statementEventListener);
            }
        }
    }

    public void onHandleStatementClose(PreparedStatement preparedStatement) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (StatementEventListener statementEventListener : this.m_statementlisteners) {
            statementEventListener.statementClosed(new StatementEvent(this, preparedStatement));
        }
    }

    public void onHandleStatementError(PreparedStatement preparedStatement, SQLException sQLException) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (StatementEventListener statementEventListener : this.m_statementlisteners) {
            statementEventListener.statementErrorOccurred(new StatementEvent(this, preparedStatement, sQLException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHandleClose() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        List<ConnectionEventListener> list = this.m_listeners;
        synchronized (list) {
            for (ConnectionEventListener connectionEventListener : new ArrayList<ConnectionEventListener>(this.m_listeners)) {
                connectionEventListener.connectionClosed(new ConnectionEvent(this));
            }
        }
    }
}

