/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XMLModelIdentifiable {
    private String name;
    private Element definition;
    private Element definitionIdref;
    private boolean defined;
    private LinkedList<Element> references;

    public XMLModelIdentifiable(String string, Element element) {
        this.name = string;
        this.definition = element;
        this.definitionIdref = new Element(element.getName());
        this.definitionIdref.setAttribute("idref", string);
        this.defined = true;
        this.references = new LinkedList();
    }

    public void removeDefinition() {
        if (this.defined) {
            this.definition.getParentElement().addContent(this.definitionIdref);
            this.definition.detach();
            this.defined = false;
        }
    }

    public void restoreDefinition() {
        if (!this.defined) {
            this.definitionIdref.getParentElement().addContent(this.definition);
            this.definitionIdref.detach();
            this.defined = true;
        }
    }

    public void rename(String string) {
        this.name = string;
        this.definition.setAttribute("id", string);
        this.definitionIdref.setAttribute("idref", string);
        for (Element element : this.references) {
            element.setAttribute("idref", string);
        }
    }

    public void addReference(Element element) {
        if (element.getAttribute("idref").getValue().equals(this.name)) {
            this.references.addLast(element);
        }
    }

    public void print(XMLOutputter xMLOutputter, OutputStream outputStream) {
        if (outputStream == null) {
            outputStream = System.out;
        }
        try {
            if (this.defined) {
                xMLOutputter.output(this.definition, outputStream);
            } else {
                xMLOutputter.output(this.definitionIdref, outputStream);
            }
            for (Element element : this.references) {
                xMLOutputter.output(element, outputStream);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

