/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

abstract class TransformedTreeTrait
extends AbstractModel
implements TreeTrait<double[]> {
    private final TreeTrait<double[]> baseTrait;
    private final List<Tree> trees;
    private boolean transformKnown;
    private DenseMatrix64F linearOperator;

    private TransformedTreeTrait(TreeTrait<double[]> treeTrait, List<Tree> list) {
        super(TransformedTreeTrait.getName(treeTrait.getTraitName()));
        for (Tree tree : list) {
            if (!(tree instanceof TreeModel)) continue;
            this.addModel((TreeModel)tree);
        }
        this.baseTrait = treeTrait;
        this.trees = list;
        this.transformKnown = false;
    }

    @Override
    public String getTraitName() {
        return TransformedTreeTrait.getName(this.baseTrait.getTraitName());
    }

    @Override
    public TreeTrait.Intent getIntent() {
        return this.baseTrait.getIntent();
    }

    @Override
    public Class getTraitClass() {
        return this.baseTrait.getTraitClass();
    }

    @Override
    public double[] getTrait(Tree tree, NodeRef nodeRef) {
        assert (this.trees.contains(tree));
        if (!this.transformKnown) {
            this.updateTransform();
            this.transformKnown = true;
        }
        return this.transform(this.baseTrait.getTrait(tree, nodeRef));
    }

    @Override
    public String getTraitString(Tree tree, NodeRef nodeRef) {
        assert (this.trees.contains(tree));
        return TreeTrait.DA.formatTrait(this.getTrait(tree, nodeRef));
    }

    @Override
    public boolean getLoggable() {
        return this.baseTrait.getLoggable();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.transformKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.transformKnown = false;
    }

    private double[] transform(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += this.linearOperator.unsafe_get(i, j);
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    abstract void updateTransform();

    private static String getName(String string) {
        return "transformed." + string;
    }

    public class PhylogeneticFactorAnalysis
    extends TransformedTreeTrait {
        private final Parameter loadings;

        public PhylogeneticFactorAnalysis(TreeTrait<double[]> treeTrait, List<Tree> list, Parameter parameter) {
            super(treeTrait, list);
            this.addVariable(parameter);
            this.loadings = parameter;
        }

        @Override
        void updateTransform() {
            TransformedTreeTrait.this.linearOperator = null;
        }
    }

    public class MultiDimensionalScaling
    extends TransformedTreeTrait {
        private final Tree sentinelTree;
        private final int dim;

        public MultiDimensionalScaling(TreeTrait<double[]> treeTrait, List<Tree> list) {
            this(treeTrait, list, list.get(0));
        }

        public MultiDimensionalScaling(TreeTrait<double[]> treeTrait, List<Tree> list, Tree tree) {
            super(treeTrait, list);
            this.sentinelTree = tree;
            this.dim = treeTrait.getTrait(tree, tree.getExternalNode(0)).length;
        }

        @Override
        void updateTransform() {
            DenseMatrix64F denseMatrix64F = this.getSentinelValue();
            TransformedTreeTrait.this.linearOperator = null;
        }

        private DenseMatrix64F getSentinelValue() {
            double[][] dArrayArray = new double[this.dim][];
            for (int i = 0; i < this.dim; ++i) {
                dArrayArray[i] = (double[])TransformedTreeTrait.this.baseTrait.getTrait(this.sentinelTree, this.sentinelTree.getExternalNode(i));
            }
            return new DenseMatrix64F(dArrayArray);
        }
    }
}

