/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.colouring;

public class ColourChangeMatrix {
    private int numColours;
    private double[][] bwMatrix;
    private double[] equilibrium;

    public ColourChangeMatrix() {
    }

    public ColourChangeMatrix(double[] dArray, int n) {
        if (n != 2) {
            throw new IllegalArgumentException("Only 2 colours supported");
        }
        this.numColours = n;
        this.bwMatrix = new double[n][n];
        this.equilibrium = new double[n];
        this.bwMatrix[0][1] = dArray[0];
        this.bwMatrix[1][0] = dArray[1];
        this.calculateExitRates();
        this.calculateEquilibrium();
    }

    private void calculateExitRates() {
        for (int i = 0; i < this.numColours; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.numColours; ++j) {
                if (i == j) continue;
                d += this.bwMatrix[i][j];
            }
            this.bwMatrix[i][i] = -d;
        }
    }

    private void calculateEquilibrium() {
        if (this.numColours != 2) {
            throw new Error("Only 2 colours supported");
        }
        double d = this.bwMatrix[0][1];
        double d2 = this.bwMatrix[1][0];
        this.equilibrium[0] = d2 / (d + d2);
        this.equilibrium[1] = d / (d + d2);
    }

    public double getBackwardRate(int n, int n2) {
        return this.bwMatrix[n][n2];
    }

    public double getForwardRate(int n, int n2) {
        return this.equilibrium[n2] * this.bwMatrix[n2][n] / this.equilibrium[n];
    }

    public double forwardTimeEvolution(int n, int n2, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Cannot go backwards in time: t=" + d);
        }
        double[] dArray = new double[]{this.getForwardRate(0, 1), this.getForwardRate(1, 0)};
        double d2 = dArray[0] + dArray[1];
        if (n2 == n) {
            return (dArray[n] * Math.exp(-d2 * d) + dArray[1 - n]) / d2;
        }
        return dArray[n] * (1.0 - Math.exp(-d2 * d)) / d2;
    }

    public double backwardTimeEvolution(int n, int n2, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Cannot go backwards in time: t=" + d);
        }
        double[] dArray = new double[]{this.getBackwardRate(0, 1), this.getBackwardRate(1, 0)};
        double d2 = dArray[0] + dArray[1];
        if (n2 == n) {
            return (dArray[n] * Math.exp(-d2 * d) + dArray[1 - n]) / d2;
        }
        return dArray[n] * (1.0 - Math.exp(-d2 * d)) / d2;
    }

    public double[] getEquilibrium() {
        return (double[])this.equilibrium.clone();
    }

    public double getEquilibrium(int n) {
        return this.equilibrium[n];
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{1.0, 0.5};
        ColourChangeMatrix colourChangeMatrix = new ColourChangeMatrix(dArray, 2);
        System.out.println("BW 0->0, matrix:" + colourChangeMatrix.getBackwardRate(0, 0));
        System.out.println("BW 0->1, matrix:" + colourChangeMatrix.getBackwardRate(0, 1));
        System.out.println("BW 1->0, matrix:" + colourChangeMatrix.getBackwardRate(1, 0));
        System.out.println("BW 1->1, matrix:" + colourChangeMatrix.getBackwardRate(1, 1));
        System.out.println("FW 0->0, matrix:" + colourChangeMatrix.getForwardRate(0, 0));
        System.out.println("FW 0->1, matrix:" + colourChangeMatrix.getForwardRate(0, 1));
        System.out.println("FW 1->0, matrix:" + colourChangeMatrix.getForwardRate(1, 0));
        System.out.println("FW 1->1, matrix:" + colourChangeMatrix.getForwardRate(1, 1));
        System.out.println("equilibrium=" + colourChangeMatrix.equilibrium[0] + "," + colourChangeMatrix.equilibrium[1]);
        System.out.println("BW 0->0, t=1:" + colourChangeMatrix.backwardTimeEvolution(0, 0, 1.0));
        System.out.println("BW 0->1, t=1:" + colourChangeMatrix.backwardTimeEvolution(0, 1, 1.0));
        System.out.println("BW 1->0, t=1:" + colourChangeMatrix.backwardTimeEvolution(1, 0, 1.0));
        System.out.println("BW 1->1, t=1:" + colourChangeMatrix.backwardTimeEvolution(1, 1, 1.0));
        System.out.println("FW 0->0, t=1:" + colourChangeMatrix.forwardTimeEvolution(0, 0, 1.0));
        System.out.println("FW 0->1, t=1:" + colourChangeMatrix.forwardTimeEvolution(0, 1, 1.0));
        System.out.println("FW 1->0, t=1:" + colourChangeMatrix.forwardTimeEvolution(1, 0, 1.0));
        System.out.println("FW 1->1, t=1:" + colourChangeMatrix.forwardTimeEvolution(1, 1, 1.0));
        System.out.println("BW 0->0, t=infty:" + colourChangeMatrix.backwardTimeEvolution(0, 0, 1000.0));
        System.out.println("BW 0->1, t=infty:" + colourChangeMatrix.backwardTimeEvolution(0, 1, 1000.0));
        System.out.println("BW 1->0, t=infty:" + colourChangeMatrix.backwardTimeEvolution(1, 0, 1000.0));
        System.out.println("BW 1->1, t=infty:" + colourChangeMatrix.backwardTimeEvolution(1, 1, 1000.0));
        System.out.println("FW 0->0, t=infty:" + colourChangeMatrix.forwardTimeEvolution(0, 0, 1000.0));
        System.out.println("FW 0->1, t=infty:" + colourChangeMatrix.forwardTimeEvolution(0, 1, 1000.0));
        System.out.println("FW 1->0, t=infty:" + colourChangeMatrix.forwardTimeEvolution(1, 0, 1000.0));
        System.out.println("FW 1->1, t=infty:" + colourChangeMatrix.forwardTimeEvolution(1, 1, 1000.0));
    }
}

