/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import java.util.List;
import jdplus.sa.base.core.regarima.AutomaticTradingDaysRegressionTest;
import jdplus.sa.base.core.regarima.AutomaticTradingDaysWaldTest;
import jdplus.sa.base.core.regarima.CalendarEffectsDetectionModule;
import jdplus.sa.base.core.regarima.EasterDetectionModule;
import jdplus.sa.base.core.regarima.LogLevelModule;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.core.regarima.AICcComparator;
import jdplus.toolkit.base.core.regsarima.regular.ILogLevelModule;
import jdplus.toolkit.base.core.regsarima.regular.IModelComparator;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.RegressionVariablesTest;
import jdplus.x13.base.api.regarima.AutoModelSpec;
import jdplus.x13.base.api.regarima.EasterSpec;
import jdplus.x13.base.api.regarima.OutlierSpec;
import jdplus.x13.base.api.regarima.RegArimaSpec;
import jdplus.x13.base.api.regarima.RegressionTestSpec;
import jdplus.x13.base.api.regarima.SingleOutlierSpec;
import jdplus.x13.base.api.regarima.TradingDaysSpec;
import jdplus.x13.base.api.regarima.TransformSpec;
import jdplus.x13.base.core.x13.regarima.ArmaModule;
import jdplus.x13.base.core.x13.regarima.AutoModellingModule;
import jdplus.x13.base.core.x13.regarima.DifferencingModule;
import jdplus.x13.base.core.x13.regarima.OutliersDetectionModule;
import jdplus.x13.base.core.x13.regarima.RegArimaKernel;
import jdplus.x13.base.core.x13.regarima.X13ModelBuilder;
import lombok.NonNull;

final class X13SpecDecoder {
    private final RegArimaKernel.Builder builder = RegArimaKernel.builder();

    X13SpecDecoder(@NonNull RegArimaSpec spec, ModellingContext context) {
        if (spec == null) {
            throw new NullPointerException("spec is marked non-null but is null");
        }
        if (context == null) {
            context = ModellingContext.getActiveContext();
        }
        this.readTransformation(spec);
        if (spec.isUsingAutoModel()) {
            this.readAutoModel(spec);
        }
        this.readOutliers(spec);
        this.builder.modelBuilder(new X13ModelBuilder(spec, context));
        this.readRegression(spec, context);
        this.readAmiOptions(spec);
    }

    RegArimaKernel buildProcessor() {
        return this.builder.build();
    }

    private void readTransformation(RegArimaSpec spec) {
        TransformSpec tspec = spec.getTransform();
        TradingDaysSpec tdspec = spec.getRegression().getTradingDays();
        if (tspec.getFunction() == TransformationType.Auto) {
            this.builder.logLevel((ILogLevelModule)LogLevelModule.builder().aiccLogCorrection(tspec.getAicDiff()).estimationPrecision(1.0E-7).preadjust(tdspec.isAutoAdjust() ? tdspec.getLengthOfPeriodType() : LengthOfPeriodType.None).outliersCorrection(tspec.isOutliersCorrection()).build());
        }
    }

    private void readAutoModel(RegArimaSpec spec) {
        AutoModelSpec amiSpec = spec.getAutoModel();
        DifferencingModule diff = DifferencingModule.builder().cancel(amiSpec.getCancel()).ub1(1.0 / amiSpec.getUb1()).ub2(1.0 / amiSpec.getUb2()).precision(1.0E-7).build();
        ArmaModule arma = ArmaModule.builder().balanced(amiSpec.isBalanced()).mixed(amiSpec.isMixed()).estimationPrecision(1.0E-7).build();
        this.builder.autoModelling(new AutoModellingModule(diff, arma));
    }

    private void readOutliers(RegArimaSpec spec) {
        OutlierSpec outliers = spec.getOutliers();
        if (!outliers.isUsed()) {
            return;
        }
        OutliersDetectionModule.Builder obuilder = OutliersDetectionModule.builder();
        List types = outliers.getTypes();
        block12: for (int i = 0; i < types.size(); ++i) {
            switch (((SingleOutlierSpec)types.get(i)).getType()) {
                case "AO": {
                    obuilder.ao(true);
                    continue block12;
                }
                case "LS": {
                    obuilder.ls(true);
                    continue block12;
                }
                case "TC": {
                    obuilder.tc(true);
                    continue block12;
                }
                case "SO": {
                    obuilder.so(true);
                }
            }
        }
        this.builder.outliers(obuilder.span(outliers.getSpan()).maxRound(outliers.getMaxIter()).tcrate(outliers.getMonthlyTCRate()).precision(1.0E-7).build());
    }

    private ITradingDaysVariable[] nestedtd(RegArimaSpec spec, ModellingContext context) {
        return new ITradingDaysVariable[]{X13ModelBuilder.td(spec, DayClustering.TD2, context), X13ModelBuilder.td(spec, DayClustering.TD3, context), X13ModelBuilder.td(spec, DayClustering.TD4, context), X13ModelBuilder.td(spec, DayClustering.TD7, context)};
    }

    private ITradingDaysVariable[] alltd(RegArimaSpec spec, ModellingContext context) {
        return new ITradingDaysVariable[]{X13ModelBuilder.td(spec, DayClustering.TD2c, context), X13ModelBuilder.td(spec, DayClustering.TD2, context), X13ModelBuilder.td(spec, DayClustering.TD3, context), X13ModelBuilder.td(spec, DayClustering.TD3c, context), X13ModelBuilder.td(spec, DayClustering.TD4, context), X13ModelBuilder.td(spec, DayClustering.TD7, context)};
    }

    private void readRegression(RegArimaSpec spec, ModellingContext context) {
        TradingDaysSpec tdspec = spec.getRegression().getTradingDays();
        AICcComparator comparator = new AICcComparator(spec.getRegression().getAicDiff());
        if (tdspec.isAutomatic()) {
            switch (tdspec.getAutomaticMethod()) {
                case AIC: {
                    this.builder.calendarTest((IRegressionModule)AutomaticTradingDaysRegressionTest.builder().leapYear(X13ModelBuilder.leapYear(tdspec)).tradingDays(this.alltd(spec, context)).adjust(tdspec.isAutoAdjust()).aic().build());
                    break;
                }
                case BIC: {
                    this.builder.calendarTest((IRegressionModule)AutomaticTradingDaysRegressionTest.builder().leapYear(X13ModelBuilder.leapYear(tdspec)).tradingDays(this.alltd(spec, context)).adjust(tdspec.isAutoAdjust()).bic().build());
                    break;
                }
                case WALD: {
                    this.builder.calendarTest((IRegressionModule)AutomaticTradingDaysWaldTest.builder().leapYear(X13ModelBuilder.leapYear(tdspec)).tradingDays(this.nestedtd(spec, context)).adjust(tdspec.isAutoAdjust()).pmodel(tdspec.getAutoPvalue1()).pconstraint(tdspec.getAutoPvalue2()).build());
                }
            }
        } else if (tdspec.getRegressionTestType() != RegressionTestSpec.None) {
            CalendarEffectsDetectionModule cal = CalendarEffectsDetectionModule.builder().tradingDays(X13ModelBuilder.tradingDays(spec, context)).leapYear(X13ModelBuilder.leapYear(tdspec)).adjust(tdspec.isAutoAdjust() ? tdspec.getLengthOfPeriodType() : LengthOfPeriodType.None).modelComparator((IModelComparator)comparator).build();
            this.builder.calendarTest((IRegressionModule)cal);
        }
        EasterSpec espec = spec.getRegression().getEaster();
        if (espec.getType() != EasterSpec.Type.Unused && espec.getTest() != RegressionTestSpec.None) {
            int[] w = espec.getTest() == RegressionTestSpec.Remove ? new int[]{espec.getDuration()} : new int[]{1, 8, 15};
            IEasterVariable[] easters = new IEasterVariable[w.length];
            for (int i = 0; i < easters.length; ++i) {
                easters[i] = X13ModelBuilder.easter(espec.getType(), w[i]);
            }
            EasterDetectionModule e = EasterDetectionModule.builder().easters(easters).modelComparator((IModelComparator)comparator).build();
            this.builder.easterTest((IRegressionModule)e);
        }
        RegressionVariablesTest.Builder rbuilder = RegressionVariablesTest.builder();
        if (tdspec.getRegressionTestType() != RegressionTestSpec.None) {
            rbuilder.tdTest(1.96, true);
        }
        if (espec.getType() != EasterSpec.Type.Unused && espec.getTest() != RegressionTestSpec.None) {
            rbuilder.movingHolidaysTest(1.96);
        }
        if (spec.isUsingAutoModel() || spec.getRegression().getMean().isTest()) {
            rbuilder.meanTest(1.96);
        }
        this.builder.initialRegressionTest(rbuilder.build());
        if (spec.isUsingAutoModel() || spec.getRegression().getMean().isTest()) {
            rbuilder.meanTest(1.0);
        }
        this.builder.finalRegressionTest(rbuilder.build());
    }

    private void readAmiOptions(RegArimaSpec spec) {
        AutoModelSpec ami = spec.getAutoModel();
        this.builder.options(RegArimaKernel.AmiOptions.builder().precision(spec.getEstimate().getTol()).va(spec.getOutliers().getDefaultCriticalValue()).reduceVa(ami.getPredcv()).ljungBoxLimit(ami.getLjungBoxLimit()).checkMu(spec.isUsingAutoModel() || spec.getRegression().getMean().isTest()).mixedModel(ami.isMixed()).build());
    }
}

