/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.text.NumberFormat;
import java.util.Currency;

public class OfficeCurrency {
    private final Currency currency;
    private final Double value;
    private final NumberFormat format;

    public OfficeCurrency(Currency currency, Double value) {
        this(currency, value, NumberFormat.getCurrencyInstance());
    }

    public OfficeCurrency(Currency currency, Double value, NumberFormat format) {
        this.currency = currency;
        this.value = value;
        this.format = format;
        if (currency != null) {
            this.format.setCurrency(currency);
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfficeCurrency that = (OfficeCurrency)o;
        if (this.currency != null && that.currency != null ? !this.currency.getCurrencyCode().equals(that.currency.getCurrencyCode()) : that.currency != null) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int result = this.currency != null ? this.currency.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "" + this.format.format(this.value);
    }
}

