/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology;

import java.util.Comparator;

public interface TopoTreeNode {
    public NodeType getType();

    public TopoTreeNode getPartner();

    public int getID();

    public float getBirth();

    public float getDeath();

    public float getPersistence();

    public float getValue();

    public static class ComparePersistenceDescending
    implements Comparator<TopoTreeNode> {
        @Override
        public int compare(TopoTreeNode topoTreeNode, TopoTreeNode topoTreeNode2) {
            if (topoTreeNode.getPersistence() < topoTreeNode2.getPersistence()) {
                return 1;
            }
            if (topoTreeNode.getPersistence() > topoTreeNode2.getPersistence()) {
                return -1;
            }
            return 0;
        }
    }

    public static class ComparePersistenceAscending
    implements Comparator<TopoTreeNode> {
        @Override
        public int compare(TopoTreeNode topoTreeNode, TopoTreeNode topoTreeNode2) {
            if (topoTreeNode.getPersistence() > topoTreeNode2.getPersistence()) {
                return 1;
            }
            if (topoTreeNode.getPersistence() < topoTreeNode2.getPersistence()) {
                return -1;
            }
            return 0;
        }
    }

    public static enum NodeType {
        LEAF_MIN,
        LEAF_MAX,
        DOWNFORK,
        UPFORK,
        LEAF,
        SADDLE,
        NONCRITICAL,
        UNKNOWN;

    }
}

