/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.solver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;

public class MSTSolver {
    private final Graph g;
    private final Map<Edge, Double> ws;
    private final Node root;
    private double cost;
    private List<Edge> res;

    public MSTSolver(Graph g, Map<Edge, Double> edgeWeights, Node root) {
        this.g = g;
        this.ws = edgeWeights;
        this.root = root;
    }

    public double getCost() {
        return this.cost;
    }

    public List<Edge> getEdges() {
        return this.res;
    }

    public void solve() {
        Double cost = 0.0;
        ArrayList<Edge> res = new ArrayList<Edge>();
        HashSet<Node> unvisited = new HashSet<Node>(this.g.vertexSet());
        Node cur = this.root;
        unvisited.remove(this.root);
        PriorityQueue<Edge> q = new PriorityQueue<Edge>(Comparator.comparingDouble(this.ws::get));
        while (!unvisited.isEmpty()) {
            for (Edge e : this.g.edgesOf(cur)) {
                Node nbor = this.g.opposite(cur, e);
                if (!unvisited.contains(nbor)) continue;
                q.add(e);
            }
            Edge e = (Edge)q.remove();
            Node et = this.g.getEdgeTarget(e);
            Node es = this.g.getEdgeSource(e);
            if (unvisited.contains(et) || unvisited.contains(es)) {
                cost = cost + this.ws.get(e);
                res.add(e);
                cur = unvisited.contains(et) ? et : es;
            }
            unvisited.remove(cur);
        }
        this.cost = cost;
        this.res = res;
    }
}

