/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class SASLogHandler
extends Handler {
    private final SimpleFormatter formatter = new SimpleFormatter();
    private static final Queue<String> logRecords = new ConcurrentLinkedQueue<String>();

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getLevel() == Level.WARNING) {
            logRecords.add("WARNING: " + this.formatter.formatMessage(logRecord));
        } else if (logRecord.getLevel() == Level.SEVERE) {
            logRecords.add("ERROR: " + this.formatter.formatMessage(logRecord));
        } else if (logRecord.getLevel() == Level.INFO) {
            logRecords.add("NOTE: " + this.formatter.formatMessage(logRecord));
        } else {
            logRecords.add(this.formatter.formatMessage(logRecord));
        }
    }

    public String getLogItem() {
        String string = logRecords.poll();
        return string == null ? "" : string;
    }
}

