/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.dictionaries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AtomicDictionary
implements Dictionary {
    public final String name;
    private final List<Item> items;

    @Override
    public Stream<? extends Dictionary.Entry> entries() {
        return this.items.stream();
    }

    @Generated
    AtomicDictionary(String name, List<Item> items) {
        this.name = name;
        this.items = items;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtomicDictionary)) {
            return false;
        }
        AtomicDictionary other = (AtomicDictionary)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Item> this$items = this.getItems();
        List<Item> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Item> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "AtomicDictionary(name=" + this.getName() + ", items=" + String.valueOf(this.getItems()) + ")";
    }

    @Generated
    private List<Item> getItems() {
        return this.items;
    }

    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private ArrayList<Item> items;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public @NonNull Builder item(Item item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        @Generated
        public @NonNull Builder items(@NonNull Collection<? extends Item> items) {
            if (items == null) {
                throw new NullPointerException("items cannot be null");
            }
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        @Generated
        public @NonNull Builder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        @Generated
        public @NonNull AtomicDictionary build() {
            return new AtomicDictionary(this.name, switch (this.items == null ? 0 : this.items.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.items.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Item>(this.items));
            });
        }

        @Generated
        public @NonNull String toString() {
            return "AtomicDictionary.Builder(name=" + this.name + ", items=" + String.valueOf(this.items) + ")";
        }
    }

    public static final class Item
    implements Dictionary.Entry {
        public static final String EMPTY = "";
        public static final String TODO = "TODO";
        private final String name;
        private final String description;
        private final String detail;
        private final Class outputClass;
        private final Dictionary.EntryType type;

        public static Builder builder() {
            return new Builder().description(TODO).detail(EMPTY).type(Dictionary.EntryType.Normal);
        }

        @Generated
        Item(String name, String description, String detail, Class outputClass, Dictionary.EntryType type) {
            this.name = name;
            this.description = description;
            this.detail = detail;
            this.outputClass = outputClass;
            this.type = type;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public String getDetail() {
            return this.detail;
        }

        @Override
        @Generated
        public Class getOutputClass() {
            return this.outputClass;
        }

        @Override
        @Generated
        public Dictionary.EntryType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$detail = this.getDetail();
            String other$detail = other.getDetail();
            if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
                return false;
            }
            Class this$outputClass = this.getOutputClass();
            Class other$outputClass = other.getOutputClass();
            if (this$outputClass == null ? other$outputClass != null : !this$outputClass.equals(other$outputClass)) {
                return false;
            }
            Dictionary.EntryType this$type = this.getType();
            Dictionary.EntryType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $detail = this.getDetail();
            result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
            Class $outputClass = this.getOutputClass();
            result = result * 59 + ($outputClass == null ? 43 : $outputClass.hashCode());
            Dictionary.EntryType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "AtomicDictionary.Item(name=" + this.getName() + ", description=" + this.getDescription() + ", detail=" + this.getDetail() + ", outputClass=" + String.valueOf(this.getOutputClass()) + ", type=" + String.valueOf((Object)this.getType()) + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private String name;
            @Generated
            private String description;
            @Generated
            private String detail;
            @Generated
            private Class outputClass;
            @Generated
            private Dictionary.EntryType type;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public @NonNull Builder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public @NonNull Builder detail(String detail) {
                this.detail = detail;
                return this;
            }

            @Generated
            public @NonNull Builder outputClass(Class outputClass) {
                this.outputClass = outputClass;
                return this;
            }

            @Generated
            public @NonNull Builder type(Dictionary.EntryType type) {
                this.type = type;
                return this;
            }

            @Generated
            public @NonNull Item build() {
                return new Item(this.name, this.description, this.detail, this.outputClass, this.type);
            }

            @Generated
            public @NonNull String toString() {
                return "AtomicDictionary.Item.Builder(name=" + this.name + ", description=" + this.description + ", detail=" + this.detail + ", outputClass=" + String.valueOf(this.outputClass) + ", type=" + String.valueOf((Object)this.type) + ")";
            }
        }
    }
}

