/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.samples;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import lombok.Generated;

public final class Moments {
    public static double mean(DoubleSeq x) {
        int n = x.length();
        switch (n) {
            case 0: {
                return Double.NaN;
            }
            case 1: {
                return x.get(0);
            }
        }
        double m = 0.0;
        DoubleSeqCursor cursor = x.cursor();
        for (int i = 0; i < n; ++i) {
            m += cursor.getAndNext();
        }
        m /= (double)n;
        double e = 0.0;
        cursor = x.cursor();
        for (int i = 0; i < n; ++i) {
            e += cursor.getAndNext() - m;
        }
        return m + e / (double)n;
    }

    public static double variance(DoubleSeq x, double mean, boolean unbiased) {
        int n = x.length();
        switch (n) {
            case 0: {
                return Double.NaN;
            }
            case 1: {
                return 0.0;
            }
        }
        DoubleSeqCursor cursor = x.cursor();
        double v = 0.0;
        double v2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d = cursor.getAndNext() - mean;
            v += d * d;
            v2 += d;
        }
        if (unbiased) {
            return (v - v2 * v2 / (double)n) / (double)(n - 1);
        }
        return (v - v2 * v2 / (double)n) / (double)n;
    }

    public static double skewness(DoubleSeq x, boolean unbiased) {
        double mean = Moments.mean(x);
        double variance = Moments.variance(x, mean, unbiased);
        return Moments.skewness(x, mean, variance, unbiased);
    }

    public static double skewness(DoubleSeq x, double mean, double var, boolean unbiased) {
        int n = x.length();
        if (n < 3) {
            return Double.NaN;
        }
        DoubleSeqCursor cursor = x.cursor();
        double m3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d = cursor.getAndNext() - mean;
            m3 += d * d * d;
        }
        double std3 = var * Math.sqrt(var);
        if (unbiased) {
            return (double)n * m3 / ((double)((n - 1) * (n - 2)) * std3);
        }
        return m3 / (std3 * (double)n);
    }

    public static double excessKurtosis(DoubleSeq x, boolean unbiased) {
        double mean = Moments.mean(x);
        double variance = Moments.variance(x, mean, unbiased);
        return Moments.excessKurtosis(x, mean, variance, unbiased);
    }

    public static double excessKurtosis(DoubleSeq x, double mean, double var, boolean unbiased) {
        int n = x.length();
        if (n < 4) {
            return Double.NaN;
        }
        DoubleSeqCursor cursor = x.cursor();
        double m4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d = cursor.getAndNext() - mean;
            double d2 = d * d;
            m4 += d2 * d2;
        }
        double std4 = var * var;
        if (unbiased) {
            double dcorr = (n - 2) * (n - 3);
            return (double)(n * (n + 1)) * m4 / ((double)(n - 1) * dcorr * std4) - (double)(3 * (n - 1) * (n - 1)) / dcorr;
        }
        return m4 / (std4 * (double)n) - 3.0;
    }

    @Generated
    private Moments() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

