/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.linearmodel;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.toolkit.base.core.stats.linearmodel.OlsComputer;

public final class OlsLoader {

    public static final class Processor {
        private final Iterable<Ols.Processor> source = ServiceLoader.load(Ols.Processor.class);
        private final AtomicReference<Ols.Processor> resource = new AtomicReference<Ols.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private Ols.Processor doLoad() {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseGet(() -> new OlsComputer());
        }

        public Ols.Processor get() {
            return this.resource.get();
        }

        public void set(Ols.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            Iterable<Ols.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Iterable<Ols.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

