/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixNorms;
import jdplus.toolkit.base.core.math.matrices.TypeOfMatrix;
import jdplus.toolkit.base.core.math.matrices.lapack.LASCL;

public class GESLY {
    private int[] pivot;
    private FastMatrix QR;
    private double rankCondition;
    private int rank;
    private FastMatrix B;

    public void apply(FastMatrix A, FastMatrix B, int[] pivot) {
        this.clear();
        int m = A.getRowsCount();
        int n = A.getColumnsCount();
        int k = B.getColumnsCount();
        if (m == 0 || n == 0 || k == 0) {
            return;
        }
        if (pivot != null) {
            this.pivot = (int[])pivot.clone();
        } else {
            this.pivot = new int[n];
            for (int i = 0; i < n; ++i) {
                this.pivot[i] = -1;
            }
        }
        double smlnum = Constants.getSafeMin() / Constants.getPrecision();
        double bignum = 1.0 / smlnum;
        double anrm = MatrixNorms.absNorm(A);
        int ascal = 0;
        if (anrm > 0.0 && anrm < smlnum) {
            LASCL.apply(A, TypeOfMatrix.General, anrm, smlnum);
            ascal = 1;
        } else if (anrm > bignum) {
            LASCL.apply(A, TypeOfMatrix.General, anrm, bignum);
            ascal = 2;
        } else if (anrm == 0.0) {
            B.set(0.0);
            return;
        }
        double bnrm = MatrixNorms.absNorm(B);
        int bscal = 0;
        if (bnrm > 0.0 && bnrm < smlnum) {
            LASCL.apply(B, TypeOfMatrix.General, bnrm, smlnum);
            bscal = 1;
        } else if (bnrm > bignum) {
            LASCL.apply(B, TypeOfMatrix.General, bnrm, bignum);
            bscal = 2;
        }
    }

    private void clear() {
        this.pivot = null;
        this.QR = null;
        this.rankCondition = 0.0;
        this.rank = 0;
    }
}

