/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.linearfilters.AsymmetricFilterOption;
import jdplus.toolkit.base.api.math.linearfilters.KernelOption;
import jdplus.toolkit.base.api.math.linearfilters.LocalPolynomialFilterSpec;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.analysis.DiscreteKernel;
import jdplus.toolkit.base.core.math.linearfilters.AsymmetricFiltersFactory;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IQuasiSymmetricFiltering;
import jdplus.toolkit.base.core.math.linearfilters.ISymmetricFiltering;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.Householder2;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import lombok.Generated;

public final class LocalPolynomialFilters {
    public static IQuasiSymmetricFiltering of(LocalPolynomialFilterSpec spec) {
        return spec.isSymmetric() ? new SFilter(spec) : new Filter(spec);
    }

    public static ISymmetricFiltering ofSymmetric(LocalPolynomialFilterSpec spec) {
        if (!spec.isSymmetric()) {
            throw new IllegalArgumentException();
        }
        return new SFilter(spec);
    }

    private static IntToDoubleFunction kernel(LocalPolynomialFilterSpec spec) {
        int len = spec.getFilterHorizon();
        return switch (spec.getKernel()) {
            case KernelOption.BiWeight -> DiscreteKernel.biweight(len);
            case KernelOption.TriWeight -> DiscreteKernel.triweight(len);
            case KernelOption.TriCube -> DiscreteKernel.tricube(len);
            case KernelOption.Uniform -> DiscreteKernel.uniform(len);
            case KernelOption.Triangular -> DiscreteKernel.triangular(len);
            case KernelOption.Epanechnikov -> DiscreteKernel.epanechnikov(len);
            case KernelOption.Henderson -> DiscreteKernel.henderson(len);
            case KernelOption.Trapezoidal -> DiscreteKernel.trapezoidal(len);
            default -> null;
        };
    }

    public static SymmetricFilter of(int h, int d, IntToDoubleFunction k) {
        return switch (d) {
            case 0, 1 -> LocalPolynomialFilters.of0_1(h, k);
            case 2, 3 -> LocalPolynomialFilters.of2_3(h, k);
            default -> LocalPolynomialFilters.ofDefault(h, d, k);
        };
    }

    public static FiniteFilter directAsymmetricFilter(int h, int q, int d, IntToDoubleFunction k) {
        double wc;
        double l;
        double s;
        int i;
        FastMatrix xkx = FastMatrix.square(d + 1);
        for (int i2 = 0; i2 <= d; ++i2) {
            xkx.set(i2, i2, LocalPolynomialFilters.S_hqd(h, q, 2 * i2, k));
            for (int j = 0; j < i2; ++j) {
                double x = LocalPolynomialFilters.S_hqd(h, q, i2 + j, k);
                if (x == 0.0) continue;
                xkx.set(i2, j, x);
                xkx.set(j, i2, x);
            }
        }
        double[] u = new double[d + 1];
        u[0] = 1.0;
        LinearSystemSolver.robustSolver().solve(xkx, DataBlock.of(u));
        double[] w = new double[h + q + 1];
        w[h] = u[0] * k.applyAsDouble(0);
        for (i = 1; i <= q; ++i) {
            s = u[0];
            l = 1.0;
            for (int j = 1; j <= d; ++j) {
                s += (l *= (double)i) * u[j];
            }
            w[h + i] = wc = s * k.applyAsDouble(i);
        }
        for (i = -1; i >= -h; --i) {
            s = u[0];
            l = 1.0;
            for (int j = 1; j <= d; ++j) {
                s += (l *= (double)i) * u[j];
            }
            w[h + i] = wc = s * k.applyAsDouble(i);
        }
        return FiniteFilter.ofInternal(w, -h);
    }

    public static FiniteFilter[] directAsymmetricFilters(int h, int d, IntToDoubleFunction k) {
        FiniteFilter[] ff = new FiniteFilter[h];
        int i = 0;
        int j = h - 1;
        while (i < h) {
            ff[i] = LocalPolynomialFilters.directAsymmetricFilter(h, j, d, k);
            ++i;
            --j;
        }
        return ff;
    }

    private static SymmetricFilter of0_1(int h, IntToDoubleFunction k) {
        double[] w = new double[h + 1];
        double s0 = LocalPolynomialFilters.S_h0(h, k);
        for (int i = 0; i <= h; ++i) {
            w[i] = k.applyAsDouble(i) / s0;
        }
        return SymmetricFilter.ofInternal(w);
    }

    private static SymmetricFilter of2_3(int h, IntToDoubleFunction k) {
        double[] w = new double[h + 1];
        double s0 = 0.0;
        double s2 = 0.0;
        double s4 = 0.0;
        for (int i = 1; i <= h; ++i) {
            double j2 = i * i;
            double j4 = j2 * j2;
            double ki = k.applyAsDouble(i);
            s0 += ki;
            s2 += j2 * ki;
            s4 += j4 * ki;
        }
        s0 = k.applyAsDouble(0) + 2.0 * s0;
        double sr = (s2 *= 2.0) / (s4 *= 2.0);
        for (int i = 0; i <= h; ++i) {
            double n = 1.0 - (double)(i * i) * sr;
            double d = s0 - s2 * sr;
            w[i] = k.applyAsDouble(i) * n / d;
        }
        return SymmetricFilter.ofInternal(w);
    }

    public static SymmetricFilter ofDefault(int h, int d, IntToDoubleFunction k) {
        double[] sk = new double[h + 1];
        if (k == null) {
            for (i = 0; i < sk.length; ++i) {
                sk[i] = 1.0;
            }
        } else {
            for (i = 0; i < sk.length; ++i) {
                double ki = k.applyAsDouble(i);
                if (!(ki > 0.0)) continue;
                sk[i] = Math.sqrt(ki);
            }
        }
        FastMatrix Z = LocalPolynomialFilters.createZ(h, d);
        DataBlockIterator rows = Z.rowsIterator();
        int pos = -h;
        while (rows.hasNext()) {
            rows.next().mul(sk[Math.abs(pos++)]);
        }
        QRDecomposition qr = new Householder2().decompose(Z);
        double[] z = new double[Z.getRowsCount()];
        z[0] = 1.0;
        UpperTriangularMatrix.solvexU(qr.rawR(), DataBlock.of(z, 0, d + 1, 1));
        qr.applyQ(z);
        double[] w = new double[h + 1];
        for (int i = 0; i <= h; ++i) {
            w[i] = sk[i] * z[i + h];
        }
        return SymmetricFilter.ofInternal(w);
    }

    private static double S_h0(int h, IntToDoubleFunction k) {
        double s = 0.0;
        for (int i = 1; i <= h; ++i) {
            s += k.applyAsDouble(i);
        }
        return 2.0 * s + k.applyAsDouble(0);
    }

    private static double S_hqd(int h, int q, long d, IntToDoubleFunction k) {
        if (d == 0L) {
            return LocalPolynomialFilters.S_hq0(h, q, k);
        }
        double s = 0.0;
        if (d % 2L == 0L) {
            for (int i = 1; i <= h; ++i) {
                double j = i;
                int l = 1;
                while ((long)l < d) {
                    j *= (double)i;
                    ++l;
                }
                if (i <= q) {
                    s += 2.0 * j * k.applyAsDouble(i);
                    continue;
                }
                s += j * k.applyAsDouble(i);
            }
        } else {
            for (int i = q + 1; i <= h; ++i) {
                double j = i;
                int l = 1;
                while ((long)l < d) {
                    j *= (double)i;
                    ++l;
                }
                s -= j * k.applyAsDouble(i);
            }
        }
        return s;
    }

    private static double S_hq0(int h, int q, IntToDoubleFunction k) {
        int i;
        double s = k.applyAsDouble(0);
        for (i = 1; i <= q; ++i) {
            s += 2.0 * k.applyAsDouble(i);
        }
        for (i = q + 1; i <= h; ++i) {
            s += k.applyAsDouble(i);
        }
        return s;
    }

    public static FastMatrix z(FastMatrix Z, int l, int u, int d0, int d1) {
        int nh = Math.max(Math.abs(l), Math.abs(u));
        if (Z == null || Z.getRowsCount() / 2 < nh || Z.getColumnsCount() < d1 + 1) {
            Z = LocalPolynomialFilters.createZ(nh, d1);
        }
        return Z.extract(l + nh, u - l + 1, d0, d1 - d0 + 1);
    }

    public static FastMatrix createZ(int h, int d) {
        FastMatrix M = FastMatrix.make(2 * h + 1, d + 1);
        M.column(0).set(1.0);
        if (d >= 1) {
            DataBlock c1 = M.column(1);
            c1.set(i -> i - h);
            for (int i2 = 2; i2 <= d; ++i2) {
                M.column(i2).set(c1, M.column(i2 - 1), (a, b) -> a * b);
            }
        }
        return M;
    }

    @Generated
    private LocalPolynomialFilters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class SFilter
    implements ISymmetricFiltering {
        private final SymmetricFilter symmetricFilter;
        private final IFiniteFilter[] asymmetricFilters;

        private SFilter(LocalPolynomialFilterSpec spec) {
            int len = spec.getFilterHorizon();
            this.symmetricFilter = LocalPolynomialFilters.ofDefault(len, spec.getPolynomialDegree(), LocalPolynomialFilters.kernel(spec));
            this.asymmetricFilters = switch (spec.getAsymmetricFilters()) {
                case AsymmetricFilterOption.CutAndNormalize -> AsymmetricFiltersFactory.cutAndNormalizeFilters(this.symmetricFilter);
                case AsymmetricFilterOption.MMSRE -> AsymmetricFiltersFactory.mmsreFilters(this.symmetricFilter, spec.getAsymmetricPolynomialDegree(), spec.getRightLinearModelCoefficients(), null, spec.getPassBand(), spec.getTimelinessWeight());
                default -> LocalPolynomialFilters.directAsymmetricFilters(len, spec.getPolynomialDegree(), LocalPolynomialFilters.kernel(spec));
            };
        }

        @Override
        public DoubleSeq process(DoubleSeq in) {
            return FilterUtility.filter(in, this.symmetricFilter, this.asymmetricFilters);
        }

        @Override
        public SymmetricFilter centralFilter() {
            return this.symmetricFilter;
        }

        @Override
        public IFiniteFilter[] endPointsFilters() {
            return this.asymmetricFilters;
        }
    }

    private static class Filter
    implements IQuasiSymmetricFiltering {
        private final SymmetricFilter symmetricFilter;
        private final IFiniteFilter[] leftAsymmetricFilters;
        private final IFiniteFilter[] rightAsymmetricFilters;

        private Filter(LocalPolynomialFilterSpec spec) {
            int len = spec.getFilterHorizon();
            this.symmetricFilter = LocalPolynomialFilters.ofDefault(len, spec.getPolynomialDegree(), LocalPolynomialFilters.kernel(spec));
            this.rightAsymmetricFilters = switch (spec.getAsymmetricFilters()) {
                case AsymmetricFilterOption.CutAndNormalize -> AsymmetricFiltersFactory.cutAndNormalizeFilters(this.symmetricFilter);
                case AsymmetricFilterOption.MMSRE -> AsymmetricFiltersFactory.mmsreFilters(this.symmetricFilter, spec.getAsymmetricPolynomialDegree(), spec.getRightLinearModelCoefficients(), null, spec.getPassBand(), spec.getTimelinessWeight());
                default -> LocalPolynomialFilters.directAsymmetricFilters(len, spec.getPolynomialDegree(), LocalPolynomialFilters.kernel(spec));
            };
            this.leftAsymmetricFilters = ISymmetricFiltering.mirror(switch (spec.getAsymmetricFilters()) {
                case AsymmetricFilterOption.MMSRE -> AsymmetricFiltersFactory.mmsreFilters(this.symmetricFilter, spec.getAsymmetricPolynomialDegree(), spec.getLeftLinearModelCoefficients(), null, spec.getPassBand(), spec.getTimelinessWeight());
                default -> this.rightAsymmetricFilters;
            });
        }

        @Override
        public DoubleSeq process(DoubleSeq in) {
            return FilterUtility.filter(in, this.symmetricFilter, this.leftAsymmetricFilters, this.rightAsymmetricFilters);
        }

        @Override
        public SymmetricFilter centralFilter() {
            return this.symmetricFilter;
        }

        @Override
        public IFiniteFilter[] leftEndPointsFilters() {
            return this.leftAsymmetricFilters;
        }

        @Override
        public IFiniteFilter[] rightEndPointsFilters() {
            return this.rightAsymmetricFilters;
        }
    }
}

