/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class TrigonometricSeries {
    private final double[] w;

    public static TrigonometricSeries regular(int periodicity) {
        int n = periodicity / 2;
        double[] freq = new double[n];
        double f = Math.PI * 2 / (double)periodicity;
        for (int i = 1; i <= n; ++i) {
            freq[i - 1] = f * (double)i;
        }
        return new TrigonometricSeries(freq);
    }

    public static TrigonometricSeries regular(int periodicity, int[] seasfreq) {
        double[] freq = new double[seasfreq.length];
        double f = Math.PI * 2 / (double)periodicity;
        for (int i = 0; i < seasfreq.length; ++i) {
            freq[i] = f * (double)seasfreq[i];
        }
        return new TrigonometricSeries(freq);
    }

    public static TrigonometricSeries all(double periodicity, int nfreq) {
        double[] freq = new double[nfreq];
        double f = Math.PI * 2 / periodicity;
        for (int i = 1; i <= nfreq; ++i) {
            freq[i - 1] = f * (double)i;
        }
        return new TrigonometricSeries(freq);
    }

    public static TrigonometricSeries specific(double periodicity) {
        return new TrigonometricSeries(new double[]{Math.PI * 2 / periodicity});
    }

    private TrigonometricSeries(double[] freq) {
        this.w = freq;
    }

    public FastMatrix matrix(int len) {
        return this.matrix(0, len);
    }

    public FastMatrix matrix(int len, int start) {
        int nlast = this.w.length - 1;
        int n = this.w.length * 2;
        boolean zero = false;
        boolean pi = false;
        if (Math.abs(this.w[nlast] - Math.PI) < 1.0E-9) {
            pi = true;
            --n;
        }
        if (Math.abs(this.w[0]) < 1.0E-9) {
            zero = true;
            --n;
        }
        FastMatrix m = FastMatrix.make(len, n);
        int icur = 0;
        int ccur = 0;
        if (zero) {
            m.column(ccur++).set(0.0);
            ++icur;
        }
        while (ccur < n - 1) {
            double v = this.w[icur];
            DataBlock c = m.column(ccur);
            DataBlock s = m.column(ccur + 1);
            for (int j = 0; j < len; ++j) {
                double wj = (double)(start + j) * v;
                c.set(j, Math.cos(wj));
                s.set(j, Math.sin(wj));
            }
            ++icur;
            ccur += 2;
        }
        if (pi) {
            DataBlock c = m.column(ccur);
            c.extract(0, -1, 2).set(1.0);
            c.extract(1, -1, 2).set(-1.0);
        }
        return m;
    }
}

