/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.BookFactoryLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class SpreadsheetManager {
    private final List<Book.Factory> factories;

    @NonNull
    public static SpreadsheetManager ofServiceLoader() {
        return SpreadsheetManager.builder().factories(BookFactoryLoader.get()).build();
    }

    @NonNull
    public Optional<Book.Factory> getReader(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.factories.stream().filter(Book.Factory::canLoad).filter(factory -> factory.accept(file)).findFirst();
    }

    @NonNull
    public Optional<Book.Factory> getWriter(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.factories.stream().filter(Book.Factory::canStore).filter(factory -> factory.accept(file)).findFirst();
    }

    @Generated
    SpreadsheetManager(List<Book.Factory> factories) {
        this.factories = factories;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<Book.Factory> factories;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder factory(Book.Factory factory) {
            if (this.factories == null) {
                this.factories = new ArrayList();
            }
            this.factories.add(factory);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder factories(@org.jspecify.annotations.NonNull Collection<? extends // Could not load outer class - annotation placement on inner may be incorrect
        Book.Factory> factories) {
            if (factories == null) {
                throw new NullPointerException("factories cannot be null");
            }
            if (this.factories == null) {
                this.factories = new ArrayList();
            }
            this.factories.addAll(factories);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearFactories() {
            if (this.factories != null) {
                this.factories.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull SpreadsheetManager build() {
            return new SpreadsheetManager(switch (this.factories == null ? 0 : this.factories.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.factories.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Book.Factory>(this.factories));
            });
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "SpreadsheetManager.Builder(factories=" + String.valueOf(this.factories) + ")";
        }
    }
}

