## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE  # Don't actually run typeRun in vignette
)

## ----setup--------------------------------------------------------------------
# library(typeR)

## ----basic--------------------------------------------------------------------
# # Create a simple script
# cat("# Data Analysis Demo
# x <- 1:10
# mean(x)
# sum(x)
# ", file = "demo.R")
# 
# # Type and execute it
# typeRun("demo.R")

## ----comparison---------------------------------------------------------------
# # typeR: Just displays, doesn't execute
# typeR("demo.R")
# # Output: Shows the code typing out (no results)
# 
# # typeRun: Types AND executes
# typeRun("demo.R")
# # Output: Shows code typing + execution results

## ----speed--------------------------------------------------------------------
# # Slower typing for dramatic effect
# typeRun("demo.R", delay = 0.1, jitter = 0.02)
# 
# # Faster typing for quick demos
# typeRun("demo.R", delay = 0.02, jitter = 0.005)

## ----output-control-----------------------------------------------------------
# cat("
# # Long vector
# long_vec <- 1:1000
# long_vec
# 
# # Large data frame
# big_df <- mtcars[rep(1:32, 10), ]
# big_df
# ", file = "long_output.R")
# 
# # Show only first 5 elements/rows
# typeRun("long_output.R", max_print = 5)

## ----lm-----------------------------------------------------------------------
# cat("
# # Linear regression
# model <- lm(mpg ~ hp + wt, data = mtcars)
# summary(model)
# ", file = "model_demo.R")
# 
# typeRun("model_demo.R")

## ----models-------------------------------------------------------------------
# cat("
# # Logistic regression
# glm_model <- glm(am ~ hp + wt, data = mtcars, family = binomial)
# summary(glm_model)
# 
# # Poisson regression
# pois_model <- glm(carb ~ mpg, data = mtcars, family = poisson)
# summary(pois_model)
# ", file = "glm_demo.R")
# 
# typeRun("glm_demo.R")

## ----statistical-tests, eval=FALSE--------------------------------------------
# library(typeR)
# 
# # Create a test script
# cat('x <- rnorm(50, mean = 20, sd = 3)
# tt <- t.test(x, alternative = "two.sided", conf.level = 0.95)
# tt
# ', file = "test_ttest.R")
# 
# # Run it
# typeRun("test_ttest.R", delay = 0.01)

## ----interactive, eval=FALSE--------------------------------------------------
# typeRun("long_script.R")
# # Press ESC while running
# # Enter 1 to resume
# # Or enter 2 to stop

## -----------------------------------------------------------------------------
# # Create an R Markdown example
# typeRun("report.Rmd")

## ----qmd, eval=FALSE----------------------------------------------------------
# typeRun("analysis.qmd")

## ----env----------------------------------------------------------------------
# # Create custom environment
# my_env <- new.env()
# 
# # Run in that environment
# typeRun("demo.R", envir = my_env)
# 
# # Check what was created
# ls(my_env)
# ls()  # Your global environment is unchanged

## ----library------------------------------------------------------------------
# cat("
# library(ggplot2)  # No startup message shown
# library(dplyr)    # Clean output
# 
# # But code works normally
# mtcars %>% head()
# ", file = "packages.R")
# 
# typeRun("packages.R")
# # Shows only the actual results, not package messages

## ----silent-------------------------------------------------------------------
# cat("
# # Assignments - silent
# x <- 1:10
# y <- mean(x)
# 
# # Plots - execute but don't clutter console
# plot(x, y)
# hist(x)
# 
# # Package loading - no startup messages
# library(stats)
# ", file = "silent.R")
# 
# typeRun("silent.R")

## ----visible------------------------------------------------------------------
# cat("
# # Direct values
# 1:10          # Shows the vector
# 
# # Function calls
# mean(1:10)    # Shows: [1] 5.5
# 
# # Print statements
# print('Hello') # Shows: [1] 'Hello'
# 
# # Model summaries
# summary(lm(mpg ~ hp, data = mtcars))  # Shows full summary
# ", file = "visible.R")
# 
# typeRun("visible.R")

## ----teaching-----------------------------------------------------------------
# cat("
# # Load data
# data(mtcars)
# head(mtcars, 3)
# 
# # Visualize relationship
# plot(mtcars$hp, mtcars$mpg,
#      xlab = 'Horsepower',
#      ylab = 'Miles per Gallon',
#      main = 'MPG vs Horsepower')
# 
# # Fit model
# model <- lm(mpg ~ hp, data = mtcars)
# summary(model)
# 
# # Add regression line
# abline(model, col = 'red', lwd = 2)
# 
# # Predictions
# new_data <- data.frame(hp = c(100, 150, 200))
# predict(model, new_data)
# ", file = "teaching_demo.R")
# 
# typeRun("teaching_demo.R", delay = 0.08)

## ----workflow-----------------------------------------------------------------
# cat("
# # 1. Load and explore
# data <- iris
# str(data)
# 
# # 2. Summary statistics
# summary(data)
# 
# # 3. Visualization
# boxplot(Sepal.Length ~ Species, data = data,
#         main = 'Sepal Length by Species',
#         col = c('lightblue', 'lightgreen', 'pink'))
# 
# # 4. Statistical test
# aov_result <- aov(Sepal.Length ~ Species, data = data)
# summary(aov_result)
# 
# # 5. Post-hoc test
# TukeyHSD(aov_result)
# ", file = "analysis_demo.R")
# 
# typeRun("analysis_demo.R", delay = 0.06, max_print = 8)

## ----glm-example--------------------------------------------------------------
# cat("
# # Binary outcome: Manual transmission (am)
# # Predictors: HP and weight
# 
# # Fit logistic regression
# logit_model <- glm(am ~ hp + wt,
#                    data = mtcars,
#                    family = binomial(link = 'logit'))
# 
# # Model summary
# summary(logit_model)
# 
# # Odds ratios
# exp(coef(logit_model))
# 
# # Predicted probabilities
# mtcars$pred_prob <- predict(logit_model, type = 'response')
# head(mtcars[, c('am', 'hp', 'wt', 'pred_prob')])
# ", file = "glm_example.R")
# 
# typeRun("glm_example.R", max_print = 6)

## ----cleanup, include=FALSE---------------------------------------------------
# # Remove demo files created in this vignette
# files_to_remove <- c(
#   "demo.R", "long_output.R", "model_demo.R", "glm_demo.R",
#   "report.Rmd", "packages.R", "silent.R", "visible.R",
#   "teaching_demo.R", "analysis_demo.R", "glm_example.R"
# )
# invisible(lapply(files_to_remove, function(f) {
#   if (file.exists(f)) file.remove(f)
# }))

