/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import lombok.Generated;

public final class TsDataToolkit {
    public static TsData fn(TsData s, DoubleUnaryOperator fn) {
        return TsData.ofInternal((TsPeriod)s.getStart(), (double[])s.getValues().fn(fn).toArray());
    }

    public static TsData fastFn(TsData s, DoubleUnaryOperator fn) {
        return TsData.of((TsPeriod)s.getStart(), (DoubleSeq)DoubleSeq.onMapping((int)s.length(), i -> fn.applyAsDouble(s.getValue(i))));
    }

    public static TsData commit(TsData s) {
        return TsData.ofInternal((TsPeriod)s.getStart(), (double[])s.getValues().toArray());
    }

    public static TsData fastFn(TsData left, TsData right, DoubleBinaryOperator fn) {
        TsDomain rDomain;
        TsDomain lDomain = left.getDomain();
        TsDomain iDomain = lDomain.intersection(rDomain = right.getDomain());
        if (iDomain == null) {
            return null;
        }
        TsPeriod istart = iDomain.getStartPeriod();
        int li = lDomain.indexOf(istart);
        int ri = rDomain.indexOf(istart);
        return TsData.of((TsPeriod)istart, (DoubleSeq)DoubleSeq.onMapping((int)iDomain.length(), i -> fn.applyAsDouble(left.getValue(li + i), right.getValue(ri + i))));
    }

    public static TsData fn(TsData left, TsData right, DoubleBinaryOperator fn) {
        TsDomain rDomain;
        TsDomain lDomain = left.getDomain();
        TsDomain iDomain = lDomain.intersection(rDomain = right.getDomain());
        if (iDomain == null) {
            return null;
        }
        TsPeriod istart = iDomain.getStartPeriod();
        int li = lDomain.indexOf(istart);
        int ri = rDomain.indexOf(istart);
        double[] data = new double[iDomain.length()];
        DoubleSeqCursor lreader = left.getValues().cursor();
        DoubleSeqCursor rreader = right.getValues().cursor();
        lreader.moveTo(li);
        rreader.moveTo(ri);
        for (int i = 0; i < data.length; ++i) {
            data[i] = fn.applyAsDouble(lreader.getAndNext(), rreader.getAndNext());
        }
        return TsData.ofInternal((TsPeriod)istart, (double[])data);
    }

    public static TsData fn(TsData s, int lag, DoubleBinaryOperator fn) {
        return TsData.ofInternal((TsPeriod)s.getStart().plus((long)lag), (double[])s.getValues().fn(lag, fn).toArray());
    }

    public static TsData drop(TsData s, int nbeg, int nend) {
        int len = s.length() - nbeg - nend;
        TsPeriod start = s.getStart().plus((long)nbeg);
        return TsData.ofInternal((TsPeriod)start, (double[])s.getValues().extract(nbeg, Math.max(0, len)).toArray());
    }

    public static TsData extend(TsData s, int nbeg, int nend) {
        TsPeriod start = s.getStart().plus((long)(-nbeg));
        return TsData.of((TsPeriod)start, (DoubleSeq)s.getValues().extend(nbeg, nend));
    }

    public static TsData select(TsData s, TimeSelector selector) {
        TsDomain ndomain = s.getDomain().select(selector);
        int beg = s.getStart().until(ndomain.getStartPeriod());
        return TsData.ofInternal((TsPeriod)ndomain.getStartPeriod(), (double[])s.getValues().extract(beg, ndomain.length()).toArray());
    }

    public static TsData fitToDomain(TsData s, TsDomain domain) {
        int ncommon;
        int cur;
        if (!s.getTsUnit().equals((Object)domain.getStartPeriod().getUnit())) {
            throw new TsException("Incompatible frequencies");
        }
        TsDomain sdomain = s.getDomain();
        int nbeg = sdomain.getStartPeriod().until(domain.getStartPeriod());
        TsDomain idomain = domain.intersection(sdomain);
        double[] data = new double[domain.length()];
        if (nbeg < 0) {
            int cmax = Math.min(-nbeg, data.length);
            for (cur = 0; cur < cmax; ++cur) {
                data[cur] = Double.NaN;
            }
        }
        if ((ncommon = idomain.length()) > 0) {
            s.getValues().extract(sdomain.getStartPeriod().until(idomain.getStartPeriod()), ncommon).copyTo(data, cur);
            cur += ncommon;
        }
        while (cur < data.length) {
            data[cur] = Double.NaN;
            ++cur;
        }
        return TsData.ofInternal((TsPeriod)domain.getStartPeriod(), (double[])data);
    }

    public static TsData log(TsData s) {
        return TsDataToolkit.fastFn(s, x -> Math.log(x));
    }

    public static TsData exp(TsData s) {
        return TsDataToolkit.fastFn(s, x -> Math.exp(x));
    }

    public static TsData inv(TsData s) {
        return TsDataToolkit.fastFn(s, x -> 1.0 / x);
    }

    public static TsData chs(TsData s) {
        return TsDataToolkit.fastFn(s, x -> -x);
    }

    public static TsData abs(TsData s) {
        return TsDataToolkit.fastFn(s, x -> Math.abs(x));
    }

    public static TsData add(TsData l, TsData r) {
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return TsDataToolkit.fn(l, r, (double a, double b) -> a + b);
    }

    public static TsData add(TsData l, double d) {
        if (d == 0.0) {
            return l;
        }
        return TsDataToolkit.fastFn(l, x -> x + d);
    }

    public static TsData subtract(TsData l, double d) {
        if (d == 0.0) {
            return l;
        }
        return TsDataToolkit.fastFn(l, x -> x - d);
    }

    public static double distance(TsData l, TsData r) {
        DoubleSeq diff = TsDataToolkit.subtract(l, r).getValues();
        int n = diff.count(x -> Double.isFinite(x));
        if (n == 0) {
            return Double.NaN;
        }
        return Math.sqrt(diff.ssqWithMissing() / (double)n);
    }

    public static TsData subtract(double d, TsData l) {
        if (d == 0.0) {
            return TsDataToolkit.chs(l);
        }
        return TsDataToolkit.fastFn(l, x -> d - x);
    }

    public static TsData subtract(TsData l, TsData r) {
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return TsDataToolkit.fastFn(l, r, (a, b) -> a - b);
    }

    public static TsData multiply(TsData l, TsData r) {
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return TsDataToolkit.fastFn(l, r, (a, b) -> a * b);
    }

    public static TsData multiply(TsData l, double d) {
        if (d == 1.0) {
            return l;
        }
        if (d == 0.0) {
            return TsDataToolkit.fastFn(l, x -> 0.0);
        }
        return TsDataToolkit.fastFn(l, x -> x * d);
    }

    public static TsData divide(TsData l, TsData r) {
        if (l == null) {
            return TsDataToolkit.inv(r);
        }
        if (r == null) {
            return l;
        }
        return TsDataToolkit.fastFn(l, r, (a, b) -> a / b);
    }

    public static TsData divide(TsData l, double d) {
        if (d == 1.0) {
            return l;
        }
        return TsDataToolkit.fastFn(l, x -> x / d);
    }

    public static TsData divide(double d, TsData l) {
        return TsDataToolkit.fastFn(l, x -> d / x);
    }

    public static TsData delta(TsData s, int lag) {
        return TsDataToolkit.fn(s, lag, (double x, double y) -> y - x);
    }

    public static TsData delta(TsData s, int lag, int pow) {
        TsData ns = s;
        for (int i = 0; i < pow; ++i) {
            ns = TsDataToolkit.fn(ns, lag, (double x, double y) -> y - x);
        }
        return ns;
    }

    public static TsData pctVariation(TsData s, int lag) {
        return TsDataToolkit.fn(s, lag, (double x, double y) -> (y / x - 1.0) * 100.0);
    }

    public static TsData normalize(TsData s) {
        double[] data = s.getValues().toArray();
        DataBlock values = DataBlock.of(data);
        double mean = values.average();
        double ssqc = values.ssqc(mean);
        double std = Math.sqrt(ssqc / (double)values.length());
        for (int i = 0; i < data.length; ++i) {
            data[i] = (data[i] - mean) / std;
        }
        return TsData.ofInternal((TsPeriod)s.getStart(), (double[])data);
    }

    public static TsData lead(TsData s, int lead) {
        return lead == 0 ? s : TsData.of((TsPeriod)s.getStart().plus((long)(-lead)), (DoubleSeq)s.getValues());
    }

    public static TsData lag(TsData s, int lag) {
        return lag == 0 ? s : TsData.of((TsPeriod)s.getStart().plus((long)lag), (DoubleSeq)s.getValues());
    }

    public static TsData apply(IFiniteFilter filter, TsData s) {
        double[] data = s.getValues().toArray();
        double[] result = new double[data.length - filter.length() + 1];
        filter.apply(DataBlock.of(data), DataBlock.of(result));
        return TsData.ofInternal((TsPeriod)s.getStart().plus((long)(-filter.getLowerBound())), (double[])result);
    }

    @Generated
    private TsDataToolkit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

