/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import jdplus.toolkit.base.core.data.analysis.Taper;

public class TukeyHanningTaper
implements Taper {
    private final double r;

    public TukeyHanningTaper(double r) {
        if (r < 0.0 || r > 1.0) {
            throw new IllegalArgumentException();
        }
        this.r = r;
    }

    @Override
    public void process(double[] x) {
        double xpi;
        double xtap;
        int l = x.length;
        int len = (int)((double)l * this.r * 0.5);
        int i = 0;
        while (i < len) {
            xtap = ((double)i + 0.5) / (double)l;
            xpi = Math.PI * 2 * xtap / this.r;
            int n = i++;
            x[n] = x[n] * ((1.0 - Math.cos(xpi)) / 2.0);
        }
        i = x.length - len;
        while (i < x.length) {
            xtap = ((double)i + 0.5) / (double)l;
            xpi = Math.PI * 2 * (1.0 - xtap) / this.r;
            int n = i++;
            x[n] = x[n] * ((1.0 - Math.cos(xpi)) / 2.0);
        }
    }
}

