/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees.iadem;

import java.io.Serializable;
import java.util.ArrayList;
import moa.classifiers.trees.iadem.IademCommonProcedures;
import moa.classifiers.trees.iadem.IademException;

public final class IademSplitCriterion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ENTROPY = 0;
    private static final int ENTROPY_LOG_VAR = 1;
    private static final int WEIGHTED_ENTROPY_LOG_VAR = 2;
    private static final int WEIGHTED_ENTROPY = 9;
    private static final int BETA_1 = 3;
    private static final int GAMMA_1 = 4;
    private static final int BETA_2 = 5;
    private static final int GAMMA_2 = 6;
    private static final int BETA_4 = 7;
    private static final int GAMMA_4 = 8;
    private static final int ERROR_GAIN = 10;
    private static final String ENTROPY_TEXT = "entropy";
    private static final String ENTROPY_LOG_VAR_TEXT = "entropy_logVar";
    private static final String WEIGHTED_ENTROPY_LOG_VAR_TEXT = "entropy_logVar+Weight";
    private static final String WEIGHTED_ENTROPY_TEXT = "entropy+Weight";
    private static final String BETA_1_TEXT = "beta1";
    private static final String BETA_2_TEXT = "beta2";
    private static final String BETA_4_TEXT = "beta4";
    private static final String GAMMA_1_TEXT = "gamma1";
    private static final String GAMMA_2_TEXT = "gamma2";
    private static final String GAMMA_4_TEXT = "gamma4";
    private static final String ERROR_GAIN_TEXT = "error_gain";
    private int splitMeasure;

    public IademSplitCriterion() {
        this.splitMeasure = 0;
    }

    public IademSplitCriterion(String splitMeasure) throws IademException {
        try {
            this.setSplitMeasure(splitMeasure);
        }
        catch (IademException e) {
            throw new IademException("MySplitMeasure", "constructor", "Measure could not be created\n" + e.getMessage());
        }
    }

    public String getSplitMeasureText() {
        String splitMeasureText = "";
        switch (this.splitMeasure) {
            case 0: {
                splitMeasureText = ENTROPY_TEXT;
                break;
            }
            case 1: {
                splitMeasureText = ENTROPY_LOG_VAR_TEXT;
                break;
            }
            case 2: {
                splitMeasureText = WEIGHTED_ENTROPY_LOG_VAR_TEXT;
                break;
            }
            case 9: {
                splitMeasureText = WEIGHTED_ENTROPY_TEXT;
                break;
            }
            case 3: {
                splitMeasureText = BETA_1_TEXT;
                break;
            }
            case 4: {
                splitMeasureText = GAMMA_1_TEXT;
                break;
            }
            case 5: {
                splitMeasureText = BETA_2_TEXT;
                break;
            }
            case 6: {
                splitMeasureText = GAMMA_2_TEXT;
                break;
            }
            case 7: {
                splitMeasureText = BETA_4_TEXT;
                break;
            }
            case 8: {
                splitMeasureText = GAMMA_4_TEXT;
                break;
            }
            case 10: {
                splitMeasureText = ERROR_GAIN_TEXT;
            }
        }
        return splitMeasureText;
    }

    public void setSplitMeasure(String splitMeasureType) throws IademException {
        if (splitMeasureType.equals(ENTROPY_TEXT)) {
            this.splitMeasure = 0;
        } else if (splitMeasureType.equals(ENTROPY_LOG_VAR_TEXT)) {
            this.splitMeasure = 1;
        } else if (splitMeasureType.equals(WEIGHTED_ENTROPY_LOG_VAR_TEXT)) {
            this.splitMeasure = 2;
        } else if (splitMeasureType.equals(WEIGHTED_ENTROPY_TEXT)) {
            this.splitMeasure = 9;
        } else if (splitMeasureType.equals(BETA_1_TEXT)) {
            this.splitMeasure = 3;
        } else if (splitMeasureType.equals(GAMMA_1_TEXT)) {
            this.splitMeasure = 4;
        } else if (splitMeasureType.equals(BETA_2_TEXT)) {
            this.splitMeasure = 5;
        } else if (splitMeasureType.equals(GAMMA_2_TEXT)) {
            this.splitMeasure = 6;
        } else if (splitMeasureType.equals(BETA_4_TEXT)) {
            this.splitMeasure = 7;
        } else if (splitMeasureType.equals(GAMMA_4_TEXT)) {
            this.splitMeasure = 8;
        } else if (splitMeasureType.equals(ERROR_GAIN_TEXT)) {
            this.splitMeasure = 10;
        } else {
            throw new IademException("MySplitMeasure", "setSplitMeasure", "Measure does not exist");
        }
    }

    public static ArrayList<String> getSplitMeasureOptions() {
        ArrayList<String> splitMeasureList = new ArrayList<String>();
        splitMeasureList.add(ENTROPY_TEXT);
        splitMeasureList.add(ENTROPY_LOG_VAR_TEXT);
        splitMeasureList.add(WEIGHTED_ENTROPY_LOG_VAR_TEXT);
        splitMeasureList.add(WEIGHTED_ENTROPY_TEXT);
        splitMeasureList.add(BETA_1_TEXT);
        splitMeasureList.add(GAMMA_1_TEXT);
        splitMeasureList.add(BETA_2_TEXT);
        splitMeasureList.add(GAMMA_2_TEXT);
        splitMeasureList.add(BETA_4_TEXT);
        splitMeasureList.add(GAMMA_4_TEXT);
        return splitMeasureList;
    }

    public static String getDefaultSplitMeasure() {
        return ENTROPY_TEXT;
    }

    public double doMeasure(ArrayList<Double> vector) throws IademException {
        double logBase = vector.size();
        double measure = 0.0;
        switch (this.splitMeasure) {
            case 0: {
                logBase = vector.size();
                if (logBase > 1.0) {
                    double n = 0.0;
                    for (Double elem : vector) {
                        double tmpValue = elem;
                        if (tmpValue > 0.0) {
                            n += tmpValue;
                            continue;
                        }
                        if (!(tmpValue < 0.0)) continue;
                        throw new IademException("MySplitMeasure", "doMeasure", "All values must be positive");
                    }
                    if (n == 0.0) {
                        throw new IademException("MySplitMeasure", "doMeasure", "Vector must be different from 0.0");
                    }
                    double a_i = 0.0;
                    double sum = 0.0;
                    for (int i = 0; i < vector.size(); ++i) {
                        a_i = vector.get(i);
                        if (!(a_i > 0.0)) continue;
                        sum += a_i * IademCommonProcedures.log(logBase, a_i);
                    }
                    measure = -(1.0 / n * (sum - n * IademCommonProcedures.log(logBase, n)));
                    break;
                }
                if (logBase != 1.0) break;
                measure = 0.0;
                break;
            }
            case 1: {
                if (logBase > 1.0) {
                    double n = 0.0;
                    for (Double elem : vector) {
                        double tmpValue = elem;
                        if (tmpValue > 0.0) {
                            n += tmpValue;
                            continue;
                        }
                        if (!(tmpValue < 0.0)) continue;
                        throw new IademException("MySplitMeasure", "doMeasure", "All values must be positive");
                    }
                    if (n == 0.0) {
                        throw new IademException("MySplitMeasure", "doMeasure", "Vector must be different from 0.0");
                    }
                    double a_i = 0.0;
                    double sum = 0.0;
                    for (Double elem : vector) {
                        a_i = elem;
                        if (!(a_i > 0.0)) continue;
                        sum += a_i * IademCommonProcedures.log(logBase, a_i);
                    }
                    measure = -(1.0 / n * (sum - n * IademCommonProcedures.log(logBase, n)));
                    break;
                }
                if (logBase != 1.0) break;
                measure = 0.0;
                break;
            }
            case 9: {
                if (logBase > 1.0) {
                    double n = 0.0;
                    for (int i = 0; i < vector.size(); ++i) {
                        double tmpValue = vector.get(i);
                        if (tmpValue > 0.0) {
                            n += tmpValue;
                            continue;
                        }
                        if (!(tmpValue < 0.0)) continue;
                        throw new IademException("MySplitMeasure", "doMeasure", "All values must be positive");
                    }
                    if (n == 0.0) {
                        measure = 0.0;
                        break;
                    }
                    double a_i = 0.0;
                    double sum = 0.0;
                    for (int i = 0; i < vector.size(); ++i) {
                        a_i = vector.get(i);
                        if (!(a_i > 0.0)) continue;
                        sum += a_i * IademCommonProcedures.log(logBase, a_i);
                    }
                    measure = -(1.0 / n * (sum - n * IademCommonProcedures.log(logBase, n)));
                    break;
                }
                if (logBase != 1.0) break;
                measure = 0.0;
                break;
            }
            case 2: {
                logBase = vector.size();
                if (logBase > 1.0) {
                    double n = 0.0;
                    for (int i = 0; i < vector.size(); ++i) {
                        double tmpValue = vector.get(i);
                        if (tmpValue > 0.0) {
                            n += tmpValue;
                            continue;
                        }
                        if (!(tmpValue < 0.0)) continue;
                        throw new IademException("MySplitMeasure", "doMeasure", "All values must be positive");
                    }
                    if (n == 0.0) {
                        measure = 0.0;
                        break;
                    }
                    double a_i = 0.0;
                    double sum = 0.0;
                    for (Double elem : vector) {
                        a_i = elem;
                        if (!(a_i > 0.0)) continue;
                        sum += a_i * IademCommonProcedures.log(logBase, a_i);
                    }
                    measure = -(1.0 / n * (sum - n * IademCommonProcedures.log(logBase, n)));
                    break;
                }
                if (logBase != 1.0) break;
                measure = 0.0;
                break;
            }
            case 3: {
                double mayor = 0.0;
                for (Double elem : vector) {
                    mayor = Math.max(mayor, elem);
                }
                measure = 1.0 - mayor;
                break;
            }
            case 4: {
                double max = 0.0;
                for (Double elem : vector) {
                    max = Math.max(max, elem);
                }
                measure = 1.0 - max;
                measure = Math.sqrt(2.0 * measure);
                break;
            }
            case 5: {
                double mayor = 0.0;
                double sum = 0.0;
                for (Double elem : vector) {
                    double num = elem;
                    mayor = Math.max(mayor, num);
                    sum += num * num;
                }
                measure = 1.0 - mayor + mayor * mayor - sum;
                break;
            }
            case 6: {
                double max = 0.0;
                double sum = 0.0;
                for (Double elem : vector) {
                    double num = elem;
                    max = Math.max(max, num);
                    sum += num * num;
                }
                measure = 1.0 - max + max * max - sum;
                measure = Math.sqrt(4.0 * measure);
                break;
            }
            case 7: {
                double sum = 0.0;
                for (Double elem : vector) {
                    double num = elem;
                    sum += num * num;
                }
                measure = 1.0 - sum;
                break;
            }
            case 8: {
                double sum = 0.0;
                for (Double elem : vector) {
                    double num = elem;
                    sum += num * num;
                }
                measure = 1.0 - sum;
                measure = Math.sqrt(2.0 * measure);
            }
        }
        if (measure < 0.0) {
            throw new IademException("MySplitMeasure", "doMeasure", "Measure could not be calculated");
        }
        return measure;
    }
}

