/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DerivedAttribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.SingleValue;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.vikamine.kernel.util.DistinctionFinder;

public class DerivedNumericAttribute
extends NumericAttribute
implements DerivedAttribute {
    private FormulaNumberElement formula;
    private Map<Long, Double> cache;

    protected DerivedNumericAttribute(String attributeName) {
        super(attributeName);
    }

    @Override
    public double computeValue(DataRecord instance) {
        EvaluationData data = new EvaluationData();
        data.setInstance(instance);
        return this.getFormula().eval(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCache(Iterator<DataRecord> populationInstanceIterator) {
        HashMap<Long, Double> newCache = new HashMap<Long, Double>();
        while (populationInstanceIterator.hasNext()) {
            DataRecord inst = populationInstanceIterator.next();
            newCache.put(inst.getID(), this.value(inst));
        }
        DerivedNumericAttribute derivedNumericAttribute = this;
        synchronized (derivedNumericAttribute) {
            this.cache = newCache;
        }
    }

    @Override
    public FormulaNumberElement getFormula() {
        return this.formula;
    }

    @Override
    public void setFormula(FormulaNumberElement formula) {
        this.formula = formula;
    }

    @Override
    public double getValue(DataRecord instance) {
        return this.value(instance);
    }

    public synchronized double value(DataRecord instance) {
        if (this.cache != null) {
            long id = instance.getID();
            Double value = this.cache.get(id);
            if (value == null) {
                value = new Double(this.computeValue(instance));
                this.cache.put(id, value);
            }
            return value;
        }
        return this.computeValue(instance);
    }

    @Override
    public Iterator<Value> usedValuesIterator(IDataRecordSet dataset) {
        LinkedList<Double> values = new LinkedList<Double>();
        for (DataRecord inst : dataset) {
            values.add(new Double(this.value(inst)));
        }
        Collections.sort(values);
        LinkedList<SingleValue> distinctValues = new LinkedList<SingleValue>();
        DistinctionFinder distinct = new DistinctionFinder();
        for (Double value : values) {
            distinct.addValue(value);
            if (!distinct.isNewValue()) continue;
            distinctValues.add(SingleValue.createSimpleSingleValue(this, value));
        }
        return distinctValues.iterator();
    }

    @Override
    public DerivedNumericAttribute copy() {
        DerivedNumericAttribute copiedNumericAttribute = new DerivedNumericAttribute(this.getId());
        copiedNumericAttribute.usedInstancesForAttributeValues = this.usedInstancesForAttributeValues;
        copiedNumericAttribute.weakDatasetReference = this.weakDatasetReference;
        copiedNumericAttribute.formula = this.formula;
        return copiedNumericAttribute;
    }
}

