/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import weka.classifiers.UpdateableClassifier;
import weka.classifiers.bayes.NaiveBayesMultinomial;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class NaiveBayesMultinomialUpdateable
extends NaiveBayesMultinomial
implements UpdateableClassifier {
    private static final long serialVersionUID = -7204398796974263186L;
    protected double[] m_wordsPerClass;

    @Override
    public String globalInfo() {
        return String.valueOf(super.globalInfo()) + "\n\n" + "Incremental version of the algorithm.";
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_headerInfo = new Instances(instances, 0);
        this.m_numClasses = instances.numClasses();
        this.m_numAttributes = instances.numAttributes();
        this.m_probOfWordGivenClass = new double[this.m_numClasses][];
        this.m_wordsPerClass = new double[this.m_numClasses];
        this.m_probOfClass = new double[this.m_numClasses];
        double laplace = 1.0;
        int c = 0;
        while (c < this.m_numClasses) {
            this.m_probOfWordGivenClass[c] = new double[this.m_numAttributes];
            this.m_probOfClass[c] = laplace;
            this.m_wordsPerClass[c] = laplace * (double)this.m_numAttributes;
            int att = 0;
            while (att < this.m_numAttributes) {
                this.m_probOfWordGivenClass[c][att] = laplace;
                ++att;
            }
            ++c;
        }
        int i = 0;
        while (i < instances.numInstances()) {
            this.updateClassifier(instances.instance(i));
            ++i;
        }
    }

    @Override
    public void updateClassifier(Instance instance) throws Exception {
        int classIndex;
        int n = classIndex = (int)instance.value(instance.classIndex());
        this.m_probOfClass[n] = this.m_probOfClass[n] + instance.weight();
        int a = 0;
        while (a < instance.numValues()) {
            if (instance.index(a) != instance.classIndex() && !instance.isMissing(a)) {
                double numOccurences = instance.valueSparse(a) * instance.weight();
                int n2 = classIndex;
                this.m_wordsPerClass[n2] = this.m_wordsPerClass[n2] + numOccurences;
                if (this.m_wordsPerClass[classIndex] < 0.0) {
                    throw new Exception("Can't have a negative number of words for class " + (classIndex + 1));
                }
                double[] dArray = this.m_probOfWordGivenClass[classIndex];
                int n3 = instance.index(a);
                dArray[n3] = dArray[n3] + numOccurences;
                if (this.m_probOfWordGivenClass[classIndex][instance.index(a)] < 0.0) {
                    throw new Exception("Can't have a negative conditional sum for attribute " + instance.index(a));
                }
            }
            ++a;
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int i;
        double[] probOfClassGivenDoc = new double[this.m_numClasses];
        double[] logDocGivenClass = new double[this.m_numClasses];
        int c = 0;
        while (c < this.m_numClasses) {
            int n = c;
            logDocGivenClass[n] = logDocGivenClass[n] + Math.log(this.m_probOfClass[c]);
            int allWords = 0;
            i = 0;
            while (i < instance.numValues()) {
                if (instance.index(i) != instance.classIndex()) {
                    double frequencies = instance.valueSparse(i);
                    allWords = (int)((double)allWords + frequencies);
                    int n2 = c;
                    logDocGivenClass[n2] = logDocGivenClass[n2] + frequencies * Math.log(this.m_probOfWordGivenClass[c][instance.index(i)]);
                }
                ++i;
            }
            int n3 = c;
            logDocGivenClass[n3] = logDocGivenClass[n3] - (double)allWords * Math.log(this.m_wordsPerClass[c]);
            ++c;
        }
        double max = logDocGivenClass[Utils.maxIndex(logDocGivenClass)];
        i = 0;
        while (i < this.m_numClasses) {
            probOfClassGivenDoc[i] = Math.exp(logDocGivenClass[i] - max);
            ++i;
        }
        Utils.normalize(probOfClassGivenDoc);
        return probOfClassGivenDoc;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("The independent probability of a class\n");
        result.append("--------------------------------------\n");
        int c = 0;
        while (c < this.m_numClasses) {
            result.append(this.m_headerInfo.classAttribute().value(c)).append("\t").append(Double.toString(this.m_probOfClass[c])).append("\n");
            ++c;
        }
        result.append("\nThe probability of a word given the class\n");
        result.append("-----------------------------------------\n\t");
        c = 0;
        while (c < this.m_numClasses) {
            result.append(this.m_headerInfo.classAttribute().value(c)).append("\t");
            ++c;
        }
        result.append("\n");
        int w = 0;
        while (w < this.m_numAttributes) {
            result.append(this.m_headerInfo.attribute(w).name()).append("\t");
            int c2 = 0;
            while (c2 < this.m_numClasses) {
                result.append(Double.toString(Math.exp(this.m_probOfWordGivenClass[c2][w]))).append("\t");
                ++c2;
            }
            result.append("\n");
            ++w;
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    public static void main(String[] args) {
        NaiveBayesMultinomialUpdateable.runClassifier(new NaiveBayesMultinomialUpdateable(), args);
    }
}

