/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import java.util.Objects;
import java.util.Random;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.IntList;
import org.chocosolver.util.tools.VariableUtils;

public class ImpactBased
extends AbstractStrategy<IntVar>
implements IMonitorDownBranch,
IMonitorContradiction,
ICause {
    private IntValueSelector valueSelector = new ImpactValueSelector();
    private final int aging;
    private double[][] Ilabel;
    private int[] offsets;
    private final int split;
    private final IStateDouble searchSpaceSize;
    private int currentVar = -1;
    private int currentVal = -1;
    private final IntList bests = new IntList();
    private final Random random;
    private final int nodeImpact;
    private final Model model;
    private final boolean initOnly;
    private boolean asgntFailed;
    private boolean learnsAndFails;
    private final long initTimeLimit = Integer.MAX_VALUE;
    private final long reevalTimeLimit = Integer.MAX_VALUE;
    private int idx = 0;

    public ImpactBased(IntVar[] ivariables, IntValueSelector valueSelector, int alpha, int split, int nodeImpact, long seed, boolean initOnly) {
        super((Variable[])ivariables);
        if (valueSelector != null) {
            this.valueSelector = valueSelector;
        }
        this.model = ivariables[0].getModel();
        this.aging = alpha;
        this.split = (int)Math.pow(2.0, split);
        this.searchSpaceSize = this.model.getEnvironment().makeFloat(1.0);
        this.random = new Random(seed);
        this.nodeImpact = nodeImpact;
        this.initOnly = initOnly;
    }

    public ImpactBased(IntVar[] vars, int i, int i1, int i2, long seed, boolean initOnly) {
        this(vars, null, 2, 512, 2048, 0L, initOnly);
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        if (this.currentVar == -1 || ((IntVar[])this.vars)[this.currentVar] != variable) {
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                if (((IntVar[])this.vars)[i] != variable) continue;
                this.currentVar = i;
            }
            assert (((IntVar[])this.vars)[this.currentVar] == variable);
        }
        this.currentVal = this.valueSelector.selectValue(variable);
        return this.makeIntDecision(variable, this.currentVal);
    }

    @Override
    public Decision<IntVar> getDecision() {
        this.reevaluateImpact();
        IntVar best = null;
        this.bests.clear();
        double bestImpact = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) continue;
            double imp = this.computeImpact(i);
            assert (!Double.isNaN(imp));
            if (imp > bestImpact) {
                this.bests.clear();
                this.bests.add(i);
                bestImpact = imp;
                continue;
            }
            if (imp != bestImpact) continue;
            this.bests.add(i);
        }
        if (this.bests.size() > 0) {
            this.currentVar = this.bests.get(this.random.nextInt(this.bests.size()));
            best = ((IntVar[])this.vars)[this.currentVar];
        }
        return this.computeDecision(best);
    }

    @Override
    public boolean init() {
        int dsz;
        int UB;
        int offset;
        IntVar v;
        int i;
        long l = System.currentTimeMillis();
        Objects.requireNonNull(this);
        long tl = l + Integer.MAX_VALUE;
        if (!this.initOnly && !this.model.getSolver().getSearchMonitors().contains(this)) {
            this.model.getSolver().plugMonitor(this);
        }
        this.Ilabel = new double[((IntVar[])this.vars).length][];
        this.offsets = new int[((IntVar[])this.vars).length];
        double before = VariableUtils.searchSpaceSize((IntVar[])this.vars);
        this.searchSpaceSize.set(before);
        this.learnsAndFails = false;
        block0: for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            v = ((IntVar[])this.vars)[i];
            offset = v.getLB();
            UB = v.getUB();
            dsz = UB - offset + 1;
            if (v.isInstantiated()) continue;
            this.Ilabel[i] = new double[v.hasEnumeratedDomain() ? dsz : 1];
            this.offsets[i] = offset;
            if (v.hasEnumeratedDomain()) {
                int a2;
                if (v.getDomainSize() < this.split) {
                    DisposableValueIterator it = v.getValueIterator(true);
                    while (it.hasNext()) {
                        double im;
                        if (System.currentTimeMillis() > tl) break block0;
                        a2 = it.next();
                        this.Ilabel[i][a2 - offset] = im = this.computeImpact(v, a2, before);
                    }
                    it.dispose();
                    continue;
                }
                int size = dsz / this.split;
                DisposableValueIterator it = v.getValueIterator(true);
                while (it.hasNext()) {
                    int b;
                    if (System.currentTimeMillis() > tl) break block0;
                    a2 = b = it.next();
                    for (int step = 0; step < size && it.hasNext(); ++step) {
                        b = it.next();
                    }
                    double im = this.computeImpactB(v, a2, b, before);
                    for (int j = a2; j <= b; ++j) {
                        this.Ilabel[i][j - offset] = im;
                    }
                }
                it.dispose();
                continue;
            }
            if (System.currentTimeMillis() > tl) break;
            double i1 = this.computeImpact(v, v.getLB(), before);
            double i2 = this.computeImpact(v, v.getUB(), before);
            double i3 = this.computeImpact(v, (v.getLB() + v.getUB()) / 2, before);
            this.Ilabel[i][0] = (i1 + i2 + i3) / 3.0;
        }
        if (this.learnsAndFails) {
            this.learnsAndFails = false;
            return false;
        }
        if (System.currentTimeMillis() > tl) {
            if (this.model.getSettings().warnUser()) {
                this.model.getSolver().log().println("impact Search stops its init phase -- reach time limit!");
            }
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                v = ((IntVar[])this.vars)[i];
                offset = v.getLB();
                UB = v.getUB();
                dsz = UB - offset + 1;
                if (v.isInstantiated() || this.Ilabel[i] != null) continue;
                this.Ilabel[i] = new double[v.hasEnumeratedDomain() ? dsz : 1];
                this.offsets[i] = offset;
            }
        }
        return true;
    }

    @Override
    public void remove() {
        if (!this.initOnly && this.model.getSolver().getSearchMonitors().contains(this)) {
            this.model.getSolver().unplugMonitor(this);
        }
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        this.asgntFailed = true;
    }

    @Override
    public void afterDownBranch(boolean left) {
        if (left) {
            if (this.currentVar > -1) {
                if (this.asgntFailed) {
                    this.updateImpact(1.0, this.currentVar, this.currentVal);
                } else {
                    double sssz = VariableUtils.searchSpaceSize((IntVar[])this.vars);
                    this.updateImpact(sssz / this.searchSpaceSize.get(), this.currentVar, this.currentVal);
                    this.searchSpaceSize.set(sssz);
                }
                this.currentVar = -1;
            }
            this.asgntFailed = false;
        }
    }

    private double computeImpact(int idx) {
        IntVar var = ((IntVar[])this.vars)[idx];
        if (var.hasEnumeratedDomain()) {
            int of = this.offsets[idx];
            DisposableValueIterator it = var.getValueIterator(true);
            double impact = 0.0;
            while (it.hasNext()) {
                int val = it.next();
                impact += this.Ilabel[idx][val - of];
            }
            it.dispose();
            return impact - (double)var.getDomainSize();
        }
        return this.Ilabel[idx][0] - (double)var.getDomainSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double computeImpact(IntVar v, int a2, double before) {
        this.model.getEnvironment().worldPush();
        try {
            v.instantiateTo(a2, (ICause)this);
            this.model.getSolver().getEngine().propagate();
            double after = VariableUtils.searchSpaceSize((IntVar[])this.vars);
            double d = 1.0 - after / before;
            return d;
        }
        catch (ContradictionException e) {
            this.model.getSolver().getEngine().flush();
            this.model.getEnvironment().worldPop();
            this.model.getEnvironment().worldPush();
            try {
                v.removeValue(a2, (ICause)this);
                this.model.getSolver().getEngine().propagate();
            }
            catch (ContradictionException ex) {
                this.learnsAndFails = true;
                this.model.getSolver().getEngine().flush();
            }
            double d = 1.0;
            return d;
        }
        finally {
            this.model.getEnvironment().worldPop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double computeImpactB(IntVar v, int a2, int b, double before) {
        this.model.getEnvironment().worldPush();
        try {
            v.updateBounds(a2, b, this);
            this.model.getSolver().getEngine().propagate();
            double after = VariableUtils.searchSpaceSize((IntVar[])this.vars);
            double d = 1.0 - after / before;
            return d;
        }
        catch (ContradictionException e) {
            this.model.getSolver().getEngine().flush();
            this.model.getEnvironment().worldPop();
            this.model.getEnvironment().worldPush();
            try {
                v.removeInterval(a2, b, this);
                this.model.getSolver().getEngine().propagate();
            }
            catch (ContradictionException ex) {
                this.learnsAndFails = true;
                this.model.getSolver().getEngine().flush();
            }
            double d = 1.0;
            return d;
        }
        finally {
            this.model.getEnvironment().worldPop();
        }
    }

    private void updateImpact(double nImpact, int varIdx, int valIdx) {
        valIdx = this.Ilabel[varIdx].length > 1 ? valIdx - this.offsets[varIdx] : 0;
        double impact = this.Ilabel[varIdx][valIdx] * (double)(this.aging - 1);
        impact += nImpact;
        assert (!Double.isNaN(impact /= (double)this.aging));
        this.Ilabel[varIdx][valIdx] = impact;
    }

    private void reevaluateImpact() {
        if (!this.initOnly && this.nodeImpact > 0 && this.model.getSolver().getNodeCount() % (long)this.nodeImpact == 0L) {
            long l = System.currentTimeMillis();
            Objects.requireNonNull(this);
            long tl = l + Integer.MAX_VALUE;
            double before = this.searchSpaceSize.get();
            this.learnsAndFails = false;
            while (this.idx < ((IntVar[])this.vars).length) {
                IntVar v = ((IntVar[])this.vars)[this.idx];
                int dsz = v.getDomainSize();
                if (System.currentTimeMillis() > tl) {
                    if (this.learnsAndFails) {
                        this.learnsAndFails = false;
                    }
                    return;
                }
                if (!v.isInstantiated()) {
                    if (v.hasEnumeratedDomain()) {
                        int a2;
                        if (v.getDomainSize() < this.split) {
                            DisposableValueIterator it = v.getValueIterator(true);
                            while (it.hasNext()) {
                                a2 = it.next();
                                double im = this.computeImpact(v, a2, before);
                                assert (!Double.isNaN(im));
                                this.updateImpact(im, this.idx, a2);
                            }
                            it.dispose();
                        } else {
                            int size = dsz / this.split;
                            DisposableValueIterator it = v.getValueIterator(true);
                            while (it.hasNext()) {
                                int b;
                                a2 = b = it.next();
                                for (int step = 0; step < size && it.hasNext(); ++step) {
                                    b = it.next();
                                }
                                double im = this.computeImpactB(v, a2, b, before);
                                for (int j = a2; j <= b; ++j) {
                                    this.updateImpact(im, this.idx, j);
                                }
                            }
                            it.dispose();
                        }
                    } else {
                        double i1 = this.computeImpact(v, v.getLB(), before);
                        double i2 = this.computeImpact(v, v.getUB(), before);
                        double i3 = this.computeImpact(v, (v.getLB() + v.getUB()) / 2, before);
                        double im = (i1 + i2 + i3) / 3.0;
                        assert (!Double.isNaN(im));
                        this.updateImpact(im, this.idx, 0);
                    }
                }
                ++this.idx;
            }
            if (this.idx == ((IntVar[])this.vars).length) {
                this.idx = 0;
            }
            if (this.learnsAndFails) {
                this.learnsAndFails = false;
            }
        }
    }

    private class ImpactValueSelector
    implements IntValueSelector {
        private ImpactValueSelector() {
        }

        @Override
        public int selectValue(IntVar var) {
            ImpactBased.this.bests.clear();
            double bestImpact = Double.POSITIVE_INFINITY;
            if (var.hasEnumeratedDomain()) {
                DisposableValueIterator it = var.getValueIterator(true);
                int o = ImpactBased.this.offsets[ImpactBased.this.currentVar];
                while (it.hasNext()) {
                    int val = it.next();
                    double impact = ImpactBased.this.Ilabel[ImpactBased.this.currentVar][val - o];
                    if (impact < bestImpact) {
                        ImpactBased.this.bests.clear();
                        ImpactBased.this.bests.add(val);
                        bestImpact = impact;
                        continue;
                    }
                    if (impact != bestImpact) continue;
                    ImpactBased.this.bests.add(val);
                }
                it.dispose();
                ImpactBased.this.currentVal = ImpactBased.this.bests.get(ImpactBased.this.random.nextInt(ImpactBased.this.bests.size()));
            } else {
                int lb = var.getLB();
                int ub = var.getUB();
                ImpactBased.this.currentVal = ImpactBased.this.random.nextBoolean() ? lb : ub;
            }
            return ImpactBased.this.currentVal;
        }
    }
}

