/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.util.Arrays;
import org.openscience.cdk.depict.Dimensions;

class ReactionDimensions {
    Dimensions sideDim;
    Dimensions mainDim;
    Dimensions condDim;
    Dimensions titleDim;
    final double padding;
    final double scale;
    double[] xOffsets;
    double[] yOffsets;
    double[] xOffsetSide;
    double[] yOffsetSide;

    ReactionDimensions(Dimensions sideDim, Dimensions mainDim, Dimensions condDim, Dimensions titleDim, double scale, double padding) {
        this.sideDim = sideDim;
        this.mainDim = mainDim;
        this.condDim = condDim;
        this.titleDim = titleDim;
        this.scale = scale;
        this.padding = padding;
    }

    ReactionDimensions(Dimensions sideDim, Dimensions mainDim, Dimensions condDim, Dimensions titleDim, double padding) {
        this(sideDim, mainDim, condDim, titleDim, 1.0, padding);
    }

    private static double[] resize(double[] values, double ammount) {
        double[] cpy = Arrays.copyOf(values, values.length);
        int i = 0;
        while (i < values.length) {
            int n = i++;
            cpy[n] = cpy[n] * ammount;
        }
        return cpy;
    }

    ReactionDimensions resize(double amount) {
        Dimensions sideRequired = this.sideDim.scale(amount);
        Dimensions mainRequired = this.mainDim.scale(amount);
        Dimensions condRequired = this.condDim.scale(amount);
        Dimensions titleRequired = this.titleDim.scale(amount);
        ReactionDimensions result = new ReactionDimensions(sideRequired, mainRequired, condRequired, titleRequired, this.scale * amount, this.padding * amount);
        result.xOffsets = ReactionDimensions.resize(this.xOffsets, amount);
        result.yOffsets = ReactionDimensions.resize(this.yOffsets, amount);
        result.xOffsetSide = ReactionDimensions.resize(this.xOffsetSide, amount);
        result.yOffsetSide = ReactionDimensions.resize(this.yOffsetSide, amount);
        return result;
    }

    double mainRowHeight() {
        return this.yOffsets[1];
    }

    Dimensions calcTotalDimensions(String fmt) {
        double titleExtra;
        double firstRowHeight = this.yOffsets[1];
        int nSideCol = this.xOffsetSide.length - 1;
        int nSideRow = this.yOffsetSide.length - 1;
        double mainCompOffset = this.sideDim.h + this.padding + (double)(nSideRow - 1) * this.padding - firstRowHeight / 2.0;
        if (mainCompOffset < 0.0) {
            mainCompOffset = 0.0;
        }
        if ((titleExtra = Math.max(0.0, this.titleDim.h)) > 0.0) {
            titleExtra += this.padding;
        }
        int nCol = this.xOffsets.length - 1;
        int nRow = this.yOffsets.length - 1;
        double offsetWidth = this.xOffsets[this.xOffsets.length - 1];
        return new Dimensions(offsetWidth, this.mainDim.h).add((double)Math.max(0, nCol - 1) * this.padding, (double)(nRow - 1) * this.padding).add(0.0, mainCompOffset).add(0.0, titleExtra);
    }
}

