/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.formula.IsotopeContainer;

public class IsotopePattern {
    private final List<IsotopeContainer> isotopeCList = new ArrayList<IsotopeContainer>();
    private int monoIsotopePosition;
    private double chargI = 0.0;

    public void setMonoIsotope(IsotopeContainer isoContainer) {
        if (!this.isotopeCList.contains(isoContainer)) {
            this.isotopeCList.add(isoContainer);
        }
        this.monoIsotopePosition = this.isotopeCList.indexOf(isoContainer);
    }

    public void addIsotope(IsotopeContainer isoContainer) {
        this.isotopeCList.add(isoContainer);
    }

    public IsotopeContainer getMonoIsotope() {
        return this.isotopeCList.get(this.monoIsotopePosition);
    }

    public List<IsotopeContainer> getIsotopes() {
        return this.isotopeCList;
    }

    public IsotopeContainer getIsotope(int position) {
        return this.isotopeCList.get(position);
    }

    public int getNumberOfIsotopes() {
        return this.isotopeCList.size();
    }

    public void setCharge(double charge) {
        this.chargI = charge;
    }

    public double getCharge() {
        return this.chargI;
    }

    public Object clone() throws CloneNotSupportedException {
        IsotopePattern isoClone = new IsotopePattern();
        IsotopeContainer isoHighest = this.getMonoIsotope();
        for (IsotopeContainer isoContainer : this.isotopeCList) {
            if (isoHighest.equals(isoContainer)) {
                isoClone.setMonoIsotope((IsotopeContainer)isoContainer.clone());
                continue;
            }
            isoClone.addIsotope((IsotopeContainer)isoContainer.clone());
        }
        isoClone.setCharge(this.getCharge());
        return isoClone;
    }
}

