/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.quasinewton;

import opennlp.maxent.quasinewton.LogLikelihoodFunction;
import opennlp.model.AbstractModel;
import opennlp.model.Context;
import opennlp.model.EvalParameters;
import opennlp.model.UniformPrior;

public class QNModel
extends AbstractModel {
    private static final double SMOOTHING_VALUE = 0.1;
    private double[] parameters;

    public QNModel(LogLikelihoodFunction monitor, double[] parameters) {
        super(null, monitor.getPredLabels(), monitor.getOutcomeLabels());
        int[][] outcomePatterns = monitor.getOutcomePatterns();
        Context[] params = new Context[monitor.getPredLabels().length];
        for (int ci = 0; ci < params.length; ++ci) {
            int[] outcomePattern = outcomePatterns[ci];
            double[] alpha = new double[outcomePattern.length];
            for (int oi = 0; oi < outcomePattern.length; ++oi) {
                alpha[oi] = parameters[ci + outcomePattern[oi] * monitor.getPredLabels().length];
            }
            params[ci] = new Context(outcomePattern, alpha);
        }
        this.evalParams = new EvalParameters(params, monitor.getOutcomeLabels().length);
        this.prior = new UniformPrior();
        this.modelType = AbstractModel.ModelType.MaxentQn;
        this.parameters = parameters;
    }

    public QNModel(String[] predNames, String[] outcomeNames, Context[] params, double[] parameters) {
        super(params, predNames, outcomeNames);
        this.prior = new UniformPrior();
        this.modelType = AbstractModel.ModelType.MaxentQn;
        this.parameters = parameters;
    }

    public double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    private int getPredIndex(String predicate) {
        return this.pmap.get(predicate);
    }

    public double[] eval(String[] context, double[] probs) {
        return this.eval(context, null, probs);
    }

    public double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    private double[] eval(String[] context, float[] values, double[] probs) {
        int oi;
        double[] result = new double[this.outcomeNames.length];
        double[] table = new double[this.outcomeNames.length + 1];
        for (int pi = 0; pi < context.length; ++pi) {
            int predIdx = this.getPredIndex(context[pi]);
            for (int oi2 = 0; oi2 < this.outcomeNames.length; ++oi2) {
                int paraIdx = oi2 * this.pmap.size() + predIdx;
                double predValue = 1.0;
                if (values != null) {
                    predValue = values[pi];
                }
                if (paraIdx < 0) {
                    int n = oi2;
                    table[n] = table[n] + predValue * 0.1;
                    continue;
                }
                int n = oi2;
                table[n] = table[n] + predValue * this.parameters[paraIdx];
            }
        }
        for (oi = 0; oi < this.outcomeNames.length; ++oi) {
            table[oi] = Math.exp(table[oi]);
            int n = this.outcomeNames.length;
            table[n] = table[n] + table[oi];
        }
        for (oi = 0; oi < this.outcomeNames.length; ++oi) {
            result[oi] = table[oi] / table[this.outcomeNames.length];
        }
        return result;
    }

    public int getNumOutcomes() {
        return this.outcomeNames.length;
    }

    public double[] getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QNModel)) {
            return false;
        }
        QNModel objModel = (QNModel)obj;
        if (this.outcomeNames.length != objModel.outcomeNames.length) {
            return false;
        }
        for (int i = 0; i < this.outcomeNames.length; ++i) {
            if (this.outcomeNames[i].equals(objModel.outcomeNames[i])) continue;
            return false;
        }
        if (this.pmap.size() != objModel.pmap.size()) {
            return false;
        }
        String[] pmapArray = new String[this.pmap.size()];
        this.pmap.toArray(pmapArray);
        for (int i = 0; i < this.pmap.size(); ++i) {
            if (i == objModel.pmap.get(pmapArray[i])) continue;
            return false;
        }
        Context[] contextComparing = objModel.evalParams.getParams();
        if (this.evalParams.getParams().length != contextComparing.length) {
            return false;
        }
        for (int i = 0; i < this.evalParams.getParams().length; ++i) {
            if (this.evalParams.getParams()[i].getOutcomes().length != contextComparing[i].getOutcomes().length) {
                return false;
            }
            int j = 0;
            while (i < this.evalParams.getParams()[i].getOutcomes().length) {
                if (this.evalParams.getParams()[i].getOutcomes()[j] != contextComparing[i].getOutcomes()[j]) {
                    return false;
                }
                ++i;
            }
            if (this.evalParams.getParams()[i].getParameters().length != contextComparing[i].getParameters().length) {
                return false;
            }
            j = 0;
            while (i < this.evalParams.getParams()[i].getParameters().length) {
                if (this.evalParams.getParams()[i].getParameters()[j] != contextComparing[i].getParameters()[j]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

