/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data;

import java.io.IOException;
import java.nio.file.Path;
import org.corehunter.data.FrequencyGenotypeData;
import org.corehunter.data.simple.SimpleBiAllelicGenotypeData;
import org.corehunter.data.simple.SimpleDefaultGenotypeData;
import org.corehunter.data.simple.SimpleFrequencyGenotypeData;
import uno.informatics.data.io.FileType;

public enum GenotypeDataFormat {
    DEFAULT((file, type) -> SimpleDefaultGenotypeData.readData(file, type)),
    FREQUENCY((file, type) -> SimpleFrequencyGenotypeData.readData(file, type)),
    BIPARENTAL((file, type) -> SimpleBiAllelicGenotypeData.readData(file, type));

    private final GenotypeDataReader reader;

    private GenotypeDataFormat(GenotypeDataReader reader) {
        this.reader = reader;
    }

    public FrequencyGenotypeData readData(Path filePath, FileType fileType) throws IOException {
        return this.reader.readGenotypeData(filePath, fileType);
    }

    @FunctionalInterface
    private static interface GenotypeDataReader {
        public FrequencyGenotypeData readGenotypeData(Path var1, FileType var2) throws IOException;
    }
}

