# RobinCar 0.3.1

## Bugfixes

* When the following things happened simultaneously, the variance results were incorrect: (1) when the system locale was not set to "C", (2) the user did not specify their treatment variable as a factor, and (3) when inconsistent cases were used in naming treatment levels (e.g., "a", "B"). We have fixed this issue.

# RobinCar 0.3.0

## Features

* Changed the name description of RobinCar.

## Breaking Changes

* Simplified user experience for `robincar_glm`: removed `robincar_glm`,
and renamed `robincar_glm2` to `robincar_glm`. Same with `robincar_linear` and `robincar_linear2`. In effect,
the older versions of `robincar_linear` and `robincar_glm` have been deprecated.

## Bugfixes

* Previously, the factor level order passed by the user for the treatment variable was ignored. We have fixed this,
so all estimates will be presented in the order of treatment levels specified by user.

# RobinCar 0.2.0

## Features

* Added a `NEWS.md` file to track changes to the package.
* Added two new functions: `robincar_linear2` and `robincar_glm2`. These are wrappers for `robincar_linear` and `robincar_glm`, respectively, but they give the user more full control over their covariate adjustment settings. The differences are listed below:
  * The difference between `robincar_linear` and `robincar_linear2` is that in `robincar_linear2`, if you want to include strata variables as covariates in the working model, you need to add those strata variables to the `covariate_cols` as well as the `car_strata_cols`.
  * `robincar_glm2` is exactly `robincar_glm` but only with the `formula` working model functionality.

## Bugfixes

* Fixed two issues with the `formula` argument in `robincar_glm`. The first is if you had overlapping names for your treatment/response/covariate/strata variables (e.g., "A" for treatment col, and "A2" for covariate col), the formula would parse incorrectly. The second is if you used parentheses (e.g., "A*(x1+x2)"), the formula would also parse incorrectly. This would have given breaking errors to the user, and now the behavior is fixed.

# RobinCar 0.1.2

* Updated variance estimator for covariate-adjusted hazard ratio so that it uses the un-adjusted HR estimate rather than the adjusted HR estimate. Both result in consistent variance estimators but using un-adjusted theta is the expected behavior for the user.

# RobinCar 0.1.1

* Support for negative binomial glm (with known or unknown dispersion parameter)
* Beta version of SuperLearner working model
* Updated variance calculation that fixes negative variance when all/most outcome observations are 0

# RobinCar 0.1.0

*Initial Release*
