/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.LVQ;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.LVQ.LVQ1;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class LVQ2
extends LVQ1 {
    public final double DEFAULT_WINDOW_WIDTH = 0.2;
    protected double windowWidth = 0.2;
    protected double windowLowerBound = 0.2;

    public LVQ2(PrototypeSet traDataSet, int it, int nProt, double alpha_0, double windowWidth) {
        super(traDataSet, it, nProt, alpha_0);
        this.algorithmName = "LVQ2";
        this.windowWidth = windowWidth;
        this.windowLowerBound = (1.0 - windowWidth) / (1.0 + windowWidth);
    }

    public LVQ2(PrototypeSet InitialSet, PrototypeSet traDataSet, int it, int nProt, double alpha_0, double windowWidth) {
        super(InitialSet, traDataSet, it, nProt, alpha_0);
        this.algorithmName = "LVQ2";
        this.windowWidth = windowWidth;
        this.windowLowerBound = (1.0 - windowWidth) / (1.0 + windowWidth);
    }

    public LVQ2(PrototypeSet traDataSet, int it, double pcNProt, double alpha_0, double windowWidth) {
        super(traDataSet, it, pcNProt, alpha_0);
        this.algorithmName = "LVQ2";
        this.windowWidth = windowWidth;
        this.windowLowerBound = (1.0 - windowWidth) / (1.0 + windowWidth);
    }

    public LVQ2(PrototypeSet traDataSet, Parameters par) {
        super(traDataSet, par);
        this.algorithmName = "LVQ2";
        this.windowWidth = par.getNextAsDouble();
        this.windowLowerBound = (1.0 - this.windowWidth) / (1.0 + this.windowWidth);
    }

    boolean isInsideTheWindow(Prototype i, Prototype sameClass_i, Prototype differentClass_i) {
        double val2;
        if (i == null || sameClass_i == null || differentClass_i == null) {
            return false;
        }
        double val1 = Distance.d(i, differentClass_i) / Distance.d(i, sameClass_i);
        return Math.min(val1, val2 = 1.0 / val1) > this.windowLowerBound;
    }

    @Override
    protected void correct(Prototype i, PrototypeSet tData) {
        double class_i = i.getOutput(0);
        PrototypeSet nearests = KNN.knn(i, tData, 2);
        Prototype nearestSameClass = KNN.getNearestWithSameClassAs(i, tData);
        double nearestClass = ((Prototype)nearests.get(0)).label();
        if (this.isInsideTheWindow(i, (Prototype)nearests.get(0), (Prototype)nearests.get(1)) && class_i != nearestClass) {
            this.penalize((Prototype)nearests.get(0), i);
            if (nearestSameClass != null) {
                this.reward(nearestSameClass, i);
            }
        }
    }

    public static void main(String[] args) {
        Parameters.setUse("LVQ2", "<seed> <number of iterations> <% of prototypes> <alpha_0> <window width>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        int iter = Parameters.assertExtendedArgAsInt(args, 3, "number of iterations", 1.0, 2.147483647E9);
        double pcNprot = Parameters.assertExtendedArgAsDouble(args, 4, "reduction size respect training size", 0.0, 100.0);
        double alpha_0 = Parameters.assertExtendedArgAsDouble(args, 5, "alpha_0", 0.0, 1.0);
        double window_width = Parameters.assertExtendedArgAsDouble(args, 6, "window width", 0.0, 1.0);
        LVQ2.setSeed(seed);
        LVQ2 generator = new LVQ2(training, iter, pcNprot, alpha_0, window_width);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

