/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.VQ;

import java.util.ArrayList;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.VQ.Cluster;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class AVQGenerator
extends PrototypeGenerator {
    protected PrototypeSet T = null;
    protected PrototypeSet V = null;
    protected PrototypeSet reduced = null;
    protected double percentageInitPartition = 80.0;
    double epsilonLBG = 0.4;
    protected int numberOfIterations = 1000;

    public AVQGenerator(PrototypeSet tDataSet, Parameters parameters) {
        super(tDataSet, parameters);
        this.algorithmName = "AVQ";
        this.percentageInitPartition = parameters.getNextAsDouble();
        this.numberOfIterations = parameters.getNextAsInt();
        this.epsilonLBG = parameters.getNextAsDouble();
    }

    public AVQGenerator(PrototypeSet tDataSet, double percentPart, int numIterations, double epsilonLBG) {
        super(tDataSet);
        this.algorithmName = "AVQ";
        this.percentageInitPartition = percentPart;
        this.numberOfIterations = numIterations;
        this.epsilonLBG = epsilonLBG;
    }

    protected static int countPrototypesWhichNearestIs(Prototype center, PrototypeSet set) {
        int count = 0;
        for (Prototype p : set) {
            Prototype nearest;
            double dNearest;
            double dCenter = Distance.d(p, center);
            if (!(dCenter <= (dNearest = Distance.d(p, nearest = set.nearestTo(p))))) continue;
            ++count;
        }
        return count;
    }

    protected int R(Cluster c) {
        PrototypeSet setC = c.getPrototypeSet();
        int count = 0;
        for (Prototype p : setC) {
            if (!c.isCentroidItsNearestPrototoype(p)) continue;
            ++count;
        }
        return count;
    }

    protected int Q(PrototypeSet reduced, Prototype center) {
        int count = 0;
        PrototypeSet Tc = this.T;
        for (Prototype p : Tc) {
            Prototype nearest = reduced.nearestTo(p);
            double dNearest = Distance.d(p, nearest);
            double dCenter = Distance.d(p, center);
            if (!(dCenter < dNearest)) continue;
            ++count;
        }
        return count;
    }

    protected int incorrectlyClassifiedSamples(Cluster c) {
        return this.R(c) - this.Q(this.reduced, c.center());
    }

    @Override
    public PrototypeSet reduceSet() {
        boolean forcedEnd = false;
        ArrayList<Double> classes = Prototype.possibleValuesOfOutput();
        this.reduced = new PrototypeSet(classes.size());
        Pair<PrototypeSet, PrototypeSet> parted = this.trainingDataSet.makePartition(this.percentageInitPartition);
        this.T = parted.first();
        this.V = parted.second();
        ArrayList<PrototypeSet> classPartition = this.T.classPartition();
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(classPartition.size());
        for (PrototypeSet ps : classPartition) {
            Prototype center_ps = ps.avg();
            this.reduced.add(center_ps);
            clusters.add(new Cluster(center_ps, ps));
        }
        boolean end = false;
        int it = 0;
        boolean i = false;
        double errAnt = Double.NEGATIVE_INFINITY;
        while (!end) {
            int Emax = Integer.MIN_VALUE;
            Cluster Cmax = null;
            for (Cluster c : clusters) {
                int Ec = this.incorrectlyClassifiedSamples(c);
                if (Emax >= Ec) continue;
                Emax = Ec;
                Cmax = c;
            }
            this.reduced.remove(Cmax.center());
            int Cmax_size = Cmax.size();
            if (Cmax_size > 2) {
                Pair<Prototype, Prototype> newCenters = Cmax.centersOfLBGCLuster(this.epsilonLBG);
                Prototype newCenter1 = newCenters.first();
                Prototype newCenter2 = newCenters.second();
                this.reduced.uniqueAdd(newCenter1);
                this.reduced.uniqueAdd(newCenter2);
            } else if (Cmax_size == 2) {
                this.reduced.uniqueAdd(Prototype.avg(Cmax.get(0), Cmax.get(1)));
            } else {
                this.reduced.uniqueAdd(Cmax.get(0));
                forcedEnd = true;
            }
            int err = AVQGenerator.absoluteAccuracyAndError(this.reduced, this.V).second();
            if ((double)err >= errAnt) {
                ++it;
            } else {
                it = 0;
                errAnt = err;
            }
            end = it >= this.numberOfIterations || forcedEnd;
        }
        return this.reduced;
    }

    public static void main(String[] args) {
        Parameters.setUse("AVQ", "<seed> <number of prototypes>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        double percentPart = Parameters.assertExtendedArgAsDouble(args, 3, "percentage of partition", 0.0, 100.0);
        int n = Parameters.assertExtendedArgAsInt(args, 4, "number of iterations", 1.0, 2.147483647E9);
        double eLBG = Parameters.assertExtendedArgAsDouble(args, 5, "epsilon of the LBG partition algorithm", 0.0, 1.0);
        AVQGenerator.setSeed(seed);
        AVQGenerator generator = new AVQGenerator(training, percentPart, n, eLBG);
        PrototypeSet resultingSet = generator.execute();
        resultingSet.save("resultados_avq.txt");
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

