/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import keel.Algorithms.Decision_Trees.M5.M5;

public final class M5Matrix {
    double[][] elements;

    public M5Matrix(int nr, int nc) {
        this.elements = new double[nr][nc];
    }

    public final String toString(int nrl, int nrh, int ncl, int nch) {
        StringBuffer text = new StringBuffer();
        text.append("Printing matrix[" + nrl + ":" + nrh + "][" + ncl + ":" + nch + "]:\n");
        for (int i = nrl; i <= nrh; ++i) {
            for (int j = ncl; j <= nch; ++j) {
                text.append("\t" + M5.doubleToStringG(this.elements[i][j], 5, 3));
            }
            text.append("\n");
        }
        return text.toString();
    }

    public final M5Matrix transpose(int n, int m) {
        M5Matrix b = new M5Matrix(m, n);
        for (int i = 0; i <= m - 1; ++i) {
            for (int j = 0; j <= n - 1; ++j) {
                b.elements[i][j] = this.elements[j][i];
            }
        }
        return b;
    }

    public final M5Matrix multiply(M5Matrix b, int l, int m, int n) {
        M5Matrix c = new M5Matrix(l, n);
        for (int i = 0; i <= l - 1; ++i) {
            for (int j = 0; j <= n - 1; ++j) {
                for (int k = 0; k <= m - 1; ++k) {
                    double[] dArray = c.elements[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + this.elements[i][k] * b.elements[k][j];
                }
            }
        }
        return c;
    }

    public final double[] regression(M5Matrix y, int n, int m) {
        M5Matrix xt = this.transpose(n, m);
        M5Matrix ss = xt.multiply(this, m, n, m);
        M5Matrix bb = xt.multiply(y, m, n, 1);
        double[] b = new double[m];
        for (int i = 0; i <= m - 1; ++i) {
            b[i] = bb.elements[i][0];
        }
        int[] indx = new int[m];
        ss.ludcmp(m, indx);
        ss.lubksb(m, indx, b);
        return b;
    }

    public final void lubksb(int n, int[] indx, double[] b) {
        int j;
        double sum;
        int i;
        int ii = -1;
        for (i = 0; i <= n - 1; ++i) {
            int ip = indx[i];
            sum = b[ip];
            b[ip] = b[i];
            if (ii != -1) {
                for (j = ii; j <= i - 1; ++j) {
                    sum -= this.elements[i][j] * b[j];
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i] = sum;
        }
        for (i = n - 1; i >= 0; --i) {
            sum = b[i];
            for (j = i + 1; j <= n - 1; ++j) {
                sum -= this.elements[i][j] * b[j];
            }
            b[i] = sum / this.elements[i][i];
        }
    }

    public final int[] ludcmp(int n, int[] indx) {
        int j;
        double big;
        int i;
        int imax = -1;
        double TINY = 1.0E-20;
        int[] singulars = new int[n];
        for (i = 0; i <= n - 1; ++i) {
            singulars[i] = 0;
        }
        double[] vv = new double[n];
        for (i = 0; i <= n - 1; ++i) {
            big = 0.0;
            for (j = 0; j <= n - 1; ++j) {
                double d;
                double temp = Math.abs(this.elements[i][j]);
                if (!(d > big)) continue;
                big = temp;
            }
            if (big < 1.0E-9) {
                this.elements[i][i] = 1.0;
                big = 1.0;
                singulars[i] = 1;
            }
            vv[i] = 1.0 / big;
        }
        for (j = 0; j <= n - 1; ++j) {
            double dum;
            int k;
            double sum;
            for (i = 0; i < j; ++i) {
                sum = this.elements[i][j];
                for (k = 0; k < i; ++k) {
                    sum -= this.elements[i][k] * this.elements[k][j];
                }
                this.elements[i][j] = sum;
            }
            big = 0.0;
            for (i = j; i <= n - 1; ++i) {
                double d;
                sum = this.elements[i][j];
                for (k = 0; k < j; ++k) {
                    sum -= this.elements[i][k] * this.elements[k][j];
                }
                this.elements[i][j] = sum;
                dum = vv[i] * Math.abs(sum);
                if (!(d >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (k = 0; k <= n - 1; ++k) {
                    dum = this.elements[imax][k];
                    this.elements[imax][k] = this.elements[j][k];
                    this.elements[j][k] = dum;
                }
                vv[imax] = vv[j];
            }
            indx[j] = imax;
            if (this.elements[j][j] == 0.0) {
                this.elements[j][j] = TINY;
            }
            if (j == n - 1) continue;
            dum = 1.0 / this.elements[j][j];
            for (i = j + 1; i <= n - 1; ++i) {
                double[] dArray = this.elements[i];
                int n2 = j;
                dArray[n2] = dArray[n2] * dum;
            }
        }
        return singulars;
    }
}

