/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.dstats;

import ec.tstoolkit.dstats.BoundaryType;
import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.dstats.IContinuousDistribution;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.ProbInvFinder;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.dstats.SpecialFunctions;
import ec.tstoolkit.dstats.Utility;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.StochasticRandomizer;

public class T
implements IContinuousDistribution {
    static final double[][] coeff = new double[][]{{1.0, 1.0, 0.0, 0.0, 0.0}, {3.0, 16.0, 5.0, 0.0, 0.0}, {-15.0, 17.0, 19.0, 3.0, 0.0}, {-945.0, -1920.0, 1482.0, 776.0, 79.0}};
    static final double[] denom = new double[]{4.0, 96.0, 384.0, 92160.0};
    static final int[] ideg = new int[]{2, 3, 4, 5};
    private int m_df = 2;

    static double calcInitT(double p, double df) {
        Normal nl = new Normal();
        double x = nl.getProbabilityInverse(p, ProbabilityType.Lower);
        double xx = x * x;
        double sum = x;
        double denpow = 1.0;
        for (int i = 0; i < 4; ++i) {
            double term = Utility.calcPoly(coeff[i], ideg[i], xx) * x;
            sum += term / ((denpow *= df) * denom[i]);
        }
        return sum;
    }

    public int getDegreesofFreedom() {
        return this.m_df;
    }

    @Override
    public double getDensity(double x) {
        return SpecialFunctions.studentDensity(x, this.m_df);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("T with ");
        sb.append(this.m_df);
        sb.append(" degrees of freedom");
        return sb.toString();
    }

    @Override
    public double getExpectation() {
        return 0.0;
    }

    @Override
    public double getLeftBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getProbability(double x, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return 0.0;
        }
        if (x == 0.0) {
            return 0.5;
        }
        double res = SpecialFunctions.studentProbability(x, this.m_df);
        if (pt == ProbabilityType.Upper) {
            res = 1.0 - res;
        }
        return res;
    }

    @Override
    public double getProbabilityInverse(double p, ProbabilityType pt) {
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        if (p < 1.0E-15 || 1.0 - p < 1.0E-15) {
            throw new DStatException("Can't compute probability inverse (value is too near 0 or 1)");
        }
        if (Math.abs(p - 0.5) < 1.0E-15) {
            return 0.0;
        }
        double start = T.calcInitT(p, this.m_df);
        return ProbInvFinder.find(p, start, 1.0E-15, 1.0E-9, this);
    }

    @Override
    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVariance() {
        if (this.m_df < 2) {
            throw new DStatException("No valid variance defined for df < 2", "T");
        }
        return (double)this.m_df / ((double)this.m_df - 2.0);
    }

    @Override
    public BoundaryType hasLeftBound() {
        return BoundaryType.None;
    }

    @Override
    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    @Override
    public boolean isSymmetrical() {
        return true;
    }

    @Override
    public double random(IRandomNumberGenerator rng) {
        return StochasticRandomizer.T(rng, this.m_df);
    }

    public void setDegreesofFreedom(int df) {
        if (df <= 0) {
            throw new DStatException("Degrees of freedom for TStudent must be strictly positive", "T");
        }
        this.m_df = df;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("T(");
        sb.append(this.m_df);
        sb.append(')');
        return sb.toString();
    }
}

