/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;

    public SparseFComplexMatrix1D(float[] fArray) {
        this(fArray.length);
        this.assign(fArray);
    }

    public SparseFComplexMatrix1D(int n) {
        this.setUp(n);
        this.elements = new ConcurrentHashMap(n / 1000);
    }

    protected SparseFComplexMatrix1D(int n, ConcurrentHashMap<Long, float[]> concurrentHashMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public FComplexMatrix1D assign(float[] fArray) {
        if (this.isNoView && fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(fArray);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public synchronized float[] getQuick(int n) {
        float[] fArray = this.elements.get((long)this.zero + (long)n * (long)this.stride);
        if (fArray != null) {
            return new float[]{fArray[0], fArray[1]};
        }
        return new float[2];
    }

    @Override
    public ConcurrentHashMap<Long, float[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D instanceof SelectedSparseFComplexMatrix1D) {
            SelectedSparseFComplexMatrix1D selectedSparseFComplexMatrix1D = (SelectedSparseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == selectedSparseFComplexMatrix1D.elements;
        }
        if (fComplexMatrix1D instanceof SparseFComplexMatrix1D) {
            SparseFComplexMatrix1D sparseFComplexMatrix1D = (SparseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == sparseFComplexMatrix1D.elements;
        }
        return false;
    }

    @Override
    public long index(int n) {
        return (long)this.zero + (long)n * (long)this.stride;
    }

    @Override
    public FComplexMatrix1D like(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    @Override
    public FComplexMatrix2D like2D(int n, int n2) {
        return new SparseFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        final SparseFComplexMatrix2D sparseFComplexMatrix2D = new SparseFComplexMatrix2D(n, n2);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n5; i < n6; ++i) {
                            int n2 = i * n;
                            for (int j = 0; j < n; ++j) {
                                float[] fArray;
                                if ((fArray = SparseFComplexMatrix1D.this.getQuick(n2++))[0] == 0.0f && fArray[1] == 0.0f) continue;
                                sparseFComplexMatrix2D.setQuick(j, i, fArray);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    float[] fArray;
                    if ((fArray = this.getQuick(n7++))[0] == 0.0f && fArray[1] == 0.0f) continue;
                    ((FComplexMatrix2D)sparseFComplexMatrix2D).setQuick(j, i, fArray);
                }
            }
        }
        return sparseFComplexMatrix2D;
    }

    @Override
    public FComplexMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        final SparseFComplexMatrix3D sparseFComplexMatrix3D = new SparseFComplexMatrix3D(n, n2, n3);
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n4 = Math.min(n4, this.size);
            Future[] futureArray = new Future[n4];
            int n5 = n / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = i * n2 * n3 + j * n2;
                                for (int k = 0; k < n2; ++k) {
                                    float[] fArray;
                                    if ((fArray = SparseFComplexMatrix1D.this.getQuick(n++))[0] == 0.0f && fArray[1] == 0.0f) continue;
                                    sparseFComplexMatrix3D.setQuick(i, k, j, fArray);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n8 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        float[] fArray;
                        if ((fArray = this.getQuick(n8++))[0] == 0.0f && fArray[1] == 0.0f) continue;
                        ((FComplexMatrix3D)sparseFComplexMatrix3D).setQuick(i, k, j, fArray);
                    }
                }
            }
        }
        return sparseFComplexMatrix3D;
    }

    @Override
    public synchronized void setQuick(int n, float[] fArray) {
        long l = (long)this.zero + (long)n * (long)this.stride;
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, fArray);
        }
    }

    @Override
    public synchronized void setQuick(int n, float f, float f2) {
        long l = (long)this.zero + (long)n * (long)this.stride;
        if (f == 0.0f && f2 == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new float[]{f, f2});
        }
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseFComplexMatrix1D(this.elements, nArray);
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        final SparseFloatMatrix1D sparseFloatMatrix1D = new SparseFloatMatrix1D(this.size);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            sparseFloatMatrix1D.setQuick(i, SparseFComplexMatrix1D.this.getQuick(i)[1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                ((FloatMatrix1D)sparseFloatMatrix1D).setQuick(i, this.getQuick(i)[1]);
            }
        }
        return sparseFloatMatrix1D;
    }

    @Override
    public FloatMatrix1D getRealPart() {
        final SparseFloatMatrix1D sparseFloatMatrix1D = new SparseFloatMatrix1D(this.size);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            sparseFloatMatrix1D.setQuick(i, SparseFComplexMatrix1D.this.getQuick(i)[0]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                ((FloatMatrix1D)sparseFloatMatrix1D).setQuick(i, this.getQuick(i)[0]);
            }
        }
        return sparseFloatMatrix1D;
    }
}

