/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangDenseMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UpperTriangDenseMatrix
extends AbstractTriangDenseMatrix {
    public UpperTriangDenseMatrix(int n) {
        super(n, BLASkernel.UpLo.Upper, BLASkernel.Diag.NonUnit);
    }

    UpperTriangDenseMatrix(int n, BLASkernel.Diag diag) {
        super(n, BLASkernel.UpLo.Upper, diag);
    }

    public UpperTriangDenseMatrix(Matrix A) {
        this(A, Math.min(A.numRows(), A.numColumns()));
    }

    public UpperTriangDenseMatrix(Matrix A, boolean deep) {
        this(A, Math.min(A.numRows(), A.numColumns()), deep);
    }

    UpperTriangDenseMatrix(Matrix A, boolean deep, BLASkernel.Diag diag) {
        this(A, Math.min(A.numRows(), A.numColumns()), deep, diag);
    }

    public UpperTriangDenseMatrix(Matrix A, int k) {
        this(A, k, true);
    }

    public UpperTriangDenseMatrix(Matrix A, int k, boolean deep) {
        super(A, k, deep, BLASkernel.UpLo.Upper, BLASkernel.Diag.NonUnit);
    }

    UpperTriangDenseMatrix(Matrix A, int k, boolean deep, BLASkernel.Diag diag) {
        super(A, k, deep, BLASkernel.UpLo.Upper, diag);
    }

    public void add(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        super.add(row, column, value);
    }

    public double get(int row, int column) {
        if (row > column) {
            return 0.0;
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        super.set(row, column, value);
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() > e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    public UpperTriangDenseMatrix copy() {
        return new UpperTriangDenseMatrix(this);
    }
}

