/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SimpleOperatorSchedule
implements OperatorSchedule,
Loggable {
    private final List<MCMCOperator> operators = new ArrayList<MCMCOperator>();
    private final List<Integer> availableOperators = new ArrayList<Integer>();
    private double totalWeight = 0.0;
    private int current = 0;
    private boolean sequential = false;
    private OperatorSchedule.OptimizationTransform optimizationTransform = DEFAULT_TRANSFORM;
    int operatorUseThreshold = Integer.MAX_VALUE;
    double operatorAcceptanceThreshold = 0.0;

    public SimpleOperatorSchedule() {
    }

    public SimpleOperatorSchedule(int n, double d) {
        this.operatorUseThreshold = n;
        this.operatorAcceptanceThreshold = d;
    }

    @Override
    public void addOperators(List<MCMCOperator> list) {
        for (MCMCOperator mCMCOperator : list) {
            this.operators.add(mCMCOperator);
            this.availableOperators.add(this.operators.size() - 1);
        }
        this.totalWeight = this.calculateTotalWeight();
    }

    @Override
    public void operatorsHasBeenUpdated() {
        this.totalWeight = this.calculateTotalWeight();
    }

    @Override
    public void addOperator(MCMCOperator mCMCOperator) {
        this.operators.add(mCMCOperator);
        this.availableOperators.add(this.operators.size() - 1);
        this.totalWeight = this.calculateTotalWeight();
    }

    private double getWeight(int n) {
        return this.operators.get(this.availableOperators.get(n)).getWeight();
    }

    private double calculateTotalWeight() {
        double d = 0.0;
        for (int n : this.availableOperators) {
            d += this.operators.get(n).getWeight();
        }
        return d;
    }

    @Override
    public int getNextOperatorIndex() {
        if (this.operatorAcceptanceThreshold > 0.0) {
            this.checkOperatorAcceptanceRates();
        }
        if (this.sequential) {
            int n = this.getWeightedOperatorIndex(this.current);
            ++this.current;
            if ((double)this.current >= this.totalWeight) {
                this.current = 0;
            }
            return n;
        }
        double d = MathUtils.nextDouble();
        return this.getWeightedOperatorIndex(d * this.totalWeight);
    }

    public void setSequential(boolean bl) {
        this.sequential = bl;
    }

    private int getWeightedOperatorIndex(double d) {
        int n = 0;
        for (double d2 = this.getWeight(n); d2 <= d; d2 += this.getWeight(++n)) {
        }
        return n;
    }

    @Override
    public MCMCOperator getOperator(int n) {
        return this.operators.get(this.availableOperators.get(n));
    }

    @Override
    public int getOperatorCount() {
        return this.availableOperators.size();
    }

    private void checkOperatorAcceptanceRates() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : this.availableOperators) {
            double d;
            MCMCOperator mCMCOperator = this.operators.get(n);
            if (mCMCOperator instanceof AdaptableMCMCOperator || mCMCOperator.getCount() <= (long)this.operatorUseThreshold || !((d = (double)mCMCOperator.getAcceptCount() / (double)mCMCOperator.getCount()) < this.operatorAcceptanceThreshold)) continue;
            arrayList.add(n);
            Logger.getLogger("dr.app.beast").info("Operator " + mCMCOperator.getOperatorName() + " turned off with an acceptance rate of " + d + ", after " + mCMCOperator.getCount() + " tries.");
        }
        if (!arrayList.isEmpty()) {
            this.availableOperators.removeAll(arrayList);
            this.totalWeight = this.calculateTotalWeight();
        }
    }

    @Override
    public OperatorSchedule.OptimizationTransform getOptimizationTransform() {
        return this.optimizationTransform;
    }

    public void setOptimizationTransform(OperatorSchedule.OptimizationTransform optimizationTransform) {
        this.optimizationTransform = optimizationTransform;
    }

    @Override
    public long getMinimumAcceptAndRejectCount() {
        long l = Long.MAX_VALUE;
        for (MCMCOperator mCMCOperator : this.operators) {
            if (mCMCOperator.getAcceptCount() >= l && mCMCOperator.getRejectCount() >= l) continue;
            l = mCMCOperator.getCount();
        }
        return l;
    }

    @Override
    public LogColumn[] getColumns() {
        ArrayList<NumberColumn> arrayList = new ArrayList<NumberColumn>();
        for (int i = 0; i < this.getOperatorCount(); ++i) {
            MCMCOperator mCMCOperator = this.getOperator(i);
            arrayList.add(new OperatorAcceptanceColumn(mCMCOperator.getOperatorName(), mCMCOperator));
            arrayList.add(new OperatorTimeColumn(mCMCOperator.getOperatorName() + "_time", mCMCOperator));
            arrayList.add(new OperatorCalculationColumn(mCMCOperator.getOperatorName() + "_calcs", mCMCOperator));
            if (!(mCMCOperator instanceof AdaptableMCMCOperator)) continue;
            arrayList.add(new OperatorSizeColumn(mCMCOperator.getOperatorName() + "_size", (AdaptableMCMCOperator)mCMCOperator));
        }
        LogColumn[] logColumnArray = arrayList.toArray(new LogColumn[arrayList.size()]);
        return logColumnArray;
    }

    private class OperatorCalculationColumn
    extends NumberColumn {
        private final MCMCOperator op;

        public OperatorCalculationColumn(String string, MCMCOperator mCMCOperator) {
            super(string);
            this.op = mCMCOperator;
        }

        @Override
        public double getDoubleValue() {
            return this.op.getTotalCalculationCount();
        }
    }

    private class OperatorTimeColumn
    extends NumberColumn {
        private final MCMCOperator op;

        public OperatorTimeColumn(String string, MCMCOperator mCMCOperator) {
            super(string);
            this.op = mCMCOperator;
        }

        @Override
        public double getDoubleValue() {
            return this.op.getTotalEvaluationTime();
        }
    }

    private class OperatorSizeColumn
    extends NumberColumn {
        private final AdaptableMCMCOperator op;

        public OperatorSizeColumn(String string, AdaptableMCMCOperator adaptableMCMCOperator) {
            super(string);
            this.op = adaptableMCMCOperator;
        }

        @Override
        public double getDoubleValue() {
            return this.op.getRawParameter();
        }
    }

    private class OperatorAcceptanceColumn
    extends NumberColumn {
        private final MCMCOperator op;

        public OperatorAcceptanceColumn(String string, MCMCOperator mCMCOperator) {
            super(string);
            this.op = mCMCOperator;
        }

        @Override
        public double getDoubleValue() {
            return this.op.getAcceptanceProbability();
        }
    }
}

