/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous.cdi;

import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.evomodel.treedatalikelihood.continuous.cdi.SafeMultivariateDiagonalActualizedWithDriftIntegrator;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class SafeMultivariateActualizedWithDriftIntegrator
extends SafeMultivariateDiagonalActualizedWithDriftIntegrator {
    private static boolean DEBUG = false;
    private static final boolean TIMING = false;
    private double[] actualizations;
    private DenseMatrix64F matrixQdiPip;
    private DenseMatrix64F matrixQdjPjp;
    private DenseMatrix64F matrixNiacc;
    private final boolean isActualizationSymmetric;

    public SafeMultivariateActualizedWithDriftIntegrator(PrecisionType precisionType, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(precisionType, n, n2, n3, n4, n5);
        this.allocateStorage();
        this.isActualizationSymmetric = bl;
        System.err.println("Trying SafeMultivariateActualizedWithDriftIntegrator");
    }

    @Override
    public void getBranchActualization(int n, double[] dArray) {
        if (n == -1) {
            throw new RuntimeException("Not yet implemented");
        }
        assert (dArray != null);
        assert (dArray.length >= this.dimTrait * this.dimTrait);
        System.arraycopy(this.actualizations, n * this.dimTrait * this.dimTrait, dArray, 0, this.dimTrait * this.dimTrait);
    }

    @Override
    public void getBranch1mActualization(int n, double[] dArray) {
        this.getBranchActualization(n, dArray);
        for (int i = 0; i < this.dimTrait; ++i) {
            for (int j = 0; j < this.dimTrait; ++j) {
                dArray[i * this.dimTrait + j] = -dArray[i * this.dimTrait + j];
            }
            dArray[i * this.dimTrait + i] = 1.0 + dArray[i * this.dimTrait + i];
        }
    }

    @Override
    public void getBranchExpectation(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        assert (dArray4 != null);
        assert (dArray4.length >= this.dimTrait);
        assert (dArray != null);
        assert (dArray.length >= this.dimTrait * this.dimTrait);
        assert (dArray2 != null);
        assert (dArray2.length >= this.dimTrait);
        assert (dArray3 != null);
        assert (dArray3.length >= this.dimTrait);
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.dimTrait, 1);
        CommonOps.mult(MissingOps.wrap(dArray, 0, this.dimTrait, this.dimTrait), MissingOps.wrap(dArray2, 0, this.dimTrait, 1), denseMatrix64F);
        CommonOps.addEquals(denseMatrix64F, MissingOps.wrap(dArray3, 0, this.dimTrait, 1));
        MissingOps.unwrap(denseMatrix64F, dArray4, 0);
    }

    private void allocateStorage() {
        this.actualizations = new double[this.dimTrait * this.dimTrait * this.bufferCount];
        this.matrixQdiPip = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        this.matrixQdjPjp = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        this.matrixNiacc = new DenseMatrix64F(this.dimTrait, 1);
    }

    @Override
    public void setDiffusionStationaryVariance(int n, double[] dArray, double[] dArray2) {
        int n2 = dArray.length;
        assert (dArray2.length == n2 * n2);
        super.setDiffusionStationaryVariance(n, dArray, dArray2);
        int n3 = this.dimProcess * this.dimProcess * n;
        this.transformMatrixBack(this.stationaryVariances, n3, dArray2, 0);
        if (DEBUG) {
            System.err.println("At precision index: " + n);
            System.err.println("stationary variance: " + MissingOps.wrap(this.stationaryVariances, n3, n2, n2));
        }
    }

    @Override
    void setStationaryVariance(int n, double[] dArray, int n2, double[] dArray2) {
        assert (dArray2.length == n2);
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(dArray2, 0, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(this.inverseDiffusions, n, this.dimProcess, this.dimProcess);
        SafeMultivariateActualizedWithDriftIntegrator.transformMatrix(denseMatrix64F2, denseMatrix64F, this.isActualizationSymmetric);
        double[] dArray3 = new double[n2];
        MissingOps.unwrap(denseMatrix64F2, dArray3, 0);
        SafeMultivariateActualizedWithDriftIntegrator.scaleInv(dArray3, 0, dArray, this.stationaryVariances, n, n2);
    }

    public static void transformMatrix(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, Boolean bl) {
        if (bl.booleanValue()) {
            SafeMultivariateActualizedWithDriftIntegrator.transformMatrixSymmetric(denseMatrix64F, denseMatrix64F2);
        } else {
            SafeMultivariateActualizedWithDriftIntegrator.transformMatrixGeneral(denseMatrix64F, denseMatrix64F2);
        }
    }

    private static void transformMatrixGeneral(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        int n = denseMatrix64F.getNumRows();
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n, n);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(n, n);
        CommonOps.invert(denseMatrix64F2, denseMatrix64F4);
        CommonOps.mult(denseMatrix64F4, denseMatrix64F, denseMatrix64F3);
        CommonOps.multTransB(denseMatrix64F3, denseMatrix64F4, denseMatrix64F);
    }

    private static void transformMatrixSymmetric(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        int n = denseMatrix64F.getNumRows();
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n, n);
        CommonOps.multTransA(denseMatrix64F2, denseMatrix64F, denseMatrix64F3);
        CommonOps.mult(denseMatrix64F3, denseMatrix64F2, denseMatrix64F);
    }

    private void transformMatrixBack(double[] dArray, int n, double[] dArray2, int n2) {
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(dArray, n, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(dArray2, n2, this.dimProcess, this.dimProcess);
        SafeMultivariateActualizedWithDriftIntegrator.transformMatrixBack(denseMatrix64F, denseMatrix64F2);
        MissingOps.unwrap(denseMatrix64F, dArray, n);
    }

    public static void transformMatrixBack(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        int n = denseMatrix64F.getNumRows();
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n, n);
        CommonOps.multTransB(denseMatrix64F, denseMatrix64F2, denseMatrix64F3);
        CommonOps.mult(denseMatrix64F2, denseMatrix64F3, denseMatrix64F);
    }

    private void transformDiagonalMatrixBack(double[] dArray, double[] dArray2, int n, double[] dArray3, int n2) {
        DenseMatrix64F denseMatrix64F = MissingOps.wrapDiagonal(dArray, n, this.dimProcess);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(dArray3, n2, this.dimProcess, this.dimProcess);
        this.transformMatrixBase(denseMatrix64F, denseMatrix64F2);
        MissingOps.unwrap(denseMatrix64F, dArray2, n);
    }

    private DenseMatrix64F getInverseSelectionStrength(double[] dArray, double[] dArray2) {
        DenseMatrix64F denseMatrix64F = MissingOps.wrapDiagonalInverse(dArray, 0, this.dimProcess);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(dArray2, 0, this.dimProcess, this.dimProcess);
        this.transformMatrixBase(denseMatrix64F, denseMatrix64F2);
        return denseMatrix64F;
    }

    private void transformMatrixBase(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (this.isActualizationSymmetric) {
            SafeMultivariateActualizedWithDriftIntegrator.transformMatrixBack(denseMatrix64F, denseMatrix64F2);
        } else {
            this.transformMatrixBaseGeneral(denseMatrix64F, denseMatrix64F2);
        }
    }

    private void transformMatrixBaseGeneral(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(denseMatrix64F2, denseMatrix64F, denseMatrix64F3);
        CommonOps.invert(denseMatrix64F2);
        CommonOps.mult(denseMatrix64F3, denseMatrix64F2, denseMatrix64F);
    }

    @Override
    void computeOUActualization(double[] dArray, double[] dArray2, double d, int n, int n2) {
        double[] dArray3 = new double[this.dimTrait];
        SafeMultivariateActualizedWithDriftIntegrator.computeOUDiagonal1mActualization(dArray, d, this.dimProcess, dArray3, 0);
        SafeMultivariateActualizedWithDriftIntegrator.oneMinus(dArray3);
        this.transformDiagonalMatrixBack(dArray3, this.actualizations, n2, dArray2, 0);
    }

    @Override
    void computeOUVarianceBranch(int n, int n2, int n3, double d) {
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(this.actualizations, n2, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(this.stationaryVariances, n, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.multTransB(denseMatrix64F2, denseMatrix64F, denseMatrix64F3);
        CommonOps.multAdd(-1.0, denseMatrix64F, denseMatrix64F3, denseMatrix64F2);
        MissingOps.unwrap(denseMatrix64F2, this.variances, n2);
    }

    @Override
    void computeOUActualizedDisplacement(double[] dArray, int n, int n2, int n3) {
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(this.actualizations, n2, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(dArray, n, this.dimProcess, 1);
        DenseMatrix64F denseMatrix64F3 = CommonOps.identity(this.dimProcess);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dimProcess, 1);
        CommonOps.addEquals(denseMatrix64F3, -1.0, denseMatrix64F);
        CommonOps.mult(denseMatrix64F3, denseMatrix64F2, denseMatrix64F4);
        MissingOps.unwrap(denseMatrix64F4, this.displacements, n3);
    }

    private void computeIOUActualizedDisplacement(double[] dArray, int n, int n2, double d, DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(this.displacements, n2, this.dimProcess, 1);
        DenseMatrix64F denseMatrix64F3 = MissingOps.wrap(dArray, n, this.dimProcess, 1);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dimProcess, 1);
        CommonOps.mult(denseMatrix64F, denseMatrix64F2, denseMatrix64F4);
        CommonOps.scale(-1.0, denseMatrix64F4);
        CommonOps.addEquals(denseMatrix64F4, d, denseMatrix64F3);
        MissingOps.unwrap(denseMatrix64F4, this.displacements, n2 + this.dimProcess);
    }

    private void computeIOUVarianceBranch(int n, int n2, double d, DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(this.actualizations, n2, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F3 = MissingOps.wrap(this.stationaryVariances, n, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(denseMatrix64F, denseMatrix64F3, denseMatrix64F4);
        DenseMatrix64F denseMatrix64F5 = MissingOps.wrap(this.variances, n2, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F6 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.multTransB(denseMatrix64F4, denseMatrix64F, denseMatrix64F6);
        DenseMatrix64F denseMatrix64F7 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.multTransB(denseMatrix64F6, denseMatrix64F2, denseMatrix64F7);
        CommonOps.multAdd(-1.0, denseMatrix64F2, denseMatrix64F7, denseMatrix64F6);
        DenseMatrix64F denseMatrix64F8 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        this.addTrans(denseMatrix64F4, denseMatrix64F8);
        CommonOps.addEquals(denseMatrix64F6, d, denseMatrix64F8);
        DenseMatrix64F denseMatrix64F9 = CommonOps.identity(this.dimProcess);
        CommonOps.addEquals(denseMatrix64F9, -1.0, denseMatrix64F2);
        DenseMatrix64F denseMatrix64F10 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(denseMatrix64F9, denseMatrix64F, denseMatrix64F10);
        CommonOps.mult(denseMatrix64F10, denseMatrix64F8, denseMatrix64F9);
        this.addTrans(denseMatrix64F9, denseMatrix64F7);
        CommonOps.addEquals(denseMatrix64F6, -1.0, denseMatrix64F7);
        DenseMatrix64F denseMatrix64F11 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.multTransB(denseMatrix64F3, denseMatrix64F10, denseMatrix64F11);
        CommonOps.mult(denseMatrix64F10, denseMatrix64F3, denseMatrix64F7);
        CommonOps.multTransB(denseMatrix64F7, denseMatrix64F2, denseMatrix64F9);
        CommonOps.addEquals(denseMatrix64F11, -1.0, denseMatrix64F9);
        DenseMatrix64F denseMatrix64F12 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.transpose(denseMatrix64F11, denseMatrix64F12);
        this.blockUnwrap(denseMatrix64F5, denseMatrix64F6, denseMatrix64F11, denseMatrix64F12, this.variances, n2);
        this.schurComplementInverse(denseMatrix64F5, denseMatrix64F6, denseMatrix64F11, denseMatrix64F12, this.precisions, n2);
    }

    private void computeIOUActualization(int n, DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(this.actualizations, n, this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F3 = CommonOps.identity(this.dimProcess);
        CommonOps.addEquals(denseMatrix64F3, -1.0, denseMatrix64F2);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(denseMatrix64F, denseMatrix64F3, denseMatrix64F4);
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F6 = CommonOps.identity(this.dimProcess);
        this.blockUnwrap(denseMatrix64F2, denseMatrix64F6, denseMatrix64F4, denseMatrix64F5, this.actualizations, n);
    }

    private void addTrans(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        CommonOps.transpose(denseMatrix64F, denseMatrix64F2);
        CommonOps.addEquals(denseMatrix64F2, denseMatrix64F);
    }

    private void blockUnwrap(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, DenseMatrix64F denseMatrix64F4, double[] dArray, int n) {
        for (int i = 0; i < this.dimProcess; ++i) {
            int n2;
            for (n2 = 0; n2 < this.dimProcess; ++n2) {
                dArray[n + i * this.dimTrait + n2] = denseMatrix64F.get(i, n2);
                dArray[n + (i + this.dimProcess) * this.dimTrait + n2 + this.dimProcess] = denseMatrix64F2.get(i, n2);
            }
            for (n2 = 0; n2 < this.dimProcess; ++n2) {
                dArray[n + i * this.dimTrait + n2 + this.dimProcess] = denseMatrix64F4.get(i, n2);
                dArray[n + (i + this.dimProcess) * this.dimTrait + n2] = denseMatrix64F3.get(i, n2);
            }
        }
    }

    private void schurComplementInverse(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, DenseMatrix64F denseMatrix64F4, double[] dArray, int n) {
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.invert(denseMatrix64F, denseMatrix64F5);
        DenseMatrix64F denseMatrix64F6 = this.getSchurInverseComplement(denseMatrix64F5, denseMatrix64F2, denseMatrix64F3, denseMatrix64F4);
        DenseMatrix64F denseMatrix64F7 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(denseMatrix64F5, denseMatrix64F4, denseMatrix64F7);
        DenseMatrix64F denseMatrix64F8 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(-1.0, denseMatrix64F7, denseMatrix64F6, denseMatrix64F8);
        DenseMatrix64F denseMatrix64F9 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(denseMatrix64F3, denseMatrix64F5, denseMatrix64F9);
        DenseMatrix64F denseMatrix64F10 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(-1.0, denseMatrix64F6, denseMatrix64F9, denseMatrix64F10);
        DenseMatrix64F denseMatrix64F11 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(-1.0, denseMatrix64F8, denseMatrix64F9, denseMatrix64F11);
        CommonOps.addEquals(denseMatrix64F11, denseMatrix64F5);
        this.blockUnwrap(denseMatrix64F11, denseMatrix64F6, denseMatrix64F10, denseMatrix64F8, dArray, n);
    }

    private DenseMatrix64F getSchurInverseComplement(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, DenseMatrix64F denseMatrix64F4) {
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        DenseMatrix64F denseMatrix64F6 = new DenseMatrix64F(this.dimProcess, this.dimProcess);
        CommonOps.mult(denseMatrix64F, denseMatrix64F4, denseMatrix64F6);
        CommonOps.mult(-1.0, denseMatrix64F3, denseMatrix64F6, denseMatrix64F5);
        CommonOps.addEquals(denseMatrix64F5, denseMatrix64F2);
        CommonOps.invert(denseMatrix64F5);
        return denseMatrix64F5;
    }

    @Override
    public void updateIntegratedOrnsteinUhlenbeckDiffusionMatrices(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
        double d;
        int n3;
        int n4;
        this.updateOrnsteinUhlenbeckDiffusionMatrices(n, nArray, dArray, dArray2, dArray3, dArray4, n2);
        if (DEBUG) {
            System.err.println("Matrices (safe with actualized drift, integrated):");
        }
        int n5 = this.dimTrait * this.dimTrait;
        int n6 = this.dimProcess * this.dimProcess;
        int n7 = n6 * n;
        DenseMatrix64F denseMatrix64F = this.getInverseSelectionStrength(dArray3, dArray4);
        int n8 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = this.dimTrait * nArray[n4];
            d = dArray[n4];
            this.computeIOUActualizedDisplacement(dArray2, n8, n3, d, denseMatrix64F);
            n8 += this.dimProcess;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = n5 * nArray[n4];
            d = dArray[n4];
            this.computeIOUVarianceBranch(n7, n3, d, denseMatrix64F);
        }
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = n5 * nArray[n4];
            this.computeIOUActualization(n3, denseMatrix64F);
        }
    }

    @Override
    void actualizePrecision(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, int n, int n2, int n3) {
        DenseMatrix64F denseMatrix64F3 = MissingOps.wrap(this.actualizations, n2, this.dimTrait, this.dimTrait);
        this.scalePrecision(denseMatrix64F3, denseMatrix64F, denseMatrix64F2, denseMatrix64F);
    }

    @Override
    void actualizeVariance(DenseMatrix64F denseMatrix64F, int n, int n2, int n3) {
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(this.actualizations, n2, this.dimTrait, this.dimTrait);
        DenseMatrix64F denseMatrix64F3 = this.matrixQdiPip;
        this.scaleVariance(denseMatrix64F2, denseMatrix64F, denseMatrix64F3, denseMatrix64F);
    }

    @Override
    void scaleAndDriftMean(int n, int n2, int n3) {
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(this.actualizations, n2, this.dimTrait, this.dimTrait);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(this.preOrderPartials, n, this.dimTrait, 1);
        DenseMatrix64F denseMatrix64F3 = this.matrixNiacc;
        CommonOps.mult(denseMatrix64F, denseMatrix64F2, denseMatrix64F3);
        MissingOps.unwrap(denseMatrix64F3, this.preOrderPartials, n);
        for (int i = 0; i < this.dimTrait; ++i) {
            int n4 = n + i;
            this.preOrderPartials[n4] = this.preOrderPartials[n4] + this.displacements[n3 + i];
        }
    }

    @Override
    void computePartialPrecision(int n, int n2, int n3, int n4, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
        DenseMatrix64F denseMatrix64F4 = MissingOps.wrap(this.actualizations, n3, this.dimTrait, this.dimTrait);
        DenseMatrix64F denseMatrix64F5 = MissingOps.wrap(this.actualizations, n4, this.dimTrait, this.dimTrait);
        DenseMatrix64F denseMatrix64F6 = this.matrixQdiPip;
        DenseMatrix64F denseMatrix64F7 = this.matrix0;
        this.scalePrecision(denseMatrix64F4, denseMatrix64F, denseMatrix64F6, denseMatrix64F7);
        DenseMatrix64F denseMatrix64F8 = this.matrix1;
        DenseMatrix64F denseMatrix64F9 = this.matrixQdjPjp;
        this.scalePrecision(denseMatrix64F5, denseMatrix64F2, denseMatrix64F9, denseMatrix64F8);
        CommonOps.add((D1Matrix64F)denseMatrix64F7, denseMatrix64F8, (D1Matrix64F)denseMatrix64F3);
        if (DEBUG) {
            System.err.println("Qdi: " + denseMatrix64F4);
            System.err.println("\tQdiPip: " + denseMatrix64F6);
            System.err.println("\tQdiPipQdi: " + denseMatrix64F7);
            System.err.println("\tQdj: " + denseMatrix64F5);
            System.err.println("\tQdjPjp: " + denseMatrix64F9);
            System.err.println("\tQdjPjpQdj: " + denseMatrix64F8);
        }
    }

    private void scalePrecision(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, DenseMatrix64F denseMatrix64F4) {
        CommonOps.multTransA(denseMatrix64F, denseMatrix64F2, denseMatrix64F3);
        CommonOps.mult(denseMatrix64F3, denseMatrix64F, denseMatrix64F4);
        MissingOps.forceSymmetric(denseMatrix64F4);
    }

    private void scaleVariance(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, DenseMatrix64F denseMatrix64F4) {
        CommonOps.mult(denseMatrix64F, denseMatrix64F2, denseMatrix64F3);
        CommonOps.multTransB(denseMatrix64F3, denseMatrix64F, denseMatrix64F4);
    }

    @Override
    void computeWeightedSum(double[] dArray, double[] dArray2, int n, double[] dArray3) {
        MissingOps.weightedSum(dArray, 0, this.matrixQdiPip, dArray2, 0, this.matrixQdjPjp, n, dArray3);
    }
}

