/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.MicrosatelliteSamplerTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.oldevomodel.substmodel.MicrosatelliteModel;

public class MicrosatelliteSingleAncestralStateGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String MSAT_SINGLE_ANCESTAL_STATE_GIBBS_OPERATOR = "MsatSingleAncestralStateGibbsOperator";
    private Parameter parameter;
    private MicrosatelliteSamplerTreeModel msatSamplerTreeModel;
    private MicrosatelliteModel msatModel;
    private BranchRateModel branchRateModel;

    public MicrosatelliteSingleAncestralStateGibbsOperator(Parameter parameter, MicrosatelliteSamplerTreeModel microsatelliteSamplerTreeModel, MicrosatelliteModel microsatelliteModel, BranchRateModel branchRateModel, double d) {
        this.parameter = parameter;
        this.msatSamplerTreeModel = microsatelliteSamplerTreeModel;
        this.msatModel = microsatelliteModel;
        this.branchRateModel = branchRateModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        Object object;
        TreeModel treeModel = this.msatSamplerTreeModel.getTreeModel();
        int n = MathUtils.nextInt(this.parameter.getDimension());
        NodeRef nodeRef = treeModel.getNode(this.msatSamplerTreeModel.getNodeNumberFromParameterIndex(n));
        NodeRef nodeRef2 = treeModel.getChild(nodeRef, 0);
        NodeRef nodeRef3 = treeModel.getChild(nodeRef, 1);
        int n2 = this.msatSamplerTreeModel.getNodeValue(nodeRef2);
        int n3 = this.msatSamplerTreeModel.getNodeValue(nodeRef3);
        double d = treeModel.getBranchLength(nodeRef2) * this.branchRateModel.getBranchRate(treeModel, nodeRef2);
        double d2 = treeModel.getBranchLength(nodeRef3) * this.branchRateModel.getBranchRate(treeModel, nodeRef3);
        double[] dArray = this.msatModel.getColTransitionProbabilities(d, n2);
        double[] dArray2 = this.msatModel.getColTransitionProbabilities(d2, n3);
        double[] dArray3 = new double[this.msatModel.getDataType().getStateCount()];
        if (treeModel.isRoot(nodeRef)) {
            object = this.msatModel.getStationaryDistribution();
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] * object[i];
            }
        } else {
            object = treeModel.getParent(nodeRef);
            int n4 = this.msatSamplerTreeModel.getNodeValue((NodeRef)object);
            double d3 = treeModel.getBranchLength(nodeRef) * this.branchRateModel.getBranchRate(treeModel, nodeRef);
            double[] dArray4 = this.msatModel.getRowTransitionProbabilities(d3, n4);
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] * dArray4[i];
            }
        }
        int n5 = MathUtils.randomChoicePDF(dArray3);
        this.parameter.setParameterValue(n, n5);
        return 0.0;
    }

    public String getPerformanceSuggestion() {
        return "None";
    }

    @Override
    public String getOperatorName() {
        return MSAT_SINGLE_ANCESTAL_STATE_GIBBS_OPERATOR;
    }

    public int getStepCount() {
        return 1;
    }
}

