/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.RandomLocalClockModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.List;

public class ScaledByTreeTimeBranchRateModel
extends AbstractBranchRateModel
implements Citable {
    private final TreeModel treeModel;
    private final BranchRateModel branchRateModel;
    private final Parameter meanRateParameter;
    private boolean scaleFactorKnown;
    private boolean storedScaleFactorKnown;
    private double scaleFactor;
    private double storedScaleFactor;

    public ScaledByTreeTimeBranchRateModel(TreeModel treeModel, BranchRateModel branchRateModel, Parameter parameter) {
        super("scaledByTreeTimeBranchRates");
        this.treeModel = treeModel;
        this.branchRateModel = branchRateModel;
        this.meanRateParameter = parameter;
        this.addModel(treeModel);
        this.addModel(branchRateModel);
        if (parameter != null) {
            this.addVariable(parameter);
        }
        this.scaleFactorKnown = false;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.scaleFactorKnown = false;
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.scaleFactorKnown = false;
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
        this.storedScaleFactor = this.scaleFactor;
        this.storedScaleFactorKnown = this.scaleFactorKnown;
    }

    @Override
    protected void restoreState() {
        this.scaleFactor = this.storedScaleFactor;
        this.scaleFactorKnown = this.storedScaleFactorKnown;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (tree == this.treeModel);
        if (!this.scaleFactorKnown) {
            this.scaleFactor = this.calculateScaleFactor();
        }
        return this.scaleFactor * this.branchRateModel.getBranchRate(tree, nodeRef);
    }

    private double calculateScaleFactor() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getNode(i);
            if (this.treeModel.isRoot(nodeRef)) continue;
            double d3 = this.treeModel.getBranchLength(nodeRef);
            double d4 = d3 * this.branchRateModel.getBranchRate(this.treeModel, nodeRef);
            d += d3;
            d2 += d4;
        }
        double d5 = d / d2;
        if (this.meanRateParameter != null) {
            d5 *= this.meanRateParameter.getParameterValue(0);
        }
        return d5;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.MOLECULAR_CLOCK;
    }

    @Override
    public String getDescription() {
        String string = this.branchRateModel instanceof Citable ? ((Citable)((Object)this.branchRateModel)).getDescription() : "Unknown clock model";
        string = string + " with scaling-by-tree-time";
        return string;
    }

    @Override
    public List<Citation> getCitations() {
        List<Object> list = this.branchRateModel instanceof Citable ? ((Citable)((Object)this.branchRateModel)).getCitations() : new ArrayList();
        list.add(RandomLocalClockModel.CITATION);
        return list;
    }
}

