/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.operators;

import dr.evomodel.alloppnet.speciation.AlloppDiploidHistory;
import dr.evomodel.alloppnet.speciation.AlloppLeggedTree;
import dr.evomodel.alloppnet.speciation.AlloppNode;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;
import jebl.util.FixedBitSet;

public class AlloppChangeNumHybridizations
extends SimpleMCMCOperator {
    private final AlloppSpeciesNetworkModel apspnet;
    private final AlloppSpeciesBindings apsp;
    private static final int footdistribution = 2;

    public AlloppChangeNumHybridizations(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel, AlloppSpeciesBindings alloppSpeciesBindings, double d) {
        this.apspnet = alloppSpeciesNetworkModel;
        this.apsp = alloppSpeciesBindings;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return "None";
    }

    @Override
    public String getOperatorName() {
        return "changeNumHybridizations(" + this.apspnet.getId() + "," + this.apsp.getId() + ")";
    }

    @Override
    public double doOperation() {
        if (this.apspnet.getOneHybridization()) {
            throw new RuntimeException("oneHybridization is true but changeNumHybridizations() called");
        }
        this.apspnet.beginNetworkEdit();
        double d = 0.0;
        d = MathUtils.nextBoolean() ? this.doMergeMove() : this.doSplitMove();
        this.apspnet.endNetworkEdit();
        assert (this.apspnet.netAndGTreesAreCompatible());
        return d;
    }

    private double doMergeMove() {
        double d = 0.0;
        ArrayList<MergeCandidate> arrayList = this.findCandidateMerges();
        int n = arrayList.size();
        if (n > 0) {
            int n2 = MathUtils.nextInt(n);
            MergeCandidate mergeCandidate = arrayList.get(n2);
            d += Math.log(n);
            d += this.mergeTettreePair(mergeCandidate.i, mergeCandidate.j);
            d -= Math.log(this.countCandidateSplits());
            double d2 = this.apspnet.removeHybPopParam();
            d += d2;
        }
        return d;
    }

    private double doSplitMove() {
        double d = 0.0;
        ArrayList<SplitCandidate> arrayList = this.findCandidateSplits();
        int n = arrayList.size();
        if (n > 0) {
            int n2 = MathUtils.nextInt(n);
            SplitCandidate splitCandidate = arrayList.get(n2);
            d += Math.log(n);
            d += this.splitTettree(splitCandidate.i, splitCandidate.root1, splitCandidate.root2);
            d -= Math.log(this.countCandidateMerges());
            double d2 = this.apspnet.addHybPopParam();
            d -= d2;
        }
        return d;
    }

    private ArrayList<MergeCandidate> findCandidateMerges() {
        ArrayList<MergeCandidate> arrayList = new ArrayList<MergeCandidate>();
        int n = this.apspnet.getNumberOfTetraTrees();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j || !this.pairAreMergeable(i, j)) continue;
                arrayList.add(new MergeCandidate(i, j));
            }
        }
        return arrayList;
    }

    private int countCandidateMerges() {
        return this.findCandidateMerges().size();
    }

    private ArrayList<SplitCandidate> findCandidateSplits() {
        ArrayList<SplitCandidate> arrayList = new ArrayList<SplitCandidate>();
        int n = this.apspnet.getNumberOfTetraTrees();
        for (int i = 0; i < n; ++i) {
            AlloppLeggedTree alloppLeggedTree = this.apspnet.getTetraploidTree(i);
            if (alloppLeggedTree.getSlidableNodeCount() <= 1) continue;
            AlloppNode alloppNode = ((AlloppNode)((Object)alloppLeggedTree.getSlidableRoot())).getChild(0);
            AlloppNode alloppNode2 = ((AlloppNode)((Object)alloppLeggedTree.getSlidableRoot())).getChild(1);
            arrayList.add(new SplitCandidate(i, alloppNode, alloppNode2));
            arrayList.add(new SplitCandidate(i, alloppNode2, alloppNode));
        }
        return arrayList;
    }

    private int countCandidateSplits() {
        return this.findCandidateSplits().size();
    }

    private boolean pairAreMergeable(int n, int n2) {
        boolean bl = true;
        AlloppLeggedTree alloppLeggedTree = this.apspnet.getTetraploidTree(n);
        AlloppLeggedTree alloppLeggedTree2 = this.apspnet.getTetraploidTree(n2);
        AlloppDiploidHistory alloppDiploidHistory = this.apspnet.getDiploidHistory();
        bl = bl && alloppDiploidHistory.tettreesShareLegs(alloppLeggedTree, alloppLeggedTree2);
        return bl;
    }

    private double mergeTettreePair(int n, int n2) {
        double d;
        double d2;
        FixedBitSet fixedBitSet;
        Object object;
        double d3;
        double d4 = 0.0;
        AlloppLeggedTree alloppLeggedTree = this.apspnet.getTetraploidTree(n);
        AlloppLeggedTree alloppLeggedTree2 = this.apspnet.getTetraploidTree(n2);
        AlloppDiploidHistory alloppDiploidHistory = this.apspnet.getDiploidHistory();
        AlloppDiploidHistory.FootAncHeights footAncHeights = alloppDiploidHistory.intervalOfFootAncestor(alloppLeggedTree2, AlloppDiploidHistory.LegLorR.left);
        AlloppDiploidHistory.FootAncHeights footAncHeights2 = alloppDiploidHistory.intervalOfFootAncestor(alloppLeggedTree2, AlloppDiploidHistory.LegLorR.right);
        if (footAncHeights.anchgt < footAncHeights2.anchgt) {
            d3 = footAncHeights.anchgt;
            object = this.apspnet.unionOfWholeTetTree(n, 1);
            fixedBitSet = this.apspnet.unionOfWholeTetTree(n2, 1);
            d2 = this.apsp.spseqUpperBound((FixedBitSet)object, fixedBitSet);
            d = Math.min(d2, footAncHeights2.ancanchgt);
            d4 += Math.log(this.uniformpdf(d3, d));
        } else {
            d3 = footAncHeights2.anchgt;
            object = this.apspnet.unionOfWholeTetTree(n, 0);
            fixedBitSet = this.apspnet.unionOfWholeTetTree(n2, 0);
            d2 = this.apsp.spseqUpperBound((FixedBitSet)object, fixedBitSet);
            d = Math.min(d2, footAncHeights.ancanchgt);
            d4 += Math.log(this.uniformpdf(d3, d));
        }
        d4 += Math.log(this.uniformpdf(alloppLeggedTree.getRootHeight(), d3));
        d4 += Math.log(this.uniformpdf(alloppLeggedTree2.getRootHeight(), d3));
        object = new AlloppLeggedTree(alloppLeggedTree, alloppLeggedTree2, d3);
        this.apspnet.setTetTree(n2, (AlloppLeggedTree)object);
        this.apspnet.removeTetree(n);
        alloppDiploidHistory.clearAllNodeTettree();
        for (int i = 0; i < this.apspnet.getNumberOfTetraTrees(); ++i) {
            AlloppLeggedTree alloppLeggedTree3 = this.apspnet.getTetraploidTree(i);
            int n3 = alloppLeggedTree3.getDiphistLftLeg();
            assert (alloppDiploidHistory.getNodeTettree(n3) == -1);
            alloppDiploidHistory.setNodeTettree(n3, i);
            int n4 = alloppLeggedTree3.getDiphistRgtLeg();
            assert (alloppDiploidHistory.getNodeTettree(n4) == -1);
            alloppDiploidHistory.setNodeTettree(n4, i);
        }
        double d5 = Math.min(footAncHeights.ancanchgt, footAncHeights2.ancanchgt);
        double d6 = MathUtils.uniform(d3, d5);
        alloppDiploidHistory.setHybridHeight((AlloppLeggedTree)object, d6);
        alloppDiploidHistory.removeFeet(this.apspnet, alloppLeggedTree);
        return d4 -= Math.log(this.uniformpdf(d3, d5));
    }

    private double uniformpdf(double d, double d2) {
        double d3 = 1.0 / (d2 - d);
        return d3;
    }

    private double splitTettree(int n, AlloppNode alloppNode, AlloppNode alloppNode2) {
        double d = 0.0;
        AlloppLeggedTree alloppLeggedTree = this.apspnet.getTetraploidTree(n);
        AlloppDiploidHistory alloppDiploidHistory = this.apspnet.getDiploidHistory();
        double d2 = alloppLeggedTree.getRootHeight();
        int n2 = alloppLeggedTree.getDiphistLftLeg();
        int n3 = alloppLeggedTree.getDiphistRgtLeg();
        double d3 = alloppDiploidHistory.getAncHeight(n2);
        double d4 = alloppDiploidHistory.getAncHeight(n3);
        d += Math.log(this.uniformpdf(d2, Math.min(d3, d4)));
        AlloppLeggedTree alloppLeggedTree2 = new AlloppLeggedTree(alloppLeggedTree, alloppNode);
        AlloppLeggedTree alloppLeggedTree3 = new AlloppLeggedTree(alloppLeggedTree, alloppNode2);
        alloppLeggedTree3.setDiphistLftLeg(n2);
        alloppLeggedTree3.setDiphistRgtLeg(n3);
        double d5 = MathUtils.uniform(alloppLeggedTree3.getRootHeight(), d2);
        d -= Math.log(this.uniformpdf(alloppLeggedTree3.getRootHeight(), d2));
        alloppDiploidHistory.setHybridHeight(alloppLeggedTree3, d5);
        this.apspnet.setTetTree(n, alloppLeggedTree3);
        int n4 = n;
        int n5 = this.apspnet.addTetTree(alloppLeggedTree2);
        double d6 = MathUtils.uniform(alloppLeggedTree2.getRootHeight(), d2);
        d -= Math.log(this.uniformpdf(alloppLeggedTree2.getRootHeight(), d2));
        if (MathUtils.nextBoolean()) {
            FixedBitSet fixedBitSet = this.apspnet.unionOfWholeTetTree(n5, 0);
            FixedBitSet fixedBitSet2 = this.apspnet.unionOfWholeTetTree(n4, 0);
            double d7 = this.apsp.spseqUpperBound(fixedBitSet, fixedBitSet2);
            double d8 = Math.min(d7, d3);
            double d9 = MathUtils.uniform(d2, d8);
            d -= Math.log(this.uniformpdf(d2, d8));
            alloppDiploidHistory.addTwoDipTips(this.apspnet, n5, n4, d9, d2, d6);
        } else {
            FixedBitSet fixedBitSet = this.apspnet.unionOfWholeTetTree(n5, 1);
            FixedBitSet fixedBitSet3 = this.apspnet.unionOfWholeTetTree(n4, 1);
            double d10 = this.apsp.spseqUpperBound(fixedBitSet, fixedBitSet3);
            double d11 = Math.min(d10, d4);
            double d12 = MathUtils.uniform(d2, d11);
            d -= Math.log(this.uniformpdf(d2, d11));
            alloppDiploidHistory.addTwoDipTips(this.apspnet, n5, n4, d2, d12, d6);
        }
        return d += Math.log(2.0);
    }

    private class SplitCandidate {
        public int i;
        public AlloppNode root1;
        public AlloppNode root2;

        SplitCandidate(int n, AlloppNode alloppNode, AlloppNode alloppNode2) {
            this.i = n;
            this.root1 = alloppNode;
            this.root2 = alloppNode2;
        }
    }

    private class MergeCandidate {
        public int i;
        public int j;

        MergeCandidate(int n, int n2) {
            this.i = n;
            this.j = n2;
        }
    }
}

