/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public class ExponentialBSPGrowth
extends DemographicFunction.Abstract {
    private double r;
    private double N0;

    public ExponentialBSPGrowth(Units.Type type) {
        super(type);
    }

    public void setup(double d, double d2, double d3) {
        this.N0 = d;
        this.r = (Math.log(d) - Math.log(d2)) / d3;
    }

    public void setup(double d, double d2) {
        this.N0 = d;
        this.r = d2;
    }

    public void setupN1(double d, double d2, double d3) {
        this.r = d2;
        this.N0 = d * Math.exp(d2 * d3);
    }

    @Override
    public double getDemographic(double d) {
        if (this.r == 0.0) {
            return this.N0;
        }
        return this.N0 * Math.exp(-d * this.r);
    }

    @Override
    public double getLogDemographic(double d) {
        if (this.r == 0.0) {
            return Math.log(this.N0);
        }
        return Math.log(this.N0) - d * this.r;
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = this.r == 0.0 ? (d2 - d) / this.N0 : (Math.exp(d2 * this.r) - Math.exp(d * this.r)) / this.N0 / this.r;
        return d3;
    }

    @Override
    public int getNumArguments() {
        return 0;
    }

    @Override
    public String getArgumentName(int n) {
        return null;
    }

    @Override
    public double getArgument(int n) {
        return 0.0;
    }

    @Override
    public void setArgument(int n, double d) {
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return 0.0;
    }

    public DemographicFunction getCopy() {
        return null;
    }

    @Override
    public double getIntensity(double d) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("not implemented");
    }
}

