/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.WrappedAlignment;

public class HypermutantAlignment
extends WrappedAlignment {
    private APOBECType type = null;
    private int[] mutatedContextCounts;
    private int[] unmutatedContextCounts;

    public HypermutantAlignment(APOBECType aPOBECType, Alignment alignment) {
        super(alignment);
        this.type = aPOBECType;
        if (alignment.getDataType().getType() != 0) {
            throw new RuntimeException("HypermutantAlignment can only convert nucleotide alignments");
        }
        this.mutatedContextCounts = new int[this.getTaxonCount()];
        this.unmutatedContextCounts = new int[this.getTaxonCount()];
        this.countContexts();
    }

    @Override
    public int getState(int n, int n2) {
        int n3 = this.alignment.getState(n, n2);
        if (n3 == 0) {
            int n4 = this.getNextContextState(n, n2);
            if (this.type == APOBECType.ALL || this.type == APOBECType.HA3G && n4 == 2 || this.type == APOBECType.HA3F && n4 == 0 || this.type == APOBECType.BOTH && (n4 == 2 || n4 == 0)) {
                n3 = 5;
            }
        }
        return n3;
    }

    private int getNextContextState(int n, int n2) {
        int n3 = 17;
        for (int i = n2 + 1; n3 == 17 && i < this.getSiteCount(); ++i) {
            n3 = this.alignment.getState(n, i);
        }
        return n3;
    }

    private void countContexts() {
        for (int i = 0; i < this.getTaxonCount(); ++i) {
            for (int j = 0; j < this.getSiteCount(); ++j) {
                int n = this.alignment.getState(i, j);
                if (n != 0 && n != 2) continue;
                int n2 = this.getNextContextState(i, j);
                if (!(this.type == APOBECType.ALL || this.type == APOBECType.HA3G && n2 == 2 || this.type == APOBECType.HA3F && n2 == 0) && (this.type != APOBECType.BOTH || n2 != 2 && n2 != 0)) continue;
                if (n == 0) {
                    int n3 = i;
                    this.mutatedContextCounts[n3] = this.mutatedContextCounts[n3] + 1;
                    continue;
                }
                int n4 = i;
                this.unmutatedContextCounts[n4] = this.unmutatedContextCounts[n4] + 1;
            }
        }
    }

    public int[] getMutatedContextCounts() {
        return this.mutatedContextCounts;
    }

    public int[] getUnmutatedContextCounts() {
        return this.unmutatedContextCounts;
    }

    public int getMutatedContextCount() {
        int n = 0;
        for (int n2 : this.mutatedContextCounts) {
            n += n2;
        }
        return n;
    }

    public int getUnmutatedContextCount() {
        int n = 0;
        for (int n2 : this.unmutatedContextCounts) {
            n += n2;
        }
        return n;
    }

    public static enum APOBECType {
        ALL("all"),
        BOTH("both"),
        HA3G("hA3G"),
        HA3F("hA3F");

        final String label;

        private APOBECType(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }
}

