/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceDistribution;
import dr.inference.trace.TraceException;
import dr.inference.trace.TraceList;
import dr.stats.DiscreteStatistics;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.util.HeapSort;
import dr.util.NumberFormatter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class DnDsPerSiteAnalysis
implements Citable {
    public static final String DNDS_PER_SITE_ANALYSIS = "dNdSPerSiteAnalysis";
    public static final String BURN_IN = "burnin";
    public static final String CUTOFF = "cutoff";
    public static final String PROPORTION = "proportion";
    public static final String INCLUDE_SIGNIFICANT_SYMBOL = "includeSymbol";
    public static final String INCLUDE_SIGNIFICANCE_LEVEL = "includeLevel";
    public static final String INCLUDE_SITE_CLASSIFICATION = "includeClassification";
    public static final String SIGNIFICANCE_TEST = "test";
    public static final String SEPARATOR_STRING = "separator";
    public static final String INCLUDE_SIMULATION_OUTCOME = "simulationOutcome";
    public static final String INCLUDE_HPD = "includeHPD";
    public static final String INCLUDE_CPD = "includeCPD";
    public static final String SITE_SIMULATION = "siteSimulation";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("cutoff", true), AttributeRule.newDoubleRule("proportion", true), AttributeRule.newIntegerRule("burnin", true), AttributeRule.newBooleanRule("includeHPD", true), AttributeRule.newBooleanRule("includeCPD", true), AttributeRule.newBooleanRule("includeSymbol", true), AttributeRule.newBooleanRule("includeLevel", true), AttributeRule.newBooleanRule("includeClassification", true), AttributeRule.newBooleanRule("simulationOutcome", true), AttributeRule.newStringRule("siteSimulation", true), AttributeRule.newStringRule("test", true), AttributeRule.newStringRule("separator", true), new StringAttributeRule("fileName", "The traceName of a BEAST log file (can not include trees, which should be logged separately")};

        @Override
        public String getParserName() {
            return DnDsPerSiteAnalysis.DNDS_PER_SITE_ANALYSIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("fileName");
            try {
                File file = new File(string);
                String string2 = file.getName();
                String string3 = file.getParent();
                if (!file.isAbsolute()) {
                    string3 = System.getProperty("user.dir");
                }
                file = new File(string3, string2);
                string = file.getAbsolutePath();
                LogFileTraces logFileTraces = new LogFileTraces(string, file);
                logFileTraces.loadTraces();
                long l = logFileTraces.getMaxState();
                long l2 = xMLObject.getAttribute(DnDsPerSiteAnalysis.BURN_IN, l / 10L);
                if (l2 < 0L || l2 >= l) {
                    l2 = l / 5L;
                    System.out.println("WARNING: Burn-in larger than total number of states - using 20%");
                }
                logFileTraces.setBurnIn(l2);
                DnDsPerSiteAnalysis dnDsPerSiteAnalysis = new DnDsPerSiteAnalysis(logFileTraces);
                dnDsPerSiteAnalysis.setSignificanceTest(SignificanceTest.parseFromString(xMLObject.getAttribute(DnDsPerSiteAnalysis.SIGNIFICANCE_TEST, SignificanceTest.NOT_EQUAL_CPD.getText())));
                dnDsPerSiteAnalysis.setCutoff(xMLObject.getAttribute(DnDsPerSiteAnalysis.CUTOFF, 1.0));
                dnDsPerSiteAnalysis.setProportion(xMLObject.getAttribute(DnDsPerSiteAnalysis.PROPORTION, 0.95));
                dnDsPerSiteAnalysis.setSeparator(xMLObject.getAttribute(DnDsPerSiteAnalysis.SEPARATOR_STRING, "\t"));
                dnDsPerSiteAnalysis.setIncludeHPD(xMLObject.getAttribute(DnDsPerSiteAnalysis.INCLUDE_HPD, false));
                dnDsPerSiteAnalysis.setIncludeCPD(xMLObject.getAttribute(DnDsPerSiteAnalysis.INCLUDE_HPD, true));
                dnDsPerSiteAnalysis.setIncludeSignificanceLevel(xMLObject.getAttribute(DnDsPerSiteAnalysis.INCLUDE_SIGNIFICANCE_LEVEL, false));
                dnDsPerSiteAnalysis.setIncludeSignificantSymbol(xMLObject.getAttribute(DnDsPerSiteAnalysis.INCLUDE_SIGNIFICANT_SYMBOL, true));
                dnDsPerSiteAnalysis.setIncludeSiteClassification(xMLObject.getAttribute(DnDsPerSiteAnalysis.INCLUDE_SITE_CLASSIFICATION, true));
                dnDsPerSiteAnalysis.setIncludeSimulationOutcome(xMLObject.getAttribute(DnDsPerSiteAnalysis.INCLUDE_SIMULATION_OUTCOME, false));
                if (dnDsPerSiteAnalysis.getIncludeSimulationOutcome()) {
                    String string4 = xMLObject.getAttribute(DnDsPerSiteAnalysis.SITE_SIMULATION, "empty");
                    if (string4.equals("empty")) {
                        System.err.println("you want simulation evaluation but do not provide a site simulation string??");
                    } else {
                        String[] stringArray = DnDsPerSiteAnalysis.parseVariableLengthStringArray(string4);
                        dnDsPerSiteAnalysis.setSiteSimulation(stringArray);
                    }
                }
                return dnDsPerSiteAnalysis;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
        }

        @Override
        public String getParserDescription() {
            return "Performs a trace dN/dS analysis.";
        }

        @Override
        public Class getReturnType() {
            return DnDsPerSiteAnalysis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final TraceList traceList;
    private final int numSites;
    private OutputFormat format;
    private int fieldWidth;
    private int firstField;
    private NumberFormatter numberFormatter;
    private static final boolean DEBUG = true;

    public DnDsPerSiteAnalysis(TraceList traceList) {
        this.traceList = traceList;
        this.numSites = traceList.getTraceCount();
        this.format = new OutputFormat();
        this.fieldWidth = 14;
        this.firstField = 10;
        this.numberFormatter = new NumberFormatter(6);
        this.numberFormatter.setPadding(true);
        this.numberFormatter.setFieldWidth(this.fieldWidth);
    }

    public void setIncludeMean(boolean bl) {
        this.format.includeMean = bl;
    }

    public void setIncludeHPD(boolean bl) {
        this.format.includeHPD = bl;
    }

    public void setIncludeCPD(boolean bl) {
        this.format.includeCPD = bl;
    }

    public void setIncludeSignificanceLevel(boolean bl) {
        this.format.includeSignificanceLevel = bl;
    }

    public void setIncludeSignificantSymbol(boolean bl) {
        this.format.includeSignificantSymbol = bl;
    }

    public void setIncludeSimulationOutcome(boolean bl) {
        this.format.includeSimulationOutcome = bl;
    }

    public boolean getIncludeSimulationOutcome() {
        return this.format.includeSimulationOutcome;
    }

    public void setProportion(double d) {
        this.format.proportion = d;
    }

    public void setSiteSimulation(String[] stringArray) {
        this.format.siteSimulation = stringArray;
    }

    public void setIncludeSiteClassification(boolean bl) {
        this.format.includeSiteClassification = bl;
    }

    public void setCutoff(double d) {
        this.format.cutoff = d;
    }

    public void setSeparator(String string) {
        this.format.separator = string;
    }

    public void setSignificanceTest(SignificanceTest significanceTest) {
        this.format.test = significanceTest;
    }

    private String toStringSite(int n, OutputFormat outputFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        this.traceList.analyseTrace(n);
        TraceDistribution traceDistribution = this.traceList.getDistributionStatistics(n);
        stringBuilder.append(this.numberFormatter.formatToFieldWidth(Integer.toString(n + 1), this.firstField));
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        if (outputFormat.proportion == 0.95) {
            dArray[0] = traceDistribution.getLowerHPD();
            dArray[1] = traceDistribution.getUpperHPD();
            dArray2[0] = traceDistribution.getLowerCPD();
            dArray2[1] = traceDistribution.getUpperCPD();
        } else if (outputFormat.proportion >= 1.0) {
            dArray[0] = dArray2[0] = traceDistribution.getMinimum() - traceDistribution.getMinimum() * (outputFormat.proportion - 1.0);
            dArray[1] = dArray2[1] = traceDistribution.getMaximum() + traceDistribution.getMaximum() * (outputFormat.proportion - 1.0);
        } else {
            dArray = DnDsPerSiteAnalysis.getCustomHPDInterval(outputFormat.proportion, this.traceList.getValues(n));
            double[] dArray3 = new double[]{(1.0 - outputFormat.proportion) / 2.0, outputFormat.proportion + (1.0 - outputFormat.proportion) / 2.0};
            dArray2 = DnDsPerSiteAnalysis.getCustomCPDInterval(dArray3, this.traceList.getValues(n));
        }
        if (outputFormat.includeMean) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.format(traceDistribution.getMean()));
        }
        if (outputFormat.includeHPD) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.format(dArray[0]));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.format(dArray[1]));
        }
        if (outputFormat.includeCPD) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.format(dArray2[0]));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.format(dArray2[1]));
        }
        if (outputFormat.includeSignificanceLevel || outputFormat.includeSignificantSymbol || outputFormat.includeSiteClassification || outputFormat.includeSimulationOutcome) {
            String string;
            boolean bl = false;
            String string2 = "0";
            if (outputFormat.test == SignificanceTest.NOT_EQUAL_HPD) {
                if (dArray[0] < outputFormat.cutoff && dArray[1] < outputFormat.cutoff) {
                    string = this.numberFormatter.formatToFieldWidth(">" + outputFormat.proportion, this.fieldWidth);
                    bl = true;
                    string2 = "-";
                } else if (dArray[0] > outputFormat.cutoff && dArray[1] > outputFormat.cutoff) {
                    string = this.numberFormatter.formatToFieldWidth(">" + outputFormat.proportion, this.fieldWidth);
                    bl = true;
                    string2 = "+";
                } else {
                    string = this.numberFormatter.formatToFieldWidth("<=" + outputFormat.proportion, this.fieldWidth);
                }
            } else if (outputFormat.test == SignificanceTest.NOT_EQUAL_CPD) {
                if (dArray2[0] < outputFormat.cutoff && dArray2[1] < outputFormat.cutoff) {
                    string = this.numberFormatter.formatToFieldWidth(">" + outputFormat.proportion, this.fieldWidth);
                    bl = true;
                    string2 = "-";
                } else if (dArray2[0] > outputFormat.cutoff && dArray2[1] > outputFormat.cutoff) {
                    string = this.numberFormatter.formatToFieldWidth(">" + outputFormat.proportion, this.fieldWidth);
                    bl = true;
                    string2 = "+";
                } else {
                    string = this.numberFormatter.formatToFieldWidth("<=" + outputFormat.proportion, this.fieldWidth);
                }
            } else {
                List<Double> list = this.traceList.getValues(n);
                double d = 0.0;
                double d2 = 0.0;
                int n2 = 0;
                for (Double d3 : list) {
                    double d4 = ((Number)d3).doubleValue();
                    if (d4 < outputFormat.cutoff) {
                        if (outputFormat.test == SignificanceTest.LESS_THAN || outputFormat.test == SignificanceTest.LESS_OR_GREATER_THAN) {
                            d2 += 1.0;
                        }
                    } else if (d4 > outputFormat.cutoff && (outputFormat.test == SignificanceTest.GREATER_THAN || outputFormat.test == SignificanceTest.LESS_OR_GREATER_THAN)) {
                        d += 1.0;
                    }
                    ++n2;
                }
                d /= (double)n2;
                d2 /= (double)n2;
                if (d > outputFormat.proportion) {
                    bl = true;
                    string2 = "+";
                } else if (d2 > outputFormat.proportion) {
                    bl = true;
                    string2 = "-";
                }
                string = d > d2 ? this.numberFormatter.format(d) : this.numberFormatter.format(d2);
            }
            if (outputFormat.includeSignificanceLevel) {
                stringBuilder.append(outputFormat.separator);
                stringBuilder.append(string);
            }
            if (outputFormat.includeSiteClassification) {
                stringBuilder.append(outputFormat.separator);
                stringBuilder.append(string2);
            }
            if (outputFormat.includeSignificantSymbol) {
                stringBuilder.append(outputFormat.separator);
                if (bl) {
                    stringBuilder.append("*");
                }
            }
            if (outputFormat.includeSimulationOutcome) {
                stringBuilder.append(outputFormat.separator);
                stringBuilder.append(outputFormat.siteSimulation[n]);
                stringBuilder.append(outputFormat.separator);
                if (outputFormat.siteSimulation[n].equals("+") || outputFormat.siteSimulation[n].equals("-")) {
                    if (string2.equals(outputFormat.siteSimulation[n])) {
                        stringBuilder.append("TP");
                    } else {
                        stringBuilder.append("FN");
                    }
                } else if (string2.equals(outputFormat.siteSimulation[n])) {
                    stringBuilder.append("TN");
                } else {
                    stringBuilder.append("FP");
                }
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String header(OutputFormat outputFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# Some information here\n");
        stringBuilder.append("# Please cite: " + Citable.Utils.getCitationString(this));
        stringBuilder.append(this.numberFormatter.formatToFieldWidth("Site", this.firstField));
        if (outputFormat.includeMean) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Mean", this.fieldWidth));
        }
        if (outputFormat.includeHPD) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("HPD Low", this.fieldWidth));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("HPD Up", this.fieldWidth));
        }
        if (outputFormat.includeCPD) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("CPD Low", this.fieldWidth));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("CPD Up", this.fieldWidth));
        }
        if (outputFormat.includeSignificanceLevel) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Level", this.fieldWidth));
        }
        if (outputFormat.includeSiteClassification) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Classification", this.fieldWidth));
        }
        if (outputFormat.includeSignificantSymbol) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Significant", this.fieldWidth));
        }
        if (outputFormat.includeSimulationOutcome) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Simulated", this.fieldWidth));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Evaluation", this.fieldWidth));
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.header(this.format));
        for (int i = 0; i < this.numSites; ++i) {
            stringBuilder.append(this.toStringSite(i, this.format));
        }
        return stringBuilder.toString();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.COUNTING_PROCESSES;
    }

    @Override
    public String getDescription() {
        return "Renaissance counting";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2012_RENAISSANCE);
    }

    private static double[] getCustomHPDInterval(double d, List list) {
        double[] dArray = new double[2];
        int n = list.size();
        int[] nArray = new int[n];
        Double[] doubleArray = list.toArray(new Double[0]);
        double[] dArray2 = DnDsPerSiteAnalysis.toPrimitiveDoubleArray(doubleArray);
        HeapSort.sort(dArray2, nArray);
        double d2 = Double.MAX_VALUE;
        int n2 = 0;
        int n3 = (int)Math.round(d * (double)n);
        for (int i = 0; i <= n - n3; ++i) {
            double d3 = dArray2[nArray[i + n3 - 1]];
            double d4 = dArray2[nArray[i]];
            double d5 = Math.abs(d3 - d4);
            if (!(d5 < d2)) continue;
            d2 = d5;
            n2 = i;
        }
        dArray[0] = dArray2[nArray[n2]];
        dArray[1] = dArray2[nArray[n2 + n3 - 1]];
        return dArray;
    }

    private static double[] getCustomCPDInterval(double[] dArray, List list) {
        double[] dArray2 = new double[2];
        int n = list.size();
        int[] nArray = new int[n];
        Double[] doubleArray = list.toArray(new Double[0]);
        double[] dArray3 = DnDsPerSiteAnalysis.toPrimitiveDoubleArray(doubleArray);
        HeapSort.sort(dArray3, nArray);
        dArray2[0] = DiscreteStatistics.quantile(dArray[0], dArray3, nArray);
        dArray2[1] = DiscreteStatistics.quantile(dArray[1], dArray3, nArray);
        return dArray2;
    }

    private static double[] toPrimitiveDoubleArray(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        return dArray;
    }

    private static String[] parseVariableLengthStringArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    public static enum SignificanceTest {
        GREATER_THAN("gt"),
        LESS_THAN("lt"),
        NOT_EQUAL_HPD("ne_HPD"),
        NOT_EQUAL_CPD("ne_CPD"),
        LESS_OR_GREATER_THAN("logt");

        private final String text;

        private SignificanceTest(String string2) {
            this.text = string2;
        }

        public String getText() {
            return this.text;
        }

        public static SignificanceTest parseFromString(String string) {
            for (SignificanceTest significanceTest : SignificanceTest.values()) {
                if (significanceTest.getText().compareToIgnoreCase(string) != 0) continue;
                return significanceTest;
            }
            return null;
        }
    }

    private class OutputFormat {
        boolean includeMean;
        boolean includeHPD;
        boolean includeCPD;
        boolean includeSignificanceLevel;
        boolean includeSignificantSymbol;
        boolean includeSiteClassification;
        boolean includeSimulationOutcome;
        String[] siteSimulation;
        double cutoff;
        double proportion;
        SignificanceTest test;
        String separator;

        OutputFormat() {
            this(true, false, true, true, true, true, false, null, 1.0, 0.95, SignificanceTest.NOT_EQUAL_CPD, "\t");
        }

        OutputFormat(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, String[] stringArray, double d, double d2, SignificanceTest significanceTest, String string) {
            this.includeMean = bl;
            this.includeHPD = bl2;
            this.includeCPD = bl3;
            this.includeSignificanceLevel = bl4;
            this.includeSignificantSymbol = bl5;
            this.includeSiteClassification = bl6;
            this.includeSimulationOutcome = bl7;
            this.siteSimulation = stringArray;
            this.cutoff = d;
            this.proportion = d2;
            this.test = significanceTest;
            this.separator = string;
        }
    }
}

