/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.speciation.SpeciationModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;

public class BirthDeathSerialSkylineModel
extends SpeciationModel {
    Variable<Double> times;
    Variable<Double> lambda;
    Variable<Double> mu;
    Variable<Double> psi;
    Variable<Double> p;
    Variable<Double> origin;
    boolean relativeDeath = false;
    int size = 1;
    double t_root;
    double x0;
    protected double[] p0_iMinus1;
    protected double[] Ai;
    protected double[] Bi;
    protected boolean birthChanges = true;
    protected boolean deathChanges = true;
    protected boolean samplingChanges = true;
    protected boolean timesStartFromOrigin = true;
    protected double[] timesFromTips;

    public BirthDeathSerialSkylineModel(Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4, Variable<Double> variable5, Variable<Double> variable6, boolean bl, boolean bl2, boolean bl3, Units.Type type) {
        this("birthDeathSerialSamplingModel", variable, variable2, variable3, variable4, variable5, variable6, bl, bl2, bl3, type);
    }

    public BirthDeathSerialSkylineModel(String string, Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4, Variable<Double> variable5, Variable<Double> variable6, boolean bl, boolean bl2, boolean bl3, Units.Type type) {
        super(string, type);
        this.size = variable.getSize();
        if (variable2.getSize() != 1 && variable2.getSize() != this.size) {
            throw new RuntimeException("Length of Lambda parameter should be one or equal to the size of time parameter (size = " + this.size + ")");
        }
        if (variable3.getSize() != 1 && variable3.getSize() != this.size) {
            throw new RuntimeException("Length of mu parameter should be one or equal to the size of time parameter (size = " + this.size + ")");
        }
        this.timesStartFromOrigin = bl3;
        this.times = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, variable.getSize()));
        this.lambda = variable2;
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, variable2.getSize()));
        this.mu = variable3;
        this.addVariable(variable3);
        variable3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, variable3.getSize()));
        this.p = variable5;
        this.addVariable(variable5);
        variable5.addBounds(new Parameter.DefaultBounds(1.0, 0.0, variable5.getSize()));
        this.origin = variable6;
        this.addVariable(variable6);
        variable5.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, variable6.getSize()));
        this.psi = variable4;
        this.addVariable(variable4);
        variable4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, variable4.getSize()));
        this.relativeDeath = bl;
    }

    public int lineageCountAtTime(double d, Tree tree) {
        int n;
        int n2 = 1;
        for (n = 0; n < tree.getInternalNodeCount(); ++n) {
            if (!(tree.getNodeHeight(tree.getInternalNode(n)) > d)) continue;
            ++n2;
        }
        for (n = 0; n < tree.getExternalNodeCount(); ++n) {
            if (!(tree.getNodeHeight(tree.getExternalNode(n)) > d)) continue;
            --n2;
        }
        return n2;
    }

    public double Ai(double d, double d2, double d3) {
        return Math.sqrt((d - d2 - d3) * (d - d2 - d3) + 4.0 * d * d3);
    }

    public double Bi(double d, double d2, double d3, double d4, double d5) {
        return -((1.0 - 2.0 * d5) * d + d2 + d3) / d4;
    }

    public double p0(int n, double d, double d2) {
        return this.p0(this.birth(this.birthChanges ? n : 0), this.death(this.deathChanges ? n : 0), this.psi(this.samplingChanges ? n : 0), this.Ai[n], this.Bi[n], d, d2);
    }

    public double p0(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return (d + d2 + d3 - d4 * (Math.exp(d4 * (d6 - d7)) * (1.0 - d5) - (1.0 + d5)) / (Math.exp(d4 * (d6 - d7)) * (1.0 - d5) + (1.0 + d5))) / (2.0 * d);
    }

    public double g(int n, double d, double d2) {
        double d3 = (1.0 - this.Bi[n]) * (1.0 - this.Bi[n]);
        double d4 = (1.0 + this.Bi[n]) * (1.0 + this.Bi[n]);
        return 4.0 / (2.0 * (1.0 - this.Bi[n] * this.Bi[n]) + Math.exp(this.Ai[n] * (d - d2)) * d3 + Math.exp(-this.Ai[n] * (d - d2)) * d4);
    }

    public double t(int n) {
        return this.timesFromTips[n];
    }

    public double birth(int n) {
        return this.lambda.getValue(n);
    }

    public double death(int n) {
        return this.relativeDeath ? this.mu.getValue(n) * this.birth(n) : this.mu.getValue(n);
    }

    public double psi(int n) {
        return this.psi.getValue(n);
    }

    public double p() {
        return this.p.getValue(0);
    }

    public double lambda(double d) {
        return this.lambda.getValue(this.index(d));
    }

    public double mu(double d) {
        return this.mu.getValue(this.index(d));
    }

    public int index(double d) {
        int n = Arrays.binarySearch(this.timesFromTips, d);
        if (n < 0) {
            n = -n - 1;
        }
        return Math.max(n - 1, 0);
    }

    public void preCalculation(Tree tree) {
        int n;
        this.t_root = tree.getNodeHeight(tree.getRoot());
        this.x0 = this.t_root + this.origin.getValue(0);
        if (this.timesFromTips == null) {
            this.timesFromTips = new double[this.times.getSize()];
        }
        if (this.timesStartFromOrigin) {
            this.timesFromTips[0] = 0.0;
            for (n = 1; n < this.timesFromTips.length; ++n) {
                this.timesFromTips[n] = Math.max(0.0, this.x0 - this.times.getValue(this.timesFromTips.length - n));
            }
        } else {
            for (n = 0; n < this.timesFromTips.length; ++n) {
                this.timesFromTips[n] = this.times.getValue(n);
            }
        }
        this.Ai = new double[this.size];
        this.Bi = new double[this.size];
        this.p0_iMinus1 = new double[this.size];
        for (n = 0; n < this.size; ++n) {
            this.Ai[n] = this.Ai(this.birth(this.birthChanges ? n : 0), this.death(this.deathChanges ? n : 0), this.psi(this.samplingChanges ? n : 0));
        }
        this.Bi[0] = this.Bi(this.birth(0), this.death(0), this.psi(0), this.Ai[0], 1.0);
        for (n = 1; n < this.size; ++n) {
            this.p0_iMinus1[n - 1] = this.p0(this.birth(this.birthChanges ? n - 1 : 0), this.death(this.deathChanges ? n - 1 : 0), this.psi(this.samplingChanges ? n - 1 : 0), this.Ai[n - 1], this.Bi[n - 1], this.t(n), this.t(n - 1));
            this.Bi[n] = this.Bi(this.birth(this.birthChanges ? n : 0), this.death(this.deathChanges ? n : 0), this.psi(this.samplingChanges ? n : 0), this.Ai[n], this.p0_iMinus1[n - 1]);
        }
    }

    @Override
    public final double calculateTreeLogLikelihood(Tree tree) {
        double d;
        double d2;
        int n;
        int[] nArray = new int[this.size];
        int n2 = tree.getExternalNodeCount();
        this.preCalculation(tree);
        int n3 = this.size - 1;
        double d3 = this.t(n3);
        double d4 = this.g(n3, this.x0, d3);
        double d5 = Math.log(d4);
        for (n = 0; n < tree.getInternalNodeCount(); ++n) {
            d2 = tree.getNodeHeight(tree.getInternalNode(n));
            n3 = this.index(d2);
            d = Math.log(this.birth(this.birthChanges ? n3 : 0) * this.g(n3, d2, this.t(n3)));
            d5 += d;
            d3 = this.t(n3);
            d4 = this.g(n3, d2, d3);
        }
        for (n = 0; n < n2; ++n) {
            d2 = tree.getNodeHeight(tree.getExternalNode(n));
            n3 = this.index(d2);
            d = Math.log(this.psi(this.samplingChanges ? n3 : 0)) - Math.log(this.g(n3, d2, this.t(n3)));
            d5 += d;
        }
        for (n = 0; n < this.size - 1; ++n) {
            d2 = 0.0;
            d = this.t(n + 1);
            nArray[n] = this.lineageCountAtTime(d, tree);
            if (nArray[n] > 0) {
                d2 += (double)nArray[n] * Math.log(this.g(n, d, this.t(n)));
            }
            d5 += d2;
        }
        return d5;
    }

    @Override
    public double calculateTreeLogLikelihood(Tree tree, Set<Taxon> set) {
        if (set.size() == 0) {
            return this.calculateTreeLogLikelihood(tree);
        }
        throw new RuntimeException("Not implemented!");
    }

    public static void main(String[] stringArray) throws IOException, Importer.ImportException {
        Variable.D d = new Variable.D(1.0, 10);
        Variable.D d2 = new Variable.D(1.0, 10);
        for (int i = 0; i < d2.getSize(); ++i) {
            d.setValue(i, (double)(i + 1) * 2.0);
            d2.setValue(i, (double)i + 1.0);
        }
        Variable.D d3 = new Variable.D(1.0, 10);
        Variable.D d4 = new Variable.D(0.5, 1);
        Variable.D d5 = new Variable.D(0.5, 1);
        Variable.D d6 = new Variable.D(0.5, 1);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        BirthDeathSerialSkylineModel birthDeathSerialSkylineModel = new BirthDeathSerialSkylineModel(d, d3, d2, d4, d5, d6, bl, bl2, bl3, Units.Type.SUBSTITUTIONS);
        NewickImporter newickImporter = new NewickImporter("((A:6,B:5):4,(C:3,D:2):1);");
        Tree tree = newickImporter.importNextTree();
        birthDeathSerialSkylineModel.calculateTreeLogLikelihood(tree);
        for (int i = 0; i < d.getSize(); ++i) {
            System.out.println("mu at time " + i + " is " + birthDeathSerialSkylineModel.mu(i));
            System.out.println("p0 at time " + i + " is " + birthDeathSerialSkylineModel.p0(0, i, i));
        }
    }
}

