/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree.treemetrics;

import dr.evolution.tree.Clade;
import dr.evolution.tree.Tree;
import dr.evolution.tree.treemetrics.TreeMetric;
import java.util.BitSet;
import java.util.Set;

public class CladeHeightMetric
implements TreeMetric {
    public static TreeMetric.Type TYPE = TreeMetric.Type.CLADE_HEIGHT;
    BitSet tmpBits = new BitSet();

    @Override
    public double getMetric(Tree tree, Tree tree2) {
        TreeMetric.Utils.checkTreeTaxa(tree, tree2);
        Set<Clade> set = Clade.getCladeSet(tree);
        Set<Clade> set2 = Clade.getCladeSet(tree2);
        return this.getDistance(set, set2);
    }

    private double getDistance(Set<Clade> set, Set<Clade> set2) {
        double d;
        Clade clade;
        double d2;
        double d3 = 0.0;
        for (Clade clade2 : set) {
            d2 = clade2.getHeight();
            clade = this.findMRCA(clade2, set2);
            d = clade.getHeight();
            d3 += (d2 - d) * (d2 - d);
        }
        for (Clade clade2 : set2) {
            d2 = clade2.getHeight();
            clade = this.findMRCA(clade2, set);
            d = clade.getHeight();
            d3 += (d - d2) * (d - d2);
        }
        return Math.sqrt(d3);
    }

    private Clade findMRCA(Clade clade, Set<Clade> set) {
        for (Clade clade2 : set) {
            if (!this.isMRCA(clade, clade2)) continue;
            return clade2;
        }
        return null;
    }

    private boolean isMRCA(Clade clade, Clade clade2) {
        if (clade.getSize() > clade2.getSize()) {
            return false;
        }
        this.tmpBits.clear();
        this.tmpBits.or(clade.getBits());
        this.tmpBits.and(clade2.getBits());
        return this.tmpBits.cardinality() == clade.getSize();
    }

    @Override
    public TreeMetric.Type getType() {
        return TYPE;
    }

    public String toString() {
        return this.getType().getShortName();
    }
}

