/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.graph.directed;

import gnu.trove.map.hash.TIntIntHashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.delta.GraphViewDeltaMonitor;
import org.chocosolver.solver.variables.view.graph.DirectedGraphView;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetUnion;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class DirectedEdgeInducedSubgraphView
extends DirectedGraphView<DirectedGraphVar> {
    protected DirectedGraph lb;
    protected DirectedGraph ub;
    protected DirectedGraphVar graphVar;
    protected boolean exclude;
    protected ISet enforceNodes = SetFactory.makeStoredSet(SetType.BITSET, 0, this.getModel());
    protected ISet LBnodes;
    protected ISet[] successors;

    public DirectedEdgeInducedSubgraphView(String name, DirectedGraphVar graphVar, int[][] edges, boolean exclude) {
        super(name, (Variable[])new DirectedGraphVar[]{graphVar});
        this.exclude = exclude;
        this.graphVar = graphVar;
        this.successors = DirectedGraph.edgesArrayToSuccessorsSets(this.getNbMaxNodes(), edges);
        this.lb = GraphFactory.makeEdgeInducedSubgraph(this.getModel(), (DirectedGraph)graphVar.getLB(), (DirectedGraph)graphVar.getUB(), edges, exclude);
        this.ub = GraphFactory.makeEdgeInducedSubgraph(this.getModel(), (DirectedGraph)graphVar.getUB(), (DirectedGraph)graphVar.getUB(), edges, exclude);
        this.LBnodes = new SetUnion(this.getModel(), this.lb.getNodes(), this.enforceNodes);
    }

    @Override
    public ISet getMandatoryNodes() {
        return this.LBnodes;
    }

    @Override
    public DirectedGraph getLB() {
        return this.lb;
    }

    @Override
    public DirectedGraph getUB() {
        return this.ub;
    }

    @Override
    public int getNbMaxNodes() {
        return this.graphVar.getNbMaxNodes();
    }

    @Override
    public boolean isDirected() {
        return this.graphVar.isDirected();
    }

    @Override
    protected boolean doRemoveNode(int node) throws ContradictionException {
        int i;
        ISetIterator iSetIterator = this.getPotentialPredecessorOf(node).iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            this.doRemoveEdge(i, node);
        }
        iSetIterator = this.getPotentialSuccessorsOf(node).iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            this.doRemoveEdge(node, i);
        }
        return !this.getPotentialNodes().contains(node);
    }

    @Override
    protected boolean doEnforceNode(int node) throws ContradictionException {
        boolean b = this.graphVar.enforceNode(node, this);
        if (!this.getLB().getNodes().contains(node)) {
            ISet potPred = this.getPotentialPredecessorOf(node);
            ISet potSucc = this.getPotentialSuccessorsOf(node);
            if (potPred.size() == 0 && potSucc.size() == 1) {
                b = this.graphVar.enforceEdge(node, potSucc.newIterator().nextInt(), this) || b;
            } else if (potPred.size() == 1 && potSucc.size() == 0) {
                b = this.graphVar.enforceEdge(potPred.newIterator().nextInt(), node, this) || b;
            } else {
                this.enforceNodes.add(node);
            }
        }
        return b;
    }

    @Override
    protected boolean doRemoveEdge(int from, int to) throws ContradictionException {
        return this.graphVar.removeEdge(from, to, this);
    }

    @Override
    protected boolean doEnforceEdge(int from, int to) throws ContradictionException {
        return this.graphVar.enforceEdge(from, to, this);
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if ((event.getMask() & GraphEventType.ADD_EDGE.getMask()) > 0) {
            this.notifyPropagators(GraphEventType.ADD_NODE, this);
        }
        if ((event.getMask() & GraphEventType.REMOVE_EDGE.getMask()) > 0) {
            ISetIterator iSetIterator = this.enforceNodes.iterator();
            while (iSetIterator.hasNext()) {
                int node = (Integer)iSetIterator.next();
                ISet potPred = this.getPotentialPredecessorOf(node);
                ISet potSucc = this.getPotentialSuccessorsOf(node);
                if (potPred.size() == 0 && potSucc.size() == 1) {
                    this.graphVar.enforceEdge(node, potSucc.newIterator().nextInt(), this);
                    this.enforceNodes.remove(node);
                    continue;
                }
                if (potPred.size() != 1 || potSucc.size() != 0) continue;
                this.graphVar.enforceEdge(potPred.newIterator().nextInt(), node, this);
                this.enforceNodes.remove(node);
            }
            this.notifyPropagators(GraphEventType.REMOVE_NODE, this);
        }
        this.notifyPropagators(event, this);
    }

    @Override
    public IGraphDeltaMonitor monitorDelta(ICause propagator) {
        return new DirectedEdgeInducedSubgraphMonitor(this, this.graphVar.monitorDelta(propagator));
    }

    static class DirectedEdgeInducedSubgraphMonitor
    extends GraphViewDeltaMonitor {
        TIntIntHashMap nodes;
        DirectedEdgeInducedSubgraphView g;
        PairProcedure filter;

        DirectedEdgeInducedSubgraphMonitor(DirectedEdgeInducedSubgraphView g, IGraphDeltaMonitor ... deltaMonitors) {
            super(deltaMonitors);
            this.g = g;
            this.nodes = new TIntIntHashMap(8);
            this.filter = (from, to) -> {
                if (g.exclude && !g.successors[from].contains(to) || !g.exclude && g.successors[from].contains(to)) {
                    if (!this.nodes.containsKey(from)) {
                        this.nodes.put(from, 1);
                    } else {
                        this.nodes.put(from, this.nodes.get(from) + 1);
                    }
                    if (!this.nodes.containsKey(to)) {
                        this.nodes.put(to, 1);
                    } else {
                        this.nodes.put(to, this.nodes.get(to) + 1);
                    }
                }
            };
        }

        @Override
        public void forEachNode(IntProcedure proc, GraphEventType evt) throws ContradictionException {
            block3: {
                block2: {
                    this.nodes.clear();
                    this.deltaMonitors[0].forEachEdge(this.filter, evt == GraphEventType.ADD_NODE ? GraphEventType.ADD_EDGE : GraphEventType.REMOVE_EDGE);
                    if (evt != GraphEventType.ADD_NODE) break block2;
                    for (int node : this.nodes.keys()) {
                        if (this.nodes.get(node) != this.g.getMandatoryPredecessorsOf(node).size() + this.g.getMandatorySuccessorsOf(node).size()) continue;
                        proc.execute(node);
                    }
                    break block3;
                }
                if (evt != GraphEventType.REMOVE_NODE) break block3;
                for (int node : this.nodes.keys()) {
                    if (this.g.getPotentialNodes().contains(node)) continue;
                    proc.execute(node);
                }
            }
        }

        @Override
        public void forEachEdge(PairProcedure proc, GraphEventType evt) throws ContradictionException {
            this.deltaMonitors[0].forEachEdge((from, to) -> {
                if (this.g.exclude && !this.g.successors[from].contains(to) || !this.g.exclude && this.g.successors[from].contains(to)) {
                    proc.execute(from, to);
                }
            }, evt);
        }
    }
}

