/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.extend;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.Transaction;
import eu.kliegr.ac1.rule.Antecedent;
import eu.kliegr.ac1.rule.CBARuleComparator;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.RuleInt;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.RuleQuality;
import eu.kliegr.ac1.rule.extend.ExtendRuleAnnotation;
import eu.kliegr.ac1.rule.extend.ExtendRuleConfig;
import eu.kliegr.ac1.rule.extend.ExtendType;
import eu.kliegr.ac1.rule.extend.History;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import eu.kliegr.ac1.rule.parsers.GUHASerializerWithAnnotationSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class ExtendRule
implements RuleInt {
    private static final Logger LOGGER = Logger.getLogger(ExtendRule.class.getName());
    private ExtendRuleConfig extensionConfig;
    private Float confidenceOfSeedRule;
    protected Rule rule;
    private ExtendType extendType;
    public RuleMultiItem lastExtension;
    private History history;

    public float getConfidenceOfSeedRule() {
        return this.confidenceOfSeedRule.floatValue();
    }

    public ExtendRuleConfig getExtendRuleConfig() {
        return this.extensionConfig;
    }

    private static Antecedent constructNewAntecedent(Antecedent antecedent, RuleMultiItem extension) {
        HashMap<Attribute, RuleMultiItem> extensionMap = new HashMap<Attribute, RuleMultiItem>();
        extensionMap.put(extension.getAttribute(), extension);
        return ExtendRule.constructNewAntecedent(antecedent, extensionMap);
    }

    private static Antecedent constructNewAntecedent(Antecedent antecedent, HashMap<Attribute, RuleMultiItem> replacement) {
        ArrayList<RuleMultiItem> newAntecedentItems = new ArrayList<RuleMultiItem>();
        antecedent.getItems().stream().forEach(multiitem -> {
            if (replacement.containsKey(multiitem.getAttribute())) {
                newAntecedentItems.add((RuleMultiItem)replacement.get(multiitem.getAttribute()));
            } else {
                newAntecedentItems.add((RuleMultiItem)multiitem);
            }
        });
        return new Antecedent(newAntecedentItems);
    }

    private static Antecedent constructNewAntecedent(Antecedent antecedent, Attribute attributeToRemove) {
        ArrayList<RuleMultiItem> newAntecedentItems = new ArrayList<RuleMultiItem>();
        antecedent.getItems().stream().forEach(multiitem -> {
            if (attributeToRemove != multiitem.getAttribute()) {
                newAntecedentItems.add((RuleMultiItem)multiitem);
            }
        });
        return new Antecedent(newAntecedentItems);
    }

    public ExtendRule(Rule rule) {
        this.rule = rule;
    }

    public ExtendRule(Rule rule, History history, ExtendType type, ExtendRuleConfig conf) {
        this.rule = rule;
        this.extendType = type;
        this.extensionConfig = conf;
        this.updateQuality();
        this.confidenceOfSeedRule = Float.valueOf(rule.getConfidence());
        this.history = history == null ? new History(this.rule.getRID()) : history;
        this.history.addRuleIdentifiers(this.rule.getERID(), this.rule.toArray());
        LOGGER.fine(rule.toString());
    }

    public ExtendRule(Rule rule, HashMap<Attribute, RuleMultiItem> extension, History history, ExtendType type, ExtendRuleConfig extensionConfig, float seedRuleConfidence) {
        this.rule = new Rule(ExtendRule.constructNewAntecedent(rule.getAntecedent(), extension), rule.getConsequent(), null, null, rule.getRID(), Rule.getNextERID(), rule.getData());
        this.extendType = type;
        this.extensionConfig = extensionConfig;
        this.confidenceOfSeedRule = Float.valueOf(seedRuleConfidence);
        this.lastExtension = null;
        LOGGER.fine(rule.toString());
        this.rule.setQuality(this.computeQuality());
        this.history = history == null ? new History(this.getRID()) : history;
        this.history.addRuleIdentifiers(rule.getERID(), rule.toArray());
    }

    public ExtendRule(Rule rule, Attribute atToRemove, History history, ExtendType type, ExtendRuleConfig extensionConfig, float seedRuleConfidence) {
        this.rule = new Rule(ExtendRule.constructNewAntecedent(rule.getAntecedent(), atToRemove), rule.getConsequent(), null, null, rule.getRID(), Rule.getNextERID(), rule.getData());
        this.extendType = type;
        this.extensionConfig = extensionConfig;
        this.confidenceOfSeedRule = Float.valueOf(seedRuleConfidence);
        this.lastExtension = null;
        LOGGER.fine(rule.toString());
        this.rule.setQuality(this.computeQuality());
        this.history = history == null ? new History(this.getRID()) : history;
        this.history.addRuleIdentifiers(rule.getERID(), rule.toArray());
    }

    public ExtendRule(Rule rule, RuleMultiItem extension, History history, ExtendType type, ExtendRuleConfig extensionConfig, float seedRuleConfidence) {
        this.rule = new Rule(ExtendRule.constructNewAntecedent(rule.getAntecedent(), extension), rule.getConsequent(), null, null, rule.getRID(), Rule.getNextERID(), rule.getData());
        this.extendType = type;
        this.extensionConfig = extensionConfig;
        this.confidenceOfSeedRule = Float.valueOf(seedRuleConfidence);
        this.lastExtension = extension;
        LOGGER.fine(rule.toString());
        this.rule.setQuality(this.computeQuality());
        this.history = history == null ? new History(this.getRID()) : history;
        this.history.addRuleIdentifiers(rule.getERID(), rule.toArray());
    }

    public ExtendRule(Antecedent antecedent, Consequent cons, History history, ExtendType type, Data data, ExtendRuleConfig conf, int seedRuleRID) {
        this.rule = new Rule(antecedent, cons, null, null, seedRuleRID, Rule.getNextERID(), data);
        this.extendType = type;
        this.extensionConfig = conf;
        this.lastExtension = null;
        this.rule.setQuality(this.computeQuality());
        this.history = history == null ? new History(this.getRID()) : history;
        this.history.addRuleIdentifiers(this.rule.getERID(), this.rule.toArray());
        LOGGER.fine(this.rule.toString());
    }

    public Rule getRule() {
        return this.rule;
    }

    public ExtendRule enlargeLastExtension() {
        RuleMultiItem nextExtension = this.lastExtension.getExtended(this.lastExtension.lastModificationType);
        if (nextExtension == null) {
            LOGGER.fine("No more values");
            return null;
        }
        return new ExtendRule(this.rule, nextExtension, this.copyHistory(), this.extendType, this.extensionConfig, this.getConfidenceOfSeedRule());
    }

    public void generateAnnotation(ArrayList<Consequent> consequents) {
        LOGGER.log(Level.INFO, "Generate annotation started for rule {0}", this);
        ExtendRuleAnnotation annot = new ExtendRuleAnnotation();
        annot.generate(this, consequents);
        this.rule.setAnnotation(annot);
        LOGGER.info("Generate annotation finished");
        LOGGER.fine(this.toString());
    }

    public ExtendRuleAnnotation getAnnotation() {
        return this.rule.getAnnotation();
    }

    public ExtendRule extend() {
        if (!this.isExtendable()) {
            return this;
        }
        boolean extensionSuccessful = false;
        ExtendRule curAcceptedExtension = this;
        LOGGER.fine("*************************************");
        LOGGER.log(Level.FINE, "STARTED Extension on rule: {0}\n", curAcceptedExtension);
        do {
            LOGGER.finest("*************************************");
            LOGGER.log(Level.FINEST, "Computing neigbourhood for seed rule:{0}\n", curAcceptedExtension);
            ArrayList<ExtendRule> curNeighbourhood = curAcceptedExtension.getNeighourhood();
            LOGGER.log(Level.FINEST, "Candidate rules:{0}", curNeighbourhood.size());
            LOGGER.finest("Finished computing neigbourhood");
            curNeighbourhood.sort(new CBARuleComparator());
            extensionSuccessful = false;
            for (ExtendRule candExt : curNeighbourhood) {
                LOGGER.finest("+++++++++++++++++++++++++++++++++++++");
                LOGGER.log(Level.FINEST, "Current extension candidate {0}", candExt);
                LOGGER.finest("+++++++++++++++++++++++++++++++++++++");
                if (this.extensionConfig.acceptRule(candExt.getConfidence(), curAcceptedExtension.getConfidence(), this.getConfidenceOfSeedRule(), candExt.getSupport(), curAcceptedExtension.getSupport())) {
                    extensionSuccessful = true;
                    curAcceptedExtension = candExt;
                    break;
                }
                if (this.extensionConfig.conditionalAcceptRule(candExt.getConfidence(), curAcceptedExtension.getConfidence())) {
                    LOGGER.finest("Trying additional extensions to reach crisp accept");
                    ExtendRule candExtEnlargement = candExt;
                    do {
                        if ((candExtEnlargement = candExtEnlargement.enlargeLastExtension()) == null) {
                            LOGGER.finest("-->Exhausted all values on this attribute in this direction, without finding acceptable candidate<--");
                            break;
                        }
                        LOGGER.log(Level.FINEST, "Evaluating extension: {0}", candExtEnlargement);
                        if (!this.extensionConfig.acceptRule(candExtEnlargement.getConfidence(), curAcceptedExtension.getConfidence(), this.getConfidenceOfSeedRule(), candExtEnlargement.getSupport(), curAcceptedExtension.getSupport())) continue;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Accepting:{0}", candExtEnlargement);
                        }
                        curAcceptedExtension = candExtEnlargement;
                        extensionSuccessful = true;
                        break;
                    } while (this.extensionConfig.conditionalAcceptRule(candExtEnlargement.getConfidence(), curAcceptedExtension.getConfidence()));
                    if (!extensionSuccessful) continue;
                    break;
                }
                LOGGER.finest("Improvement below conditional threshold, going to next candidate");
            }
            LOGGER.finest("Candidates exhausted or candidate accepted");
        } while (extensionSuccessful);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "-->Finished extension on rule {0}<--", this.rule);
            LOGGER.log(Level.FINE, "*Result: {0}", curAcceptedExtension);
            LOGGER.log(Level.FINE, "*History: \n {0}", curAcceptedExtension.history.toString());
            LOGGER.log(Level.FINE, "*End of history");
        }
        curAcceptedExtension.addItselfToHistory();
        return curAcceptedExtension;
    }

    public ExtendRule addFuzzyBorders() {
        ArrayList<RuleMultiItem> newConsitutents = new ArrayList<RuleMultiItem>();
        this.getAntecedent().getItems().stream().forEach(ruleConstituent -> {
            RuleMultiItem extendedWithFuzzyBorder = ruleConstituent.getExtended(ValueOrigin.fuzzy_border);
            if (extendedWithFuzzyBorder != null) {
                newConsitutents.add(extendedWithFuzzyBorder);
            } else {
                LOGGER.log(Level.FINE, "Fuzzy border not added for item {0}", ruleConstituent);
                newConsitutents.add((RuleMultiItem)ruleConstituent);
            }
        });
        ExtendRule withfuzzyBorders = new ExtendRule(new Antecedent(newConsitutents), this.getConsequent(), this.copyHistory(), this.extendType, this.rule.getData(), this.extensionConfig, this.rule.getRID());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Finished creating version with fuzzy borders");
            LOGGER.log(Level.FINE, "*Result:{0}", withfuzzyBorders);
        }
        return withfuzzyBorders;
    }

    public History copyHistory() {
        return this.history.copy();
    }

    public void addItselfToHistory() {
        this.history.addRuleIdentifiers(this.rule.getERID(), this.rule.toArray());
    }

    public boolean isExtendable() {
        LOGGER.log(Level.FINE, "Checking rule {0} if it meets extensibility criteria.", this.rule);
        if (this.rule.getAntecedent().getItems().isEmpty()) {
            LOGGER.fine("Rules with empty antecedent cannot be extended.");
            return false;
        }
        for (RuleMultiItem rmi : this.rule.getAntecedent().getItems()) {
            Attribute at = rmi.getAttribute();
            AttributeValue lastVal = null;
            for (AttributeValue val : rmi.getAttributeValues()) {
                if (lastVal == null || at.getAdjacentHigher(lastVal) == val) continue;
                LOGGER.log(Level.SEVERE, "Problem found for attribute {0}", at);
                LOGGER.log(Level.SEVERE, "Value {0} is not higher than {1}", new Object[]{val, lastVal});
                throw new UnsupportedOperationException("Rule contains values, which are not adjacent. This is not supported.");
            }
        }
        LOGGER.log(Level.FINE, "Rule {0} meets extensibility criteria", this.rule);
        return true;
    }

    public void updateQuality() {
        this.rule.setQuality(this.computeQuality());
    }

    @Override
    public Node getXMLRepresentation() {
        GUHASerializerWithAnnotationSupport serializer = new GUHASerializerWithAnnotationSupport();
        try {
            Document newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node thisRuleAsXML = serializer.getXMLforRule(this.rule, newXmlDocument);
            return thisRuleAsXML;
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(ExtendRule.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ArrayList<ExtendRule> getNeighourhood() {
        ArrayList<ExtendRule> neighborhood = new ArrayList<ExtendRule>();
        this.getAntecedent().getItems().stream().filter(ruleConstituent -> this.extendType != ExtendType.numericOnly || ruleConstituent.getAttribute().getType() != AttributeType.nominal).map(ruleConstituent -> ruleConstituent.getNeighbourhood()).forEach(neighbourhood -> neighbourhood.stream().forEach(multiitem -> neighborhood.add(new ExtendRule(this.rule, (RuleMultiItem)multiitem, this.copyHistory(), this.extendType, this.extensionConfig, this.getConfidenceOfSeedRule()))));
        return neighborhood;
    }

    public RuleQuality getRuleQuality() {
        return this.rule.getQuality();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rule.toString(true));
        sb.append(this.history.toString());
        return sb.toString();
    }

    public int removeTransactionsCoveredByAntecedent(Boolean hide) {
        int pruningCoverage = 0;
        try {
            Set<Transaction> supportingTransactions = this.getAntecedent().getSupportingTransactions();
            if (this.getAntecedent() == null) {
                pruningCoverage = this.rule.getData().getDataTable().getAllCurrentTransactions().size();
                this.rule.getData().getDataTable().removeAllTransactions(hide);
            } else {
                pruningCoverage = supportingTransactions.size();
                if (pruningCoverage > 0) {
                    supportingTransactions.stream().forEach(t -> this.rule.getData().getDataTable().removeTransaction((Transaction)t, hide));
                }
            }
        }
        catch (NoSuchElementException e) {
            LOGGER.warning(e.toString());
            pruningCoverage = 0;
        }
        return pruningCoverage;
    }

    public int removeCorrectlyClassifiedTransactions(Boolean hide) {
        int pruningCoverage = 0;
        try {
            Set<Transaction> antConOverlap = this.getAntecedent().getSupportingTransactions();
            Set<Transaction> conTran = this.getConsequent().getSupportingTransactions();
            if (antConOverlap == null) {
                antConOverlap = conTran;
            } else {
                antConOverlap.retainAll(conTran);
            }
            Set<Transaction> supportingTransactions = antConOverlap;
            pruningCoverage = supportingTransactions.size();
            if (pruningCoverage > 0) {
                supportingTransactions.stream().forEach(t -> this.rule.getData().getDataTable().removeTransaction((Transaction)t, hide));
            }
            return pruningCoverage;
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public ExtendRule removeRedundantAttributes() {
        boolean ruleChanged = false;
        LOGGER.log(Level.INFO, "STARTED REMOVING REDUNDANT ATTRIBUTES on rule: {0}\n", this.rule);
        Set<Transaction> correctlyCoveredTrans = this.getAntecedent().getSupportingTransactions();
        Set<Transaction> conTran = this.getConsequent().getSupportingTransactions();
        ExtendRule newRule = this;
        if (correctlyCoveredTrans == null | correctlyCoveredTrans.isEmpty()) {
            LOGGER.info("Rule does not cover any transactions, leaving as is");
        } else {
            correctlyCoveredTrans.retainAll(conTran);
            if (correctlyCoveredTrans.isEmpty()) {
                LOGGER.info("Rule does not CORRECTLY cover any transactions, leaving as is");
            } else if (this.rule.getAntecedent().getItems().isEmpty()) {
                LOGGER.fine("Rule with empty antecedent.");
            } else {
                boolean attrRemoved = false;
                block0: do {
                    for (RuleMultiItem rmi : newRule.getAntecedent().getItems()) {
                        LOGGER.fine("Considering removal of literal created from attribute " + rmi.getAttribute());
                        ExtendRule candNewRule = new ExtendRule(newRule.getRule(), rmi.getAttribute(), this.copyHistory(), this.getExtendType(), this.extensionConfig, -1.0f);
                        candNewRule.updateQuality();
                        if (this.getConfidence() <= candNewRule.getConfidence()) {
                            LOGGER.fine("Confidence did not decrease after removing literal " + rmi + " from " + this.getConfidence() + " to " + candNewRule.getConfidence());
                            attrRemoved = true;
                            ruleChanged = true;
                            newRule = candNewRule;
                            continue block0;
                        }
                        attrRemoved = false;
                    }
                } while (attrRemoved && newRule.getAntecedent().getItems().size() > 0);
            }
        }
        if (!ruleChanged) {
            LOGGER.fine("Rule did not change during attribute pruning");
            return this;
        }
        return newRule;
    }

    public ExtendRule trim() {
        boolean ruleChanged = false;
        LOGGER.log(Level.INFO, "STARTED TRIMMING on rule: {0}\n", this.rule);
        Set<Transaction> correctlyCoveredTrans = this.getAntecedent().getSupportingTransactions();
        Set<Transaction> conTran = this.getConsequent().getSupportingTransactions();
        HashMap<Attribute, RuleMultiItem> newLiterals = new HashMap<Attribute, RuleMultiItem>();
        if (correctlyCoveredTrans == null | correctlyCoveredTrans.isEmpty()) {
            LOGGER.info("Rule does not cover any transactions, leaving as is");
        } else {
            correctlyCoveredTrans.retainAll(conTran);
            if (correctlyCoveredTrans.isEmpty()) {
                LOGGER.info("Rule does not CORRECTLY cover any transactions, leaving as is");
            } else if (this.rule.getAntecedent().getItems().isEmpty()) {
                LOGGER.fine("Rules with empty antecedent cannot be trimmed.");
            } else {
                for (RuleMultiItem rmi : this.rule.getAntecedent().getItems()) {
                    Attribute at = rmi.getAttribute();
                    LOGGER.log(Level.FINE, "Processing attribute: {0}", at.getName());
                    if (at.getType() == AttributeType.nominal) {
                        LOGGER.fine("Skipping nominal attribute.");
                        newLiterals.put(rmi.getAttribute(), rmi);
                        continue;
                    }
                    ArrayList<AttributeValue> attVals = rmi.getAttributeValues();
                    if (attVals.size() == 1) {
                        LOGGER.fine("Literals with single value cannot be trimmed.");
                        newLiterals.put(rmi.getAttribute(), rmi);
                        continue;
                    }
                    if (attVals.isEmpty()) {
                        LOGGER.warning("Literal with no value!");
                        newLiterals.put(rmi.getAttribute(), rmi);
                        continue;
                    }
                    ArrayList coveredValues = new ArrayList();
                    correctlyCoveredTrans.stream().forEach(t -> coveredValues.add(t.getValue(at)));
                    LOGGER.log(Level.FINE, "correctlyCoveredTrans: {0}", correctlyCoveredTrans.size());
                    Collections.sort(coveredValues, new Comparator<AttributeValue>(){

                        @Override
                        public int compare(AttributeValue o1, AttributeValue o2) {
                            return Float.compare(o1.getNumericalValue().floatValue(), o2.getNumericalValue().floatValue());
                        }
                    });
                    AttributeValue lowestValue = (AttributeValue)coveredValues.get(0);
                    AttributeValue highestValue = (AttributeValue)coveredValues.get(coveredValues.size() - 1);
                    AttributeValue origMin = rmi.getAttributeValues().get(0);
                    AttributeValue origMax = rmi.getAttributeValues().get(rmi.getAttributeValues().size() - 1);
                    if (origMin == lowestValue && highestValue == origMax) {
                        LOGGER.fine("Trimming produced same literal as original.");
                        newLiterals.put(rmi.getAttribute(), rmi);
                        continue;
                    }
                    ArrayList<AttributeValue> list = new ArrayList<AttributeValue>(at.getValuesInRange(lowestValue.getNumericalValue(), true, highestValue.getNumericalValue(), true));
                    ArrayList<ValueOrigin> valOriginAsArray = new ArrayList<ValueOrigin>();
                    for (AttributeValue av : list) {
                        valOriginAsArray.add(ValueOrigin.core);
                    }
                    RuleMultiItem replacement = this.rule.getData().makeRuleItem(list, valOriginAsArray, at, ValueOrigin.trim);
                    newLiterals.put(replacement.getAttribute(), replacement);
                    ruleChanged = true;
                }
            }
        }
        if (!ruleChanged) {
            LOGGER.fine("Rule did not change during trimming");
            return this;
        }
        ExtendRule newRule = new ExtendRule(this.rule, newLiterals, this.copyHistory(), this.getExtendType(), this.extensionConfig, -1.0f);
        newRule.updateQuality();
        if (this.getConfidence() != newRule.getConfidence()) {
            LOGGER.fine("Confidence changed after trimming from " + this.getConfidence() + " to " + newRule.getConfidence());
        }
        newRule.confidenceOfSeedRule = Float.valueOf(newRule.getConfidence());
        LOGGER.log(Level.INFO, "FINISHED TRIMMING, result: {0}\n", newRule);
        return newRule;
    }

    private RuleQuality computeQuality() {
        int support;
        int coverage;
        Set<Transaction> antConOverlap = this.getAntecedent().getSupportingTransactions();
        Set<Transaction> conTran = this.getConsequent().getSupportingTransactions();
        if (antConOverlap != null) {
            coverage = antConOverlap.size();
            antConOverlap.retainAll(conTran);
            support = antConOverlap.size();
        } else {
            coverage = this.rule.data.getDataTable().getCurrentTransactionCount();
            support = conTran.size();
        }
        return new RuleQuality(support, coverage - support, this.rule.getData().getDataTable().getLoadedTransactionCount());
    }

    @Override
    public int getAntecedentLength() {
        return this.rule.getAntecedentLength();
    }

    @Override
    public float getConfidence() {
        return this.rule.getConfidence();
    }

    @Override
    public Consequent getConsequent() {
        return this.rule.getConsequent();
    }

    @Override
    public Antecedent getAntecedent() {
        return this.rule.getAntecedent();
    }

    @Override
    public int getRID() {
        return this.rule.getRID();
    }

    @Override
    public int getSupport() {
        return this.rule.getSupport();
    }

    public ExtendType getExtendType() {
        return this.extendType;
    }

    public String getArulesRepresentation() {
        return this.rule.getArulesRepresentation();
    }
}

