/*
 * Decompiled with CFR 0.152.
 */
package dsa;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NodeInfoModel {
    private static final Logger logger = Logger.getLogger(NodeInfoModel.class.getName());
    private final String title;
    private final String tooltip;
    private final String[] labels;
    private final Map<String, Document> documents;
    private final PropertyChangeSupport changeSupport;
    private Icon image;

    public NodeInfoModel(String title, String tooltip, String ... labels) {
        this.title = title;
        this.tooltip = tooltip;
        this.labels = labels;
        this.changeSupport = new PropertyChangeSupport(this);
        this.documents = new HashMap<String, Document>();
        for (String label : labels) {
            this.documents.put(label, new PlainDocument());
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public Document getDocument(String label) {
        return this.documents.get(label);
    }

    public Icon getImage() {
        return this.image;
    }

    public void update(Icon image, Map<String, String> newdata) {
        logger.log(Level.FINE, "new data has arrived");
        this.image = image;
        for (String label : this.labels) {
            Document doc = this.documents.get(label);
            try {
                doc.remove(0, doc.getLength());
                String value = newdata.get(label);
                if (value == null || !(value instanceof String)) continue;
                doc.insertString(0, value, null);
            }
            catch (BadLocationException ble) {
                logger.log(Level.SEVERE, "caught unexpected exception", ble);
            }
        }
        this.changeSupport.firePropertyChange("imageChange", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }
}

