# o2geosocial 1.1.2
* Resubmission following CRAN archive

# o2geosocial 1.1.1
* Fix: Update `Rcpp` to remove warnings

# o2geosocial 1.1.0

## Major Changes

* Change the calculation and format of the connectivity matrix ("param$log_s_dens"): param$log_s_dens now contains the probability of connection between regions (rather than the log-probability) if "kappa = 1". If there is a missing generation between two connected cases (i.e. "kappa = 2"), the spatial likelihood is computed in src/likelihoods.cpp.
* Speed up the exploration of potential infectors (in "cpp_move_alpha()" and "cpp_move_ancestors()") by computing the genotype reported in each tree.
* In R/outbreaker_find_imports.R: imported cases do not influence the computation of "threshold" (i.e. the threshold of plausibility of a connection between cases) since they are by definition not infected by any case (and their likelihood is de facto smaller).

## Minor Changes
* Add parameter "outlier_plot" to "create_config()": if TRUE, the likelihoods of connection are plotted after the first short run ("outbreaker_find_imports()")
* Add a message to indicate how many imports were added after the first run (in R/outbreaker_find_imports.R)
* If "config$outlier_relative == T", the same threshold of plausibility is used in R/outbreaker_find_imports.R and R/outbreaker_move.R.
* Add "cpp_gen_tree()" in src/internals.cpp: function for internal use that calculates the genotype reported in a given tree.

## Bug Fixes
* Fix: In R/outbreaker_find_imports.R, if "max(data$is_cluster)" was equal to 1, "list_influences" was initialised as a matrix, now it is always a list.
* Fix: In R/outbreaker_data.R: modify "final_index" to change how the tail of "w_dens" is calculated and avoid log(w_dens) = -Inf.
* Fix: In R/custom_likelihoods.R: Change the number of arguments needed to customise likelihood functions.
* Fix: In certain situations, some of the initial trees (generated by "create_config()") contained more than one genotype reported per tree.
* Fix: In R/outbreaker_find_imports.R and R/outbreaker_move.R, change the calculation of "n_measures"
* Fix various typos.

# o2geosocial 1.0.2
* Fix: "f_dens" refers to the "incubation period", not the "colonization time"

# o2geosocial 1.0.1

* Fix: Remove dependencies to unused packages in DESCRIPTION File.
* Fix: Remove checks in cpp_move_swap_cases.
* Fix: Consensus tree for imported cases in "summary()": the value of the column "from" for an imported case is now NA.

# o2geosocial 1.0.0

* initial release
