/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.ChiDist;
import umontreal.iro.lecuyer.randvar.ChiGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ChiRatioOfUniformsGen
extends ChiGen {
    public ChiRatioOfUniformsGen(RandomStream s, int nu) {
        super(s, null);
        this.setParams(nu);
    }

    public ChiRatioOfUniformsGen(RandomStream s, ChiDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getNu());
        }
    }

    public double nextDouble() {
        return ChiRatioOfUniformsGen.ratioOfUniforms(this.stream, this.nu);
    }

    public static double nextDouble(RandomStream s, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        return ChiRatioOfUniformsGen.ratioOfUniforms(s, nu);
    }

    private static double ratioOfUniforms(RandomStream stream, int nu) {
        double z;
        block7: {
            if (nu == 1) {
                while (true) {
                    double u = stream.nextDouble();
                    double v = stream.nextDouble() * 0.857763884960707;
                    z = v / u;
                    if (z < 0.0) continue;
                    double zz = z * z;
                    double r = 2.5 - zz;
                    if (z < 0.0) {
                        r += zz * z / (3.0 * z);
                    }
                    if (u < r * 0.3894003915 || !(zz > 1.036961043 / u + 1.4) && 2.0 * Math.log(u) < -zz * 0.5) break;
                }
            } else {
                double vm1;
                double b = Math.sqrt((double)nu - 1.0);
                double vm = -b > (vm1 = -0.6065306597 * (1.0 - 0.25 / (b * b + 1.0))) ? -b : vm1;
                double vp = 0.6065306597 * (0.7071067812 + b) / (0.5 + b);
                double vd = vp - vm;
                while (true) {
                    double u = stream.nextDouble();
                    double v = stream.nextDouble() * vd + vm;
                    z = v / u;
                    if (z < -b) continue;
                    double zz = z * z;
                    double r = 2.5 - zz;
                    if (z < 0.0) {
                        r += zz * z / (3.0 * (z + b));
                    }
                    if (u < r * 0.3894003915) {
                        z += b;
                        break block7;
                    }
                    if (!(zz > 1.036961043 / u + 1.4) && 2.0 * Math.log(u) < Math.log(1.0 + z / b) * b * b - zz * 0.5 - z * b) break;
                }
                z += b;
            }
        }
        return z;
    }
}

